/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.nio.file.Path;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class WriteTestSupport
implements KernelAPIWriteTestSupport {
    private GraphDatabaseService db;
    protected DatabaseManagementService managementService;

    @Override
    public void setup(Path storeDir, Consumer<GraphDatabaseService> sysCreate) {
        TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.newManagementServiceBuilder(storeDir);
        this.managementService = this.configure(databaseManagementServiceBuilder).build();
        this.db = this.managementService.database("neo4j");
        try (KernelTransaction tx = this.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            tokenWrite.propertyKeyCreateForName("DO_NOT_USE", false);
            tokenWrite.labelCreateForName("DO_NOT_USE", false);
            tokenWrite.relationshipTypeCreateForName("DO_NOT_USE", false);
        }
        catch (KernelException e) {
            throw new AssertionError("Failed to setup database", e);
        }
        GraphDatabaseService sysDb = this.managementService.database("system");
        sysCreate.accept(sysDb);
    }

    protected TestDatabaseManagementServiceBuilder newManagementServiceBuilder(Path storeDir) {
        return new TestDatabaseManagementServiceBuilder(storeDir).impermanent();
    }

    protected TestDatabaseManagementServiceBuilder configure(TestDatabaseManagementServiceBuilder builder) {
        return builder;
    }

    @Override
    public void clearGraph() {
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this.db);
    }

    @Override
    public Kernel kernelToTest() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.db).getDependencyResolver();
        return (Kernel)resolver.resolveDependency(Kernel.class);
    }

    private KernelTransaction beginTransaction() throws TransactionFailureException {
        return this.kernelToTest().beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
    }

    @Override
    public GraphDatabaseService graphBackdoor() {
        return this.db;
    }

    @Override
    public void tearDown() {
        this.managementService.shutdown();
        this.db = null;
    }
}

