/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureKernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ExecutionContextProcedureTransactionIT {
    @Inject
    private GraphDatabaseAPI db;

    ExecutionContextProcedureTransactionIT() {
    }

    @Test
    void testGettingAllNodes() {
        ArrayList<String> nodeIds = new ArrayList<String>();
        try (Transaction tx = this.db.beginTx();){
            nodeIds.add(tx.createNode().getElementId());
            nodeIds.add(tx.createNode().getElementId());
            nodeIds.add(tx.createNode().getElementId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            List retrievedIds = ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllNodes().stream().map(Entity::getElementId).collect(Collectors.toList());
            Assertions.assertThat(retrievedIds).containsExactlyInAnyOrderElementsOf(nodeIds);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testGettingAllRelationships() {
        ArrayList<String> relIds = new ArrayList<String>();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            relIds.add(node.createRelationshipTo(node, RelationshipType.withName((String)"T1")).getElementId());
            relIds.add(node.createRelationshipTo(node, RelationshipType.withName((String)"T2")).getElementId());
            relIds.add(node.createRelationshipTo(node, RelationshipType.withName((String)"T3")).getElementId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            List retrievedIds = ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllRelationships().stream().map(Entity::getElementId).collect(Collectors.toList());
            Assertions.assertThat(retrievedIds).containsExactlyInAnyOrderElementsOf(relIds);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListLabels() {
        String nodeId;
        Label label1 = Label.label((String)"label1");
        Label label2 = Label.label((String)"label2");
        try (Transaction tx = this.db.beginTx();){
            nodeId = tx.createNode(new Label[]{label1, label2}).getElementId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllLabels()).containsExactlyInAnyOrder((Object[])new Label[]{label1, label2});
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllLabelsInUse()).containsExactlyInAnyOrder((Object[])new Label[]{label1, label2});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeByElementId(nodeId).removeLabel(label1);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllLabels()).containsExactlyInAnyOrder((Object[])new Label[]{label1, label2});
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllLabelsInUse()).containsExactlyInAnyOrder((Object[])new Label[]{label2});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListRelationshipTypes() {
        String relId;
        RelationshipType type1 = RelationshipType.withName((String)"TYPE1");
        RelationshipType type2 = RelationshipType.withName((String)"TYPE2");
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            relId = node.createRelationshipTo(node, type1).getElementId();
            node.createRelationshipTo(node, type2);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllRelationshipTypes()).containsExactlyInAnyOrder((Object[])new RelationshipType[]{type1, type2});
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllRelationshipTypesInUse()).containsExactlyInAnyOrder((Object[])new RelationshipType[]{type1, type2});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipByElementId(relId).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllRelationshipTypes()).containsExactlyInAnyOrder((Object[])new RelationshipType[]{type1, type2});
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllRelationshipTypesInUse()).containsExactlyInAnyOrder((Object[])new RelationshipType[]{type2});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldListPropertyKeys() {
        String nodeId;
        String key1 = "key1";
        String key2 = "key2";
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getElementId();
            node.setProperty(key1, (Object)"foo");
            node.setProperty(key2, (Object)"bar");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllPropertyKeys()).containsExactlyInAnyOrder((Object[])new String[]{key1, key2});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeByElementId(nodeId).removeProperty(key1);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllPropertyKeys()).containsExactlyInAnyOrder((Object[])new String[]{key1, key2});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldReadIndexesAndConstraints() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)"L")).on("prop").withName("MyIndex").create();
            tx.schema().constraintFor(Label.label((String)"M")).withName("MyConstraint").assertPropertyIsUnique("prop").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Schema schema = ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).schema();
            Assertions.assertThat((long)Iterables.count((Iterable)Iterables.filter(i -> i.getName().equals("MyIndex"), (Iterable)schema.getIndexes()))).isEqualTo(1L);
            Assertions.assertThat((String)((String)Iterables.single((Iterable)schema.getIndexByName("MyIndex").getPropertyKeys()))).isEqualTo("prop");
            Assertions.assertThat((String)((IndexDefinition)Iterables.single((Iterable)schema.getIndexes(Label.label((String)"L")))).getName()).isEqualTo("MyIndex");
            Assertions.assertThat((long)Iterables.count((Iterable)Iterables.filter(i -> i.getName().equals("MyConstraint"), (Iterable)schema.getConstraints()))).isEqualTo(1L);
            Assertions.assertThat((String)((String)Iterables.single((Iterable)schema.getConstraintByName("MyConstraint").getPropertyKeys()))).isEqualTo("prop");
            Assertions.assertThat((String)((ConstraintDefinition)Iterables.single((Iterable)schema.getConstraints(Label.label((String)"M")))).getName()).isEqualTo("MyConstraint");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAwaitIndexesToComeOnline() {
        Schema schema;
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)"L")).on("prop").withName("MyIndex").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            schema = ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).schema();
            schema.awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            schema = tx.schema();
            Assertions.assertThat((String)((String)Iterables.single((Iterable)schema.getIndexByName("MyIndex").getPropertyKeys()))).isEqualTo("prop");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotBeAbleToCreateNewIndexes() {
        try (Transaction tx = this.db.beginTx();){
            Schema schema = ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).schema();
            Assertions.assertThatThrownBy(() -> schema.indexFor(Label.label((String)"L")).on("prop").create()).isInstanceOf(UnsupportedOperationException.class);
            tx.commit();
        }
    }

    private static Transaction executionContextTransaction(Transaction tx) {
        InternalTransaction internalTx = (InternalTransaction)tx;
        KernelTransaction ktx = internalTx.kernelTransaction();
        internalTx.registerCloseableResource((AutoCloseable)ktx.acquireStatement());
        ExecutionContext executionContext = ktx.createExecutionContext();
        internalTx.registerCloseableResource(() -> {
            executionContext.complete();
            executionContext.close();
        });
        return new ExecutionContextProcedureTransaction(new ExecutionContextProcedureKernelTransaction(ktx, executionContext), null);
    }
}

