/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;

@ExtendWith(value={RandomExtension.class})
public abstract class AbstractIndexProvidedOrderTest
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final int N_ENTITIES = 10000;
    private static final int N_ITERATIONS = 100;
    private static final String TOKEN = "Node";
    private static final String PROPERTY_KEY = "prop";
    private static final String INDEX_NAME = "propIndex";
    private static final ValueType[] ALL_ORDERABLE = RandomValues.excluding((ValueType[])new ValueType[]{ValueType.STRING, ValueType.STRING_ARRAY, ValueType.GEOGRAPHIC_POINT, ValueType.GEOGRAPHIC_POINT_ARRAY, ValueType.GEOGRAPHIC_POINT_3D, ValueType.GEOGRAPHIC_POINT_3D_ARRAY, ValueType.CARTESIAN_POINT, ValueType.CARTESIAN_POINT_ARRAY, ValueType.CARTESIAN_POINT_3D, ValueType.CARTESIAN_POINT_3D_ARRAY, ValueType.DURATION, ValueType.DURATION_ARRAY, ValueType.PERIOD, ValueType.PERIOD_ARRAY});
    @Inject
    RandomSupport randomRule;
    private TreeSet<EntityValueTuple> singlePropValues = new TreeSet(ValueTuple.COMPARATOR);
    private ValueType[] targetedTypes;

    @Override
    public ReadTestSupport newTestSupport() {
        return new ReadTestSupport();
    }

    abstract EntityControl getEntityControl();

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            this.getEntityControl().createIndex(tx, TOKEN, PROPERTY_KEY, INDEX_NAME);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        RandomValues randomValues = this.randomRule.randomValues();
        this.targetedTypes = (ValueType[])randomValues.selection((Object[])ALL_ORDERABLE, 1, ALL_ORDERABLE.length, false);
        this.targetedTypes = this.ensureHighEnoughCardinality(this.targetedTypes);
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < 10000; ++i) {
                Value propValue;
                EntityValueTuple singleValue;
                Entity node = this.getEntityControl().createEntity(tx, TOKEN);
                do {
                    propValue = randomValues.nextValueOfTypes(this.targetedTypes);
                } while (this.singlePropValues.contains((Object)(singleValue = new EntityValueTuple(node.getId(), propValue))));
                this.singlePropValues.add(singleValue);
                node.setProperty(PROPERTY_KEY, propValue.asObject());
            }
            tx.commit();
        }
    }

    @Test
    void shouldProvideResultInOrderIfCapable() throws KernelException {
        int prop = this.token.propertyKey(PROPERTY_KEY);
        RandomValues randomValues = this.randomRule.randomValues();
        IndexReadSession index = this.read.indexReadSession(this.tx.schemaRead().indexGetForName(INDEX_NAME));
        for (int i = 0; i < 100; ++i) {
            ValueType type = (ValueType)randomValues.among((Object[])this.targetedTypes);
            this.expectResultInOrder(randomValues, type, prop, index, IndexOrder.ASCENDING);
            this.expectResultInOrder(randomValues, type, prop, index, IndexOrder.DESCENDING);
        }
    }

    private void expectResultInOrder(RandomValues randomValues, ValueType type, int prop, IndexReadSession index, IndexOrder indexOrder) throws KernelException {
        EntityValueTuple from = new EntityValueTuple(Long.MIN_VALUE, randomValues.nextValueOfType(type));
        EntityValueTuple to = new EntityValueTuple(Long.MAX_VALUE, randomValues.nextValueOfType(type));
        if (ValueTuple.COMPARATOR.compare(from, to) > 0) {
            EntityValueTuple tmp = from;
            from = to;
            to = tmp;
        }
        boolean fromInclusive = randomValues.nextBoolean();
        boolean toInclusive = randomValues.nextBoolean();
        PropertyIndexQuery.RangePredicate range = PropertyIndexQuery.range((int)prop, (Value)from.getOnlyValue(), (boolean)fromInclusive, (Value)to.getOnlyValue(), (boolean)toInclusive);
        List<Long> expectedIdsInOrder = this.expectedIdsInOrder(from, fromInclusive, to, toInclusive, indexOrder);
        List<Long> actualIdsInOrder = this.getEntityControl().findEntities(this.tx, this.cursors, index, indexOrder, range);
        ((ListAssert)Assertions.assertThat(actualIdsInOrder).as("actual node ids not in same order as expected for value type " + String.valueOf(type), new Object[0])).containsExactlyElementsOf(expectedIdsInOrder);
    }

    private List<Long> expectedIdsInOrder(EntityValueTuple from, boolean fromInclusive, EntityValueTuple to, boolean toInclusive, IndexOrder indexOrder) {
        List<Long> expectedIdsInOrder = this.singlePropValues.subSet(from, fromInclusive, to, toInclusive).stream().map(EntityValueTuple::nodeId).collect(Collectors.toList());
        if (indexOrder == IndexOrder.DESCENDING) {
            Collections.reverse(expectedIdsInOrder);
        }
        return expectedIdsInOrder;
    }

    private ValueType[] ensureHighEnoughCardinality(ValueType[] targetedTypes) {
        ValueType[] lowCardinalityArray = new ValueType[]{ValueType.BOOLEAN, ValueType.BYTE, ValueType.BOOLEAN_ARRAY};
        ArrayList<ValueType> typesOfLowCardinality = new ArrayList<ValueType>(Arrays.asList(lowCardinalityArray));
        for (ValueType targetedType : targetedTypes) {
            if (typesOfLowCardinality.contains(targetedType)) continue;
            return targetedTypes;
        }
        ArrayList<ValueType> result = new ArrayList<ValueType>(Arrays.asList(targetedTypes));
        ValueType highCardinalityType = (ValueType)this.randomRule.randomValues().among((Object[])RandomValues.excluding((ValueType[])ALL_ORDERABLE, (ValueType[])lowCardinalityArray));
        result.add(highCardinalityType);
        return result.toArray(new ValueType[0]);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum EntityControl {
        NODE{

            @Override
            public void createIndex(Transaction tx, String token, String propertyKey, String indexName) {
                tx.schema().indexFor(Label.label((String)token)).on(propertyKey).withName(indexName).create();
            }

            @Override
            public List<Long> findEntities(KernelTransaction tx, CursorFactory cursors, IndexReadSession index, IndexOrder indexOrder, PropertyIndexQuery.RangePredicate<?> range) throws KernelException {
                try (NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor(CursorContext.NULL_CONTEXT, tx.memoryTracker());){
                    tx.dataRead().nodeIndexSeek(tx.queryContext(), index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)false), new PropertyIndexQuery[]{range});
                    ArrayList<Long> actualIdsInOrder = new ArrayList<Long>();
                    while (cursor.next()) {
                        actualIdsInOrder.add(cursor.nodeReference());
                    }
                    ArrayList<Long> arrayList = actualIdsInOrder;
                    return arrayList;
                }
            }

            @Override
            public Entity createEntity(Transaction tx, String token) {
                return tx.createNode(new Label[]{Label.label((String)token)});
            }
        }
        ,
        RELATIONSHIP{

            @Override
            public void createIndex(Transaction tx, String token, String propertyKey, String indexName) {
                tx.schema().indexFor(RelationshipType.withName((String)token)).on(propertyKey).withName(indexName).create();
            }

            @Override
            public List<Long> findEntities(KernelTransaction tx, CursorFactory cursors, IndexReadSession index, IndexOrder indexOrder, PropertyIndexQuery.RangePredicate<?> range) throws KernelException {
                try (RelationshipValueIndexCursor cursor = cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL_CONTEXT, tx.memoryTracker());){
                    tx.dataRead().relationshipIndexSeek(tx.queryContext(), index, cursor, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)false), new PropertyIndexQuery[]{range});
                    ArrayList<Long> actualIdsInOrder = new ArrayList<Long>();
                    while (cursor.next()) {
                        actualIdsInOrder.add(cursor.relationshipReference());
                    }
                    ArrayList<Long> arrayList = actualIdsInOrder;
                    return arrayList;
                }
            }

            @Override
            public Entity createEntity(Transaction tx, String token) {
                return tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)token));
            }
        };


        abstract void createIndex(Transaction var1, String var2, String var3, String var4);

        abstract List<Long> findEntities(KernelTransaction var1, CursorFactory var2, IndexReadSession var3, IndexOrder var4, PropertyIndexQuery.RangePredicate<?> var5) throws KernelException;

        abstract Entity createEntity(Transaction var1, String var2);
    }

    private static class EntityValueTuple
    extends ValueTuple {
        private final long nodeId;

        private EntityValueTuple(long nodeId, Value ... values) {
            super(values);
            this.nodeId = nodeId;
        }

        long nodeId() {
            return this.nodeId;
        }
    }
}

