/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexReadAsserts;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestKernelReadTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class RelationshipTypeIndexCursorTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final int typeOne = 1;
    private static final int typeTwo = 2;
    private static final int typeThree = 3;

    RelationshipTypeIndexCursorTestBase() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void shouldFindRelationshipsByType(IndexOrder order) throws KernelException {
        long relThree3;
        long relThree2;
        long relTwo2;
        long toDelete;
        long relThree;
        long relTwo;
        try (KernelTransaction tx = this.beginTransaction();){
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            relTwo = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            relThree = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 3);
            toDelete = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            relTwo2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            relThree2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 3);
            relThree3 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 3);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().relationshipDelete(toDelete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            IndexOrder assertOrder = this.isNodeBased(tx) ? IndexOrder.NONE : order;
            try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);){
                LongHashSet uniqueIds = new LongHashSet();
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, order);
                IndexReadAsserts.assertRelationshipCount((RelationshipIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 2, cursor, order);
                IndexReadAsserts.assertRelationships((RelationshipIndexCursor)cursor, (MutableLongSet)uniqueIds, assertOrder, relTwo, relTwo2);
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 3, cursor, order);
                IndexReadAsserts.assertRelationships((RelationshipIndexCursor)cursor, (MutableLongSet)uniqueIds, assertOrder, relThree, relThree2, relThree3);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void shouldFindRelationshipsByTypeInTx(IndexOrder order) throws KernelException {
        long inStore2;
        long deletedInTx;
        long inStore;
        int propKey;
        IntValue one = Values.intValue((int)1);
        IntValue two = Values.intValue((int)2);
        try (KernelTransaction tx = this.beginTransaction();){
            propKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            inStore = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            deletedInTx = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            inStore2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            tx.dataWrite().relationshipSetProperty(inStore2, propKey, (Value)one);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            IndexOrder assertOrder = this.isNodeBased(tx) ? IndexOrder.NONE : order;
            tx.dataWrite().relationshipDelete(deletedInTx);
            long createdInTx = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 2);
            long createdInTx2 = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            tx.dataWrite().relationshipSetProperty(createdInTx2, propKey, (Value)two);
            MutableList expectedReads = Lists.mutable.of((Object[])new RelPropRead[]{new RelPropRead(inStore, null), new RelPropRead(inStore2, (Value)one), new RelPropRead(createdInTx, null), new RelPropRead(createdInTx2, (Value)two)});
            expectedReads.sortThis();
            if (assertOrder == IndexOrder.DESCENDING) {
                Collections.reverse(expectedReads);
            }
            try (RelationshipTypeIndexCursor relCursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor propCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, relCursor, order);
                MutableList actualReads = Lists.mutable.empty();
                for (RelPropRead ignored : expectedReads) {
                    Assertions.assertThat((boolean)relCursor.next()).isTrue();
                    Assertions.assertThat((boolean)relCursor.readFromStore()).isTrue();
                    long reference = relCursor.reference();
                    Value propValue = null;
                    relCursor.properties(propCursor);
                    if (propCursor.next()) {
                        propValue = propCursor.propertyValue();
                        Assertions.assertThat((boolean)propCursor.next()).isFalse();
                    }
                    actualReads.add((Object)new RelPropRead(reference, propValue));
                }
                Assertions.assertThat((boolean)relCursor.next()).isFalse();
                switch (assertOrder) {
                    case ASCENDING: 
                    case DESCENDING: {
                        Assertions.assertThat((List)actualReads).containsExactlyElementsOf((Iterable)expectedReads);
                        return;
                    }
                    case NONE: {
                        Assertions.assertThat((List)actualReads).containsExactlyInAnyOrderElementsOf((Iterable)expectedReads);
                        return;
                    }
                }
                return;
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=IndexOrder.class)
    void shouldFindRelationshipDetailsByTypeAllInSameTx(IndexOrder order) throws KernelException {
        IntValue propValue = Values.intValue((int)42);
        try (KernelTransaction tx = this.beginTransaction();){
            int typeToken = tx.tokenWrite().relationshipTypeCreateForName("REL", false);
            int propToken = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            Write write = tx.dataWrite();
            write.nodeCreate();
            long source = write.nodeCreate();
            long target = write.nodeCreate();
            long rel = write.relationshipCreate(source, typeToken, target);
            write.relationshipSetProperty(rel, propToken, (Value)propValue);
            try (RelationshipTypeIndexCursor relCursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor propCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, typeToken, relCursor, order);
                Assertions.assertThat((boolean)relCursor.next()).isTrue();
                Assertions.assertThat((boolean)relCursor.readFromStore()).isTrue();
                Assertions.assertThat((long)rel).isEqualTo(relCursor.reference());
                Assertions.assertThat((long)source).isEqualTo(relCursor.sourceNodeReference());
                Assertions.assertThat((long)target).isEqualTo(relCursor.targetNodeReference());
                relCursor.properties(propCursor);
                Assertions.assertThat((boolean)propCursor.next()).isTrue();
                Assertions.assertThat((int)propCursor.propertyKey()).isEqualTo(propToken);
                Assertions.assertThat((Object)propCursor.propertyValue()).isEqualTo((Object)propValue);
                Assertions.assertThat((boolean)propCursor.next()).isFalse();
                Assertions.assertThat((boolean)relCursor.next()).isFalse();
            }
            finally {
                tx.rollback();
            }
        }
    }

    @Test
    void shouldTraceRelationshipTypeScanEvents() throws KernelException {
        long rel1;
        long[] typeTwos = new long[2];
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            write.nodeCreate();
            rel1 = RelationshipTypeIndexCursorTestBase.createRelationship(write, 1);
            typeTwos[0] = RelationshipTypeIndexCursorTestBase.createRelationship(write, 2);
            typeTwos[1] = RelationshipTypeIndexCursorTestBase.createRelationship(write, 2);
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);){
            TestKernelReadTracer tracer = new TestKernelReadTracer();
            cursor.setTracer((KernelReadTracer)tracer);
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, IndexOrder.NONE);
            RelationshipTypeIndexCursorTestBase.exhaustCursor(cursor);
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[]{TestKernelReadTracer.relationshipTypeScanEvent((int)1), TestKernelReadTracer.relationshipEvent((long)rel1)});
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 2, cursor, IndexOrder.NONE);
            long[] tracedRelationships = RelationshipTypeIndexCursorTestBase.exhaustCursor(cursor);
            Assertions.assertThat((long[])tracedRelationships).containsExactlyInAnyOrder(typeTwos);
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[]{TestKernelReadTracer.relationshipTypeScanEvent((int)2), TestKernelReadTracer.relationshipEvent((long)tracedRelationships[0]), TestKernelReadTracer.relationshipEvent((long)tracedRelationships[1])});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToReadNodeCursorData() throws Exception {
        long txTarget;
        long txSource;
        long targetNode;
        long sourceNode;
        int label2;
        int label1;
        try (KernelTransaction tx = this.beginTransaction();){
            label1 = tx.tokenWrite().labelGetOrCreateForName("L1");
            label2 = tx.tokenWrite().labelGetOrCreateForName("L2");
            Write write = tx.dataWrite();
            sourceNode = write.nodeCreate();
            write.nodeAddLabel(sourceNode, label1);
            targetNode = write.nodeCreate();
            write.nodeAddLabel(targetNode, label2);
            write.relationshipCreate(sourceNode, 1, targetNode);
            tx.commit();
        }
        ArrayList<NodeRead> actualReads = new ArrayList<NodeRead>();
        try (KernelTransaction tx = this.beginTransaction();){
            try (RelationshipTypeIndexCursor relCursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
                 NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);){
                Write write = tx.dataWrite();
                txSource = write.nodeCreate();
                write.nodeAddLabel(txSource, label2);
                txTarget = write.nodeCreate();
                write.nodeAddLabel(txTarget, label1);
                write.relationshipCreate(txSource, 1, txTarget);
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, relCursor, IndexOrder.NONE);
                while (relCursor.next() && relCursor.readFromStore()) {
                    relCursor.source(nodeCursor);
                    Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                    actualReads.add(new NodeRead(nodeCursor.nodeReference(), true, nodeCursor.hasLabel(label1), nodeCursor.hasLabel(label2)));
                    Assertions.assertThat((boolean)nodeCursor.next()).isFalse();
                    relCursor.target(nodeCursor);
                    Assertions.assertThat((boolean)nodeCursor.next()).isTrue();
                    actualReads.add(new NodeRead(nodeCursor.nodeReference(), false, nodeCursor.hasLabel(label1), nodeCursor.hasLabel(label2)));
                    Assertions.assertThat((boolean)nodeCursor.next()).isFalse();
                }
            }
            tx.rollback();
        }
        List<NodeRead> expectedReads = List.of(new NodeRead(sourceNode, true, true, false), new NodeRead(txSource, true, false, true), new NodeRead(targetNode, false, false, true), new NodeRead(txTarget, false, true, false));
        Assertions.assertThat(expectedReads).containsExactlyInAnyOrderElementsOf(actualReads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReadMultipleRelationshipsBetweenSameNodes() throws Exception {
        long rel3;
        long rel2;
        long rel1;
        try (KernelTransaction tx = this.beginTransaction();){
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            Write write = tx.dataWrite();
            long sourceNode = write.nodeCreate();
            long targetNode = write.nodeCreate();
            rel1 = write.relationshipCreate(sourceNode, 1, targetNode);
            rel2 = write.relationshipCreate(sourceNode, 1, targetNode);
            rel3 = write.relationshipCreate(sourceNode, 1, targetNode);
            write.relationshipSetProperty(rel3, prop, (Value)Values.intValue((int)3));
            tx.commit();
        }
        List<RelPropRead> expectedReads = List.of(new RelPropRead(rel1, null), new RelPropRead(rel2, null), new RelPropRead(rel3, (Value)Values.intValue((int)3)));
        try (KernelTransaction tx = this.beginTransaction();){
            try (RelationshipTypeIndexCursor relCursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
                 PropertyCursor propCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, relCursor, IndexOrder.NONE);
                ArrayList<RelPropRead> actualReads = new ArrayList<RelPropRead>();
                while (relCursor.next() && relCursor.readFromStore()) {
                    long reference = relCursor.reference();
                    Value propValue = null;
                    relCursor.properties(propCursor);
                    if (propCursor.next()) {
                        propValue = propCursor.propertyValue();
                        Assertions.assertThat((boolean)propCursor.next()).isFalse();
                    }
                    actualReads.add(new RelPropRead(reference, propValue));
                }
                Assertions.assertThat(expectedReads).containsExactlyInAnyOrderElementsOf(actualReads);
            }
            finally {
                tx.rollback();
            }
        }
    }

    @Test
    void shouldReadRelationshipOnReadFromStore() throws Exception {
        long third;
        long second;
        long first;
        try (KernelTransaction tx = this.beginTransaction();){
            first = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            second = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            third = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            tx.commit();
        }
        ImmutableLongSet notDeleted = LongSets.immutable.of(new long[]{second, third});
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
             RelationshipScanCursor scanCursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
            Read read = tx.dataRead();
            read.singleRelationship(first, scanCursor);
            Assertions.assertThat((boolean)scanCursor.next()).isTrue();
            long relSourceNode = scanCursor.sourceNodeReference();
            long relTargetNode = scanCursor.targetNodeReference();
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, IndexOrder.NONE);
            while (cursor.next()) {
                Assertions.assertThat((boolean)cursor.readFromStore()).isTrue();
                Assertions.assertThat((int)cursor.type()).isEqualTo(1);
                if (cursor.relationshipReference() == first) {
                    try (KernelTransaction tx2 = this.beginTransaction();){
                        tx2.dataWrite().relationshipDelete(first);
                        tx2.commit();
                    }
                    Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(relSourceNode);
                    Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(relTargetNode);
                    continue;
                }
                Assertions.assertThat((boolean)notDeleted.contains(cursor.relationshipReference())).isTrue();
            }
        }
    }

    @Test
    void shouldHandleReadsWhenSourceRelationshipsPresentInStoreAndTxState() throws Exception {
        long relInStore;
        long relToBeDeleted;
        long nodeInStore2;
        long nodeInStore1;
        long nodeToBeDeleted;
        int prop;
        IntValue v1 = Values.intValue((int)1);
        IntValue v2 = Values.intValue((int)2);
        IntValue v3 = Values.intValue((int)3);
        try (KernelTransaction tx = this.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            prop = tokenWrite.propertyKeyGetOrCreateForName("prop");
            Write write = tx.dataWrite();
            nodeToBeDeleted = write.nodeCreate();
            nodeInStore1 = write.nodeCreate();
            nodeInStore2 = write.nodeCreate();
            relToBeDeleted = write.relationshipCreate(nodeToBeDeleted, 1, nodeInStore2);
            relInStore = write.relationshipCreate(nodeInStore1, 1, nodeInStore2);
            write.relationshipSetProperty(relInStore, prop, (Value)v1);
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipTypeIndexCursor relCursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Write write = tx.dataWrite();
            long nodeInTx = write.nodeCreate();
            long relInTx1 = write.relationshipCreate(nodeInStore1, 1, nodeInTx);
            long relInTx2 = write.relationshipCreate(nodeInStore2, 1, nodeInTx);
            write.relationshipSetProperty(relInTx1, prop, (Value)v2);
            write.relationshipSetProperty(relInTx2, prop, (Value)v3);
            write.nodeDelete(nodeToBeDeleted);
            write.relationshipDelete(relToBeDeleted);
            List<NodeRelRead> expectedReads = List.of(new NodeRelRead(nodeInStore1, relInStore, nodeInStore2, (Value)v1), new NodeRelRead(nodeInStore1, relInTx1, nodeInTx, (Value)v2), new NodeRelRead(nodeInStore2, relInTx2, nodeInTx, (Value)v3));
            ArrayList<NodeRelRead> actualReads = new ArrayList<NodeRelRead>();
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, relCursor, IndexOrder.NONE);
            while (relCursor.next()) {
                if (!relCursor.readFromStore()) continue;
                relCursor.properties(propCursor);
                Assertions.assertThat((boolean)propCursor.next()).isTrue();
                actualReads.add(new NodeRelRead(relCursor.sourceNodeReference(), relCursor.reference(), relCursor.targetNodeReference(), propCursor.propertyValue()));
                Assertions.assertThat((boolean)propCursor.next()).isFalse();
            }
            Assertions.assertThat(expectedReads).containsExactlyInAnyOrderElementsOf(actualReads);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotLoadDeletedRelationshipOnReadFromStore() throws Exception {
        long third;
        long second;
        long first;
        try (KernelTransaction tx = this.beginTransaction();){
            first = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            second = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            third = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            tx.commit();
        }
        MutableList expectedReads = Lists.mutable.empty();
        MutableList actualReads = Lists.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
             RelationshipScanCursor scanCursor = tx.cursors().allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
            Read read = tx.dataRead();
            if (this.isNodeBased(tx)) {
                read.singleRelationship(first, scanCursor);
                Assertions.assertThat((boolean)scanCursor.next()).isTrue();
                expectedReads.add((Object)new RelRead(first, true, scanCursor.sourceNodeReference(), scanCursor.targetNodeReference()));
            } else {
                expectedReads.add((Object)new RelRead(first, false, -1L, -1L));
            }
            read.singleRelationship(second, scanCursor);
            Assertions.assertThat((boolean)scanCursor.next()).isTrue();
            expectedReads.add((Object)new RelRead(second, true, scanCursor.sourceNodeReference(), scanCursor.targetNodeReference()));
            read.singleRelationship(third, scanCursor);
            Assertions.assertThat((boolean)scanCursor.next()).isTrue();
            expectedReads.add((Object)new RelRead(third, true, scanCursor.sourceNodeReference(), scanCursor.targetNodeReference()));
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, IndexOrder.NONE);
            boolean doneDelete = false;
            while (cursor.next()) {
                if (!doneDelete) {
                    try (KernelTransaction tx2 = this.beginTransaction();){
                        tx2.dataWrite().relationshipDelete(first);
                        tx2.commit();
                    }
                    doneDelete = true;
                }
                Assertions.assertThat((int)cursor.type()).isEqualTo(1);
                long relId = cursor.relationshipReference();
                if (relId == first && !this.isNodeBased(tx)) {
                    actualReads.add((Object)new RelRead(relId, cursor.readFromStore(), -1L, -1L));
                    continue;
                }
                actualReads.add((Object)new RelRead(relId, cursor.readFromStore(), cursor.sourceNodeReference(), cursor.targetNodeReference()));
            }
        }
        Assertions.assertThat((List)actualReads).containsExactlyInAnyOrderElementsOf((Iterable)expectedReads);
    }

    @Test
    void shouldFailOnReadRelationshipBeforeReadFromStore() throws Exception {
        long rel;
        Assumptions.assumeFalse((boolean)this.isNodeBased());
        try (KernelTransaction tx = this.beginTransaction();){
            rel = RelationshipTypeIndexCursorTestBase.createRelationship(tx.dataWrite(), 1);
            tx.commit();
        }
        tx = this.beginTransaction();
        try (RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(CursorContext.NULL_CONTEXT);
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            RelationshipTypeIndexCursorTestBase.relationshipTypeScan(tx, 1, cursor, IndexOrder.NONE);
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            Assertions.assertThatThrownBy(() -> cursor.source(nodeCursor)).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> ((RelationshipTypeIndexCursor)cursor).sourceNodeReference()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> cursor.target(nodeCursor)).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> ((RelationshipTypeIndexCursor)cursor).targetNodeReference()).isInstanceOf(IllegalStateException.class);
            Assertions.assertThatThrownBy(() -> cursor.properties(propertyCursor)).isInstanceOf(IllegalStateException.class);
            Assertions.assertThat((int)cursor.type()).isEqualTo(1);
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(rel);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static long[] exhaustCursor(RelationshipTypeIndexCursor cursor) {
        MutableLongList rels = LongLists.mutable.empty();
        while (cursor.next()) {
            rels.add(cursor.relationshipReference());
        }
        return rels.toArray();
    }

    private static long createRelationship(Write write, int type) throws KernelException {
        long sourceNode = write.nodeCreate();
        long targetNode = write.nodeCreate();
        return write.relationshipCreate(sourceNode, type, targetNode);
    }

    private static void relationshipTypeScan(KernelTransaction tx, int label, RelationshipTypeIndexCursor cursor, IndexOrder indexOrder) throws KernelException {
        IndexDescriptor index = tx.schemaRead().indexGetForName("rti");
        TokenReadSession tokenReadSession = tx.dataRead().tokenReadSession(index);
        tx.dataRead().relationshipTypeScan(tokenReadSession, cursor, IndexQueryConstraints.ordered((IndexOrder)indexOrder), new TokenPredicate(label), tx.cursorContext());
    }

    private record RelPropRead(long id, Value propValue) implements Comparable<RelPropRead>
    {
        @Override
        public int compareTo(RelPropRead other) {
            return Long.compare(this.id, other.id);
        }
    }

    private record NodeRead(long id, boolean isSource, boolean label1Present, boolean label2Present) {
    }

    private record NodeRelRead(long source, long rel, long target, Value propValue) {
    }

    private record RelRead(long id, boolean fromStore, long source, long target) {
    }
}

