/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.kernel.recovery.RecoveryIT;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class ParallelRecoveryIT
extends RecoveryIT {
    ParallelRecoveryIT() {
    }

    @Override
    void additionalConfiguration(Config config) {
        super.additionalConfiguration(config);
        config.set(GraphDatabaseInternalSettings.do_parallel_recovery, (Object)true);
    }

    @Override
    TestDatabaseManagementServiceBuilder additionalConfiguration(TestDatabaseManagementServiceBuilder builder) {
        return builder.setConfig(GraphDatabaseInternalSettings.do_parallel_recovery, (Object)true);
    }

    @Test
    void indexDropTogetherWithIndexUpdatesInParallelRecovery() throws Throwable {
        Path indexPath;
        GraphDatabaseAPI database = this.createDatabase();
        int numberOfNodes = 10;
        Label label = Label.label((String)"myLabel");
        String property = "prop";
        String rangeIndex = "range index";
        try (Transaction transaction = database.beginTx();){
            transaction.schema().indexFor(label).on(property).withIndexType(IndexType.RANGE).withName(rangeIndex).create();
            transaction.commit();
        }
        ParallelRecoveryIT.awaitIndexesOnline((GraphDatabaseService)database);
        ((CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forced checkpoint"));
        for (int i = 0; i < numberOfNodes; ++i) {
            try (Transaction tx = database.beginTx();){
                Node node = tx.createNode(new Label[]{label});
                node.setProperty(property, (Object)"value");
                tx.commit();
                continue;
            }
        }
        Path temp = this.dir.homePath().resolve("temp");
        try (Transaction tx = database.beginTx();){
            IndexDescriptor index = ((IndexDefinitionImpl)tx.schema().getIndexByName(rangeIndex)).getIndexReference();
            indexPath = IndexDirectoryStructure.directoriesByProvider((Path)this.databaseLayout.databaseDirectory()).forProvider(index.getIndexProvider()).directoryForIndex(index.getId());
            this.fileSystem.mkdir(temp);
            this.fileSystem.copyRecursively(indexPath, temp);
        }
        tx = database.beginTx();
        try {
            tx.schema().getIndexByName(rangeIndex).drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        this.fileSystem.mkdir(indexPath);
        this.fileSystem.copyRecursively(temp, indexPath);
        Assertions.assertDoesNotThrow(() -> this.recoverDatabase());
    }
}

