/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.database.DatabaseIdHelper;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.DefaultElementIdMapperV1;

class DefaultElementIdMapperTest {
    DefaultElementIdMapperTest() {
    }

    @Test
    void elementIdForEntity() {
        NamedDatabaseId databaseId = DatabaseIdHelper.randomNamedDatabaseId();
        DefaultElementIdMapperV1 idMapper = new DefaultElementIdMapperV1(databaseId);
        String databaseUUID = databaseId.databaseId().uuid().toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("5:" + databaseUUID + ":1"), (Object)idMapper.relationshipElementId(1L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)("5:" + databaseUUID + ":17857"), (Object)idMapper.relationshipElementId(17857L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)("5:" + databaseUUID + ":9223372036854775797"), (Object)idMapper.relationshipElementId(0x7FFFFFFFFFFFFFF5L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)("4:" + databaseUUID + ":10"), (Object)idMapper.nodeElementId(10L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)("4:" + databaseUUID + ":47857"), (Object)idMapper.nodeElementId(47857L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)("4:" + databaseUUID + ":9223372036854775790"), (Object)idMapper.nodeElementId(0x7FFFFFFFFFFFFFEEL));
    }

    @Test
    void entityIdFromElementId() {
        DefaultElementIdMapperV1 idMapper = new DefaultElementIdMapperV1(DatabaseIdHelper.randomNamedDatabaseId());
        long relationshipId = 17857L;
        long nodeId = 784512L;
        String relElementId = idMapper.relationshipElementId(relationshipId);
        String nodeElementId = idMapper.nodeElementId(nodeId);
        org.junit.jupiter.api.Assertions.assertEquals((long)relationshipId, (long)idMapper.relationshipId(relElementId));
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId, (long)idMapper.nodeId(nodeElementId));
    }

    @Test
    void failToDecodeIdsFromAnotherDatabase() {
        NamedDatabaseId expectedId = DatabaseIdHelper.randomNamedDatabaseId();
        DefaultElementIdMapperV1 idMapper = new DefaultElementIdMapperV1(expectedId);
        String nonExpectedDbId = DatabaseIdHelper.randomNamedDatabaseId().databaseId().uuid().toString();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> idMapper.relationshipId("5:" + nonExpectedDbId + ":1")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("does not belong to the current database");
    }
}

