/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.TokenIndexScanPartitionedScanTestSuite;
import org.neo4j.test.Tokens;

abstract class RelationshipTypeIndexScanPartitionedScanTestSuite
extends TokenIndexScanPartitionedScanTestSuite<RelationshipTypeIndexCursor> {
    RelationshipTypeIndexScanPartitionedScanTestSuite() {
    }

    public final PartitionedScanFactories.RelationshipTypeIndexScan getFactory() {
        return PartitionedScanFactories.RelationshipTypeIndexScan.FACTORY;
    }

    @Nested
    class WithData
    extends TokenIndexScanPartitionedScanTestSuite.WithData<RelationshipTypeIndexCursor> {
        private int defaultRelType;

        WithData() {
            super(RelationshipTypeIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            long numberOfRelationships = 262144L;
            SortedMap<Integer, List<PartitionedScanTestSuite.Range>> relTypeRanges = this.tokenRangesFromTokenId(Tokens.Suppliers.UUID.RELATIONSHIP_TYPE, this.createTokenRanges(262144L));
            this.defaultRelType = this.createToken(Tokens.Suppliers.UUID.RELATIONSHIP_TYPE);
            return this.createData(262144L, relTypeRanges);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> createData(long numberOfRelationships, SortedMap<Integer, List<PartitionedScanTestSuite.Range>> relTypeRanges) {
            KernelTransaction tx;
            PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> relsWithRelTypeId = new PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>();
            String indexName = this.getTokenIndexName(EntityType.RELATIONSHIP);
            relTypeRanges.keySet().forEach(relTypeId -> relsWithRelTypeId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(relTypeId.intValue()))));
            long numberOfNodes = numberOfRelationships / 10L;
            float loopRatio = 0.1f;
            float denseNodeRatio = 0.01f;
            int denseNodeNumberOfRels = 64;
            try {
                tx = this.beginTx();
                try {
                    Write write = tx.dataWrite();
                    List<Long> nodeIds = Stream.generate(() -> ((Write)write).nodeCreate()).limit(numberOfNodes).collect(Collectors.toList());
                    for (long counter = 0L; counter < numberOfRelationships; counter += numberOfRelationships - counter >= 64L && this.random.nextFloat() < 0.01f ? (long)this.createDense(write, indexName, 0.1f, 64, counter, nodeIds, relTypeRanges, relsWithRelTypeId) : (long)this.createSingle(write, indexName, 0.1f, counter, nodeIds, relTypeRanges, relsWithRelTypeId)) {
                    }
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError("failed to create database", e);
            }
            try {
                tx = this.beginTx();
                try {
                    ((AbstractLongAssert)Assertions.assertThat((long)tx.dataRead().relationshipsGetCount()).as("relationships created", new Object[0])).isLessThanOrEqualTo(numberOfRelationships);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError("failed to count number of relationships", e);
            }
            return new PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>(relsWithRelTypeId);
        }

        private int createDense(Write write, String indexName, float loopRatio, int denseNodeNumberOfRels, long counter, List<Long> nodeIds, Map<Integer, List<PartitionedScanTestSuite.Range>> relTypeRanges, PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> relsWithRelTypeId) throws EntityNotFoundException {
            Long sourceNodeId = (Long)this.random.among(nodeIds);
            nodeIds.remove(sourceNodeId);
            long maxPotentialRels = counter + (long)denseNodeNumberOfRels;
            while (counter < maxPotentialRels) {
                counter += (long)this.createSingle(write, indexName, loopRatio, counter, sourceNodeId, nodeIds, relTypeRanges, relsWithRelTypeId);
            }
            return denseNodeNumberOfRels;
        }

        private int createSingle(Write write, String indexName, float loopRatio, long counter, List<Long> nodeIds, Map<Integer, List<PartitionedScanTestSuite.Range>> relTypeRanges, PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> relsWithRelTypeId) throws EntityNotFoundException {
            Long sourceNodeId = (Long)this.random.among(nodeIds);
            return this.createSingle(write, indexName, loopRatio, counter, sourceNodeId, nodeIds, relTypeRanges, relsWithRelTypeId);
        }

        private int createSingle(Write write, String indexName, float loopRatio, long counter, long sourceNodeId, List<Long> nodeIds, Map<Integer, List<PartitionedScanTestSuite.Range>> relTypeRanges, PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> relsWithRelTypeId) throws EntityNotFoundException {
            int[] potentialRelTypeIds = relTypeRanges.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(range -> range.contains(counter))).mapToInt(Map.Entry::getKey).toArray();
            boolean usingDefault = potentialRelTypeIds.length == 0;
            int relTypeId = !usingDefault ? this.random.among(potentialRelTypeIds) : this.defaultRelType;
            long targetNodeId = this.random.nextFloat() < loopRatio ? sourceNodeId : (Long)this.random.among(nodeIds);
            long relId = write.relationshipCreate(sourceNodeId, relTypeId, targetNodeId);
            if (!usingDefault) {
                relsWithRelTypeId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(relTypeId))).add(relId);
            }
            return 1;
        }
    }

    @Nested
    class WithoutData
    extends TokenIndexScanPartitionedScanTestSuite.WithoutData<RelationshipTypeIndexCursor> {
        WithoutData() {
            super(RelationshipTypeIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            int numberOfRelTypes = 3;
            int[] relTypeIds = this.createTokens(3, Tokens.Suppliers.UUID.RELATIONSHIP_TYPE);
            return this.emptyQueries(EntityType.RELATIONSHIP, relTypeIds);
        }
    }
}

