/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.Clocks;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension(configurationCallback="configure")
class PropertyStoreTraceIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;

    PropertyStoreTraceIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.db_format, (Object)RecordFormatSelector.defaultFormat().name());
        Dependencies dependencies = Dependencies.dependenciesOf((Object)new CentralJobScheduler(Clocks.nanoClock(), (InternalLogProvider)NullLogProvider.getInstance()){

            public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long period, TimeUnit timeUnit) {
                return JobHandle.EMPTY;
            }

            public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
                return JobHandle.EMPTY;
            }
        });
        builder.setExternalDependencies((DependencyResolver)dependencies);
    }

    @Test
    void tracePageCacheAccessOnPropertyBlockIdGeneration() {
        NeoStores neoStores = this.storageEngine.testAccessNeoStores();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        PropertyStoreTraceIT.prepareIdGenerator(propertyStore.getStringStore().getIdGenerator());
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        try (CursorContext cursorContext = contextFactory.create("tracePageCacheAccessOnPropertyBlockIdGeneration");){
            PropertyBlock propertyBlock = new PropertyBlock();
            DynamicRecord dynamicRecord = new DynamicRecord(2L);
            dynamicRecord.setData(new byte[]{0, 1, 2, 3, 4, 5, 6, 7});
            propertyBlock.addValueRecord(dynamicRecord);
            DynamicAllocatorProvider allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator((NeoStores)neoStores);
            PropertyStore.encodeValue((PropertyBlock)propertyBlock, (int)1, (Value)Values.stringValue((String)RandomStringUtils.randomAlphabetic((int)((int)ByteUnit.kibiBytes((long)4L)))), (DynamicRecordAllocator)allocatorProvider.allocator(StoreType.PROPERTY_STRING), (DynamicRecordAllocator)allocatorProvider.allocator(StoreType.PROPERTY_ARRAY), (CursorContext)cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            Assertions.assertThat((long)cursorTracer.pins()).isOne();
            Assertions.assertThat((long)cursorTracer.unpins()).isOne();
            Assertions.assertThat((long)cursorTracer.hits()).isOne();
        }
    }

    private static void prepareIdGenerator(IdGenerator idGenerator) {
        try (IdGenerator.ContextualMarker marker = idGenerator.contextualMarker(CursorContext.NULL_CONTEXT);){
            marker.markFree(1L);
        }
        idGenerator.clearCache(true, CursorContext.NULL_CONTEXT);
    }
}

