/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexTransactionStateWithApplyChangesTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeIndexTransactionStateWithApplyChangesTest
extends IndexTransactionStateWithApplyChangesTestBase {
    private static final String DEFAULT_LABEL = "label";

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyChangesShouldAddLabelsInIndexTxState(IndexType indexType, boolean needsValues) throws Exception {
        IndexTransactionStateWithApplyChangesTestBase.EntityWithProps entityWithProps;
        this.createIndex(indexType);
        HashSet<IndexTransactionStateWithApplyChangesTestBase.EntityWithProps> expected = new HashSet<IndexTransactionStateWithApplyChangesTestBase.EntityWithProps>();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            long node = write.nodeCreate();
            entityWithProps = this.setPropsOnEntity(tx, node, "books", "looks");
            tx.commit();
        }
        expected.add(entityWithProps);
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeAddLabel(entityWithProps.entityId(), tx.tokenWrite().labelGetOrCreateForName(DEFAULT_LABEL));
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertEntityAndValueForScan(expected, tx, index, needsValues, "something", "else");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void applyChangesShouldRemoveLabelsInIndexTxState(IndexType indexType, boolean needsValues) throws Exception {
        IndexTransactionStateWithApplyChangesTestBase.EntityWithProps entityWithProps;
        this.createIndex(indexType);
        try (KernelTransaction tx = this.beginTransaction();){
            entityWithProps = this.entityWithProps(tx, "books", "looks");
            tx.commit();
        }
        HashSet<IndexTransactionStateWithApplyChangesTestBase.EntityWithProps> expected = new HashSet<IndexTransactionStateWithApplyChangesTestBase.EntityWithProps>();
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeRemoveLabel(entityWithProps.entityId(), tx.tokenWrite().labelGetOrCreateForName(DEFAULT_LABEL));
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertEntityAndValueForScan(expected, tx, index, needsValues, "something", "else");
        }
    }

    @Override
    IndexTransactionStateWithApplyChangesTestBase.EntityWithProps entityWithProps(KernelTransaction tx, Object val, Object val2) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        int nodeLabel = tx.tokenWrite().labelGetOrCreateForName(DEFAULT_LABEL);
        write.nodeAddLabel(node, nodeLabel);
        return this.setPropsOnEntity(tx, node, val, val2);
    }

    @Override
    void createIndex(IndexType indexType) {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)DEFAULT_LABEL)).on("prop1").on("prop2").withIndexType(indexType).withName("myIndex").create();
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    void deleteEntity(KernelTransaction tx, long entity) throws Exception {
        tx.dataWrite().nodeDelete(entity);
    }

    @Override
    void removeProperties(KernelTransaction tx, long entity) throws Exception {
        int prop1Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        MutableIntObjectMap propertiesToSet = IntObjectMaps.mutable.empty();
        propertiesToSet.put(prop1Key, (Object)Values.NO_VALUE);
        propertiesToSet.put(prop2Key, (Object)Values.NO_VALUE);
        tx.dataWrite().nodeApplyChanges(entity, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)propertiesToSet);
    }

    @Override
    IndexTransactionStateWithApplyChangesTestBase.EntityWithProps setProperties(KernelTransaction tx, long entity, Object val, Object val2) throws Exception {
        return this.setPropsOnEntity(tx, entity, val, val2);
    }

    private IndexTransactionStateWithApplyChangesTestBase.EntityWithProps setPropsOnEntity(KernelTransaction tx, long entity, Object val, Object val2) throws KernelException {
        int prop1Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2Key = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        MutableIntObjectMap propertiesToSet = IntObjectMaps.mutable.empty();
        Value value1 = Values.of((Object)val);
        propertiesToSet.put(prop1Key, (Object)value1);
        Value value2 = Values.of((Object)val2);
        propertiesToSet.put(prop2Key, (Object)value2);
        tx.dataWrite().nodeApplyChanges(entity, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntObjectMap)propertiesToSet);
        return new IndexTransactionStateWithApplyChangesTestBase.EntityWithProps(entity, value1, value2);
    }

    @Override
    void assertEntityAndValueForScan(Set<IndexTransactionStateWithApplyChangesTestBase.EntityWithProps> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery, Object anotherValueFoundByQuery2) throws Exception {
        IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().nodeIndexScan(indexSession, nodes, IndexQueryConstraints.unordered((boolean)needsValues));
            this.assertEntityAndValue(expected, tx, needsValues, anotherValueFoundByQuery, anotherValueFoundByQuery2, new NodeCursorAdapter(nodes));
        }
    }

    static class NodeCursorAdapter
    implements IndexTransactionStateWithApplyChangesTestBase.EntityValueIndexCursor {
        private final NodeValueIndexCursor nodes;

        NodeCursorAdapter(NodeValueIndexCursor nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean next() {
            return this.nodes.next();
        }

        @Override
        public Value propertyValue(int offset) {
            return this.nodes.propertyValue(offset);
        }

        @Override
        public long entityReference() {
            return this.nodes.nodeReference();
        }
    }
}

