/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class CheckpointKernelVersionIT {
    @Inject
    private Neo4jLayout dbLayout;
    private CheckPointer checkPointer;
    private LogFiles logFiles;
    private DatabaseManagementService dbms;

    private void setupDbms(DbmsRuntimeVersion version) {
        this.dbms = new TestDatabaseManagementServiceBuilder(this.dbLayout).setConfig(Config.defaults(Map.of(GraphDatabaseInternalSettings.latest_runtime_version, version.getVersion(), GraphDatabaseInternalSettings.latest_kernel_version, version.kernelVersion().version()))).build();
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.dbms.database("neo4j")).getDependencyResolver();
        this.checkPointer = (CheckPointer)dependencyResolver.resolveDependency(CheckPointer.class);
        this.logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
            this.dbms = null;
        }
    }

    @Test
    void checkPointRecordContainsDatabaseKernelVersion() throws IOException {
        DbmsRuntimeVersion version = DbmsRuntimeVersion.V5_7;
        this.setupDbms(version);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Forced " + String.valueOf(version.kernelVersion())));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)checkpoint.kernelVersion()).as("kernel version from last checkpoint", new Object[0])).isEqualTo((Object)version.kernelVersion());
    }

    @Test
    void checkPointRecordContainsAppendIndex() throws IOException {
        DbmsRuntimeVersion version = DbmsRuntimeVersion.V5_20;
        this.setupDbms(version);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Forced " + String.valueOf(version.kernelVersion())));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        ((AbstractLongAssert)Assertions.assertThat((long)checkpoint.appendIndex()).as("Append index should be positive number", new Object[0])).isGreaterThan(1L);
    }

    @Test
    void checkPointInLegacy5_0Format() throws IOException {
        DbmsRuntimeVersion version = DbmsRuntimeVersion.V5_0;
        this.setupDbms(version);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Legacy format."));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        org.junit.jupiter.api.Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)checkpoint.kernelVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)checkpoint.transactionId().consensusIndex());
    }
}

