/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableLogChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryDetachedCheckpointV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.v522.LogEntryDetachedCheckpointV5_22;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.arguments.KernelVersionSource;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DetachedCheckpointLogEntrySerializerTest {
    private static final StoreId TEST_STORE_ID = new StoreId(3L, 4L, "engine-1", "format-1", 11, 22);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    DetachedCheckpointLogEntrySerializerTest() {
    }

    @Test
    void writeAndParseCheckpointKernelVersion() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntrySerializerTest.writeCheckpoint((WritableChannel)writeChannel, KernelVersion.V5_0, StringUtils.repeat((String)"c", (int)1024));
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), -1L, LatestVersions.LATEST_LOG_FORMAT, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                LogEntryDetachedCheckpointV5_0 checkpointV50 = this.readCheckpoint(entryReader, (ReadableLogPositionAwareChannel)readChannel);
                org.junit.jupiter.api.Assertions.assertEquals((byte)9, (byte)checkpointV50.getType());
                org.junit.jupiter.api.Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)checkpointV50.kernelVersion());
                org.junit.jupiter.api.Assertions.assertEquals((Object)new LogPosition(100L, 200L), (Object)checkpointV50.getLogPosition());
                org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_STORE_ID, (Object)checkpointV50.getStoreId());
                org.junit.jupiter.api.Assertions.assertEquals((Object)new TransactionId(70L, 70L, KernelVersion.V5_0, 80, 90L, -1L), (Object)checkpointV50.getTransactionId());
            }
        }
    }

    @Test
    void failToParse50CheckpointWithOlderKernelVersion() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                byte[] storeIdBuffer = new byte[64];
                StoreIdSerialization.serializeWithFixedSize((StoreId)TEST_STORE_ID, (ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
                writeChannel.put(KernelVersion.V4_4.version()).put((byte)9).putLong(1L).putLong(2L).putLong(3L).put(storeIdBuffer, storeIdBuffer.length).putLong(4L).putInt(5).putLong(6L).putShort((short)4).put(new byte[]{7, 8, 9, 10}, 4);
                writeChannel.putChecksum();
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), 1L, LogFormat.V7, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                Assertions.assertThatThrownBy(() -> this.readCheckpoint(entryReader, (ReadableLogPositionAwareChannel)readChannel)).rootCause().isInstanceOf(IllegalArgumentException.class);
            }
        }
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="5.0")
    void detachedCheckpointEntryHasSpecificLength(KernelVersion kernelVersion) throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            StoreChannel storeChannel = this.fs.write(this.directory.createFile("a"));
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                long initialPosition = writeChannel.position();
                DetachedCheckpointLogEntrySerializerTest.writeCheckpoint((WritableChannel)writeChannel, kernelVersion, "checkpoint reason");
                Assertions.assertThat((long)(writeChannel.position() - initialPosition)).isEqualTo(232L);
            }
        }
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="5.0")
    void anyCheckpointEntryHaveTheSameSize(KernelVersion kernelVersion) throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            StoreChannel storeChannel = this.fs.write(this.directory.createFile("b"));
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                for (int i = 0; i < 100; ++i) {
                    long initialPosition = writeChannel.position();
                    DetachedCheckpointLogEntrySerializerTest.writeCheckpoint((WritableChannel)writeChannel, kernelVersion, RandomStringUtils.randomAlphabetic((int)10, (int)512));
                    long recordLength = writeChannel.position() - initialPosition;
                    Assertions.assertThat((long)recordLength).isEqualTo(232L);
                }
            }
        }
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="5.0")
    void longCheckpointReasonIsTrimmedToFit(KernelVersion kernelVersion) throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            StoreChannel storeChannel = this.fs.write(this.directory.createFile("b"));
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                long initialPosition = writeChannel.position();
                DetachedCheckpointLogEntrySerializerTest.writeCheckpoint((WritableChannel)writeChannel, kernelVersion, StringUtils.repeat((String)"b", (int)1024));
                long recordLength = writeChannel.position() - initialPosition;
                Assertions.assertThat((long)recordLength).isEqualTo(232L);
            }
        }
    }

    @ParameterizedTest
    @KernelVersionSource(atLeast="5.7")
    void checkpointContainsConsensusIndex(KernelVersion kernelVersion) throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("c");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                long initialPosition = writeChannel.position();
                DetachedCheckpointLogEntrySerializerTest.writeCheckpoint((WritableChannel)writeChannel, kernelVersion, StringUtils.repeat((String)"b", (int)1024));
                long recordLength = writeChannel.position() - initialPosition;
                Assertions.assertThat((long)recordLength).isEqualTo(232L);
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), -1L, LatestVersions.LATEST_LOG_FORMAT, path, ChannelNativeAccessor.EMPTY_ACCESSOR, (LogTracers)DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                if (kernelVersion.isAtLeast(KernelVersion.VERSION_CHECKPOINT_NOT_COMPLETED_POSITION_INTRODUCED)) {
                    this.verifyCheckpoint5_22(entryReader, (ReadableLogPositionAwareChannel)readChannel, kernelVersion);
                } else if (kernelVersion.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED)) {
                    this.verifyCheckpoint5_20(entryReader, (ReadableLogPositionAwareChannel)readChannel, kernelVersion);
                } else {
                    this.verifyCheckpoint(entryReader, (ReadableLogPositionAwareChannel)readChannel, kernelVersion);
                }
            }
        }
    }

    private static void writeCheckpoint(WritableChannel channel, KernelVersion kernelVersion, String reason) throws IOException {
        TransactionId transactionId = new TransactionId(70L, 70L, kernelVersion, 80, 90L, 10L);
        LogPosition logPosition = new LogPosition(100L, 200L);
        LogEntrySerializationSets.serializationSet((KernelVersion)kernelVersion, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)9).write(channel, (LogEntry)DetachedCheckpointLogEntrySerializerTest.checkpointEntry(kernelVersion, reason, transactionId, logPosition));
    }

    private static AbstractVersionAwareLogEntry checkpointEntry(KernelVersion kernelVersion, String reason, TransactionId transactionId, LogPosition logPosition) {
        if (kernelVersion.isAtLeast(KernelVersion.VERSION_CHECKPOINT_NOT_COMPLETED_POSITION_INTRODUCED)) {
            return new LogEntryDetachedCheckpointV5_22(kernelVersion, transactionId, transactionId.appendIndex(), logPosition, logPosition, 1L, TEST_STORE_ID, reason);
        }
        if (kernelVersion.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED)) {
            return new LogEntryDetachedCheckpointV5_20(kernelVersion, transactionId, transactionId.appendIndex() + 7L, logPosition, 1L, TEST_STORE_ID, reason);
        }
        return new LogEntryDetachedCheckpointV5_0(kernelVersion, transactionId, logPosition, 1L, TEST_STORE_ID, reason);
    }

    private LogEntryDetachedCheckpointV5_0 readCheckpoint(VersionAwareLogEntryReader entryReader, ReadableLogPositionAwareChannel readChannel) throws IOException {
        return (LogEntryDetachedCheckpointV5_0)entryReader.readLogEntry(readChannel);
    }

    private void verifyCheckpoint5_22(VersionAwareLogEntryReader entryReader, ReadableLogPositionAwareChannel readChannel, KernelVersion kernelVersion) throws IOException {
        LogEntryDetachedCheckpointV5_22 checkpoint = (LogEntryDetachedCheckpointV5_22)entryReader.readLogEntry(readChannel);
        org.junit.jupiter.api.Assertions.assertEquals((byte)9, (byte)checkpoint.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)kernelVersion, (Object)checkpoint.kernelVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LogPosition(100L, 200L), (Object)checkpoint.getCheckpointedLogPosition());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LogPosition(100L, 200L), (Object)checkpoint.getOldestNotCompletedPosition());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_STORE_ID, (Object)checkpoint.getStoreId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new TransactionId(70L, 70L, kernelVersion, 80, 90L, 10L), (Object)checkpoint.getTransactionId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checkpoint.consensusIndexInCheckpoint());
    }

    private void verifyCheckpoint5_20(VersionAwareLogEntryReader entryReader, ReadableLogPositionAwareChannel readChannel, KernelVersion kernelVersion) throws IOException {
        LogEntryDetachedCheckpointV5_20 checkpoint = (LogEntryDetachedCheckpointV5_20)entryReader.readLogEntry(readChannel);
        org.junit.jupiter.api.Assertions.assertEquals((byte)9, (byte)checkpoint.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)kernelVersion, (Object)checkpoint.kernelVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LogPosition(100L, 200L), (Object)checkpoint.getLogPosition());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_STORE_ID, (Object)checkpoint.getStoreId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new TransactionId(70L, 70L, kernelVersion, 80, 90L, 10L), (Object)checkpoint.getTransactionId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checkpoint.consensusIndexInCheckpoint());
    }

    private void verifyCheckpoint(VersionAwareLogEntryReader entryReader, ReadableLogPositionAwareChannel readChannel, KernelVersion kernelVersion) throws IOException {
        LogEntryDetachedCheckpointV5_0 checkpoint = this.readCheckpoint(entryReader, readChannel);
        org.junit.jupiter.api.Assertions.assertEquals((byte)9, (byte)checkpoint.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)kernelVersion, (Object)checkpoint.kernelVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LogPosition(100L, 200L), (Object)checkpoint.getLogPosition());
        org.junit.jupiter.api.Assertions.assertEquals((Object)TEST_STORE_ID, (Object)checkpoint.getStoreId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new TransactionId(70L, 70L, kernelVersion, 80, 90L, 10L), (Object)checkpoint.getTransactionId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checkpoint.consensusIndexInCheckpoint());
    }
}

