/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutput;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ResourceLock(value="java.lang.System.out")
@ExtendWith(value={SuppressOutputExtension.class})
class GraphDatabaseInternalLogIT {
    @Inject
    private TestDirectory testDir;
    @Inject
    private SuppressOutput suppressOutput;

    GraphDatabaseInternalLogIT() {
    }

    @Test
    void shouldWriteToInternalDiagnosticsLog() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs").toAbsolutePath()).build();
        NamedDatabaseId databaseId = ((GraphDatabaseAPI)managementService.database("neo4j")).databaseId();
        managementService.shutdown();
        Path internalLog = this.testDir.directory("logs").resolve("debug.log");
        Assertions.assertThat((boolean)Files.isRegularFile(internalLog, new LinkOption[0])).isEqualTo(true);
        Assertions.assertThat((long)Files.size(internalLog)).isGreaterThan(0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, String.valueOf(databaseId) + " is ready."));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, String.valueOf(databaseId) + " is unavailable."));
    }

    @Test
    void shouldNotWriteDebugToInternalDiagnosticsLogByDefault() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.logs_directory, (Object)this.testDir.directory("logs").toAbsolutePath()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).debug("A debug entry");
        managementService.shutdown();
        Path internalLog = this.testDir.directory("logs").resolve("debug.log");
        Assertions.assertThat((boolean)Files.isRegularFile(internalLog, new LinkOption[0])).isEqualTo(true);
        Assertions.assertThat((long)Files.size(internalLog)).isGreaterThan(0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "A debug entry"));
    }

    @Test
    void shouldUseXmlConfigurationIfPresent() throws IOException {
        Path log4jXmlConfig = this.testDir.homePath().resolve("server-logs.xml");
        this.writeResourceToFile("testConfig.xml", log4jXmlConfig);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.server_logging_config_path, (Object)log4jXmlConfig).build();
        GraphDatabaseService db = managementService.database("neo4j");
        LogService logService = (LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).info("An info entry");
        managementService.shutdown();
        Path internalLog = this.testDir.directory("logs").resolve("debug.log");
        Path internalLog2 = this.testDir.directory("logs").resolve("debug2.log");
        Assertions.assertThat((Path)internalLog).isRegularFile();
        Assertions.assertThat((long)Files.size(internalLog)).isGreaterThan(0L);
        Assertions.assertThat((Path)internalLog2).isRegularFile();
        Assertions.assertThat((long)Files.size(internalLog2)).isGreaterThan(0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "An info entry"));
        String loggingConfigInfo = "Logging config in use: File '%s'".formatted(log4jXmlConfig.toAbsolutePath());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, loggingConfigInfo));
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrencesJson(internalLog2, "message", "An info entry"));
    }

    @Test
    @Timeout(value=3L, unit=TimeUnit.MINUTES)
    void shouldHandleReconfiguringOfXmlConfiguration() throws IOException, InterruptedException {
        Path log4jXmlConfig = this.testDir.homePath().resolve("server-logs.xml");
        Files.createDirectories(log4jXmlConfig.getParent(), new FileAttribute[0]);
        this.writeResourceToFile("testConfig2.xml", log4jXmlConfig);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.server_logging_config_path, (Object)log4jXmlConfig).build();
        GraphDatabaseService db = managementService.database("neo4j");
        InternalLog log = ((LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass());
        log.info("First info entry");
        Path internalLog = this.testDir.directory("logs").resolve("debug.log");
        Path internalLog2 = this.testDir.directory("logs").resolve("debug2.log");
        Assertions.assertThat((Path)internalLog).isRegularFile();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)GraphDatabaseInternalLogIT.countOccurrences(internalLog, "First info entry"));
        Assertions.assertThat((Path)internalLog2).doesNotExist();
        this.writeResourceToFile("testConfig.xml", log4jXmlConfig);
        do {
            log.info("another info entry");
            Thread.sleep(100L);
        } while (!Files.exists(internalLog2, new LinkOption[0]) || Files.size(internalLog2) <= 0L);
        log.info("An info entry");
        managementService.shutdown();
        Assertions.assertThat((Path)internalLog).isRegularFile();
        Assertions.assertThat((Path)internalLog2).isRegularFile();
        GraphDatabaseInternalLogIT.assertEventuallyContains(() -> GraphDatabaseInternalLogIT.countOccurrences(internalLog, "An info entry"));
        GraphDatabaseInternalLogIT.assertEventuallyContains(() -> GraphDatabaseInternalLogIT.countOccurrencesJson(internalLog2, "message", "An info entry"));
    }

    @Test
    @Timeout(value=3L, unit=TimeUnit.MINUTES)
    void shouldHandlePathsWithSpecialCharacters() throws IOException, InterruptedException {
        Path log4jXmlConfig = this.testDir.homePath().resolve("server-logs.xml");
        Path logsDirectory = this.testDir.directory("%s test");
        Path internalLog = logsDirectory.resolve("debug.log");
        Path rollingLogFile = logsDirectory.resolve("debug.log.01");
        Files.createDirectories(log4jXmlConfig.getParent(), new FileAttribute[0]);
        this.writeResourceToFile("testConfigSpecialChars.xml", log4jXmlConfig);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setConfig(GraphDatabaseSettings.server_logging_config_path, (Object)log4jXmlConfig).setConfig(GraphDatabaseSettings.logs_directory, (Object)logsDirectory).build();
        GraphDatabaseService db = managementService.database("neo4j");
        InternalLog log = ((LogService)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass());
        log.info("An info entry");
        Assertions.assertThat((Path)internalLog).isRegularFile();
        do {
            log.info("An info entry");
            Thread.sleep(100L);
        } while (!Files.exists(rollingLogFile, new LinkOption[0]));
        managementService.shutdown();
        Assertions.assertThat((Path)rollingLogFile).isRegularFile();
        Assertions.assertThat((boolean)this.suppressOutput.getOutputVoice().isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.suppressOutput.getErrorVoice().isEmpty()).isTrue();
    }

    private static void assertEventuallyContains(Callable<Long> instances) {
        Assert.assertEventually(instances, l -> l > 0L, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static long countOccurrences(Path file, String substring) throws IOException {
        try (Stream<String> lines = Files.lines(file);){
            long l = lines.filter(line -> line.contains(substring)).count();
            return l;
        }
    }

    private void writeResourceToFile(String name, Path log4jXmlConfig) throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream(name);){
            Files.copy(Objects.requireNonNull(in), log4jXmlConfig, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static long countOccurrencesJson(Path file, String key, String substring) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try (Stream<String> lines = Files.lines(file);){
            long l = lines.filter(line -> {
                try {
                    JsonNode logLine = mapper.readTree(line);
                    String value = logLine.get(key).asText();
                    return value.contains(substring);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).count();
            return l;
        }
    }
}

