/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.tuple.Tuples;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfigUtils;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.schema.vector.VectorTestUtils;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.Tokens;
import org.neo4j.test.UpgradeTestUtil;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class VectorIndexOnDatabaseUpgradeTransactionIT {
    private static final DbmsRuntimeVersion LATEST_RUNTIME_VERSION = LatestVersions.LATEST_RUNTIME_VERSION;
    private static final KernelVersion LATEST_KERNEL_VERSION = LATEST_RUNTIME_VERSION.kernelVersion();
    private static final Label LABEL = (Label)Tokens.Suppliers.UUID.LABEL.get();
    private static final RelationshipType REL_TYPE = (RelationshipType)Tokens.Suppliers.UUID.RELATIONSHIP_TYPE.get();
    private static final String PROP_KEY = (String)Tokens.Suppliers.UUID.PROPERTY_KEY.get();
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;
    private GraphDatabaseAPI database;

    VectorIndexOnDatabaseUpgradeTransactionIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexVersions"})
    void shouldBeBlockedFromCreatingVectorIndexOnOlderVersion(EntityType entityType, VectorIndexVersion indexVersion) {
        KernelVersion previousVersion = this.previousFrom(indexVersion.minimumRequiredKernelVersion());
        this.setup(previousVersion);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = this.database.beginTx();){
                this.createIndex(tx, entityType, indexVersion, this.defaultSettings());
                tx.commit();
            }
        }).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"Failed to create index with provider", indexVersion.descriptor().name(), "Version was", previousVersion.name(), "but required version for operation is", indexVersion.minimumRequiredKernelVersion().name(), "Please upgrade dbms using", "dbms.upgrade()"});
    }

    @ParameterizedTest
    @MethodSource(value={"indexVersions"})
    void shouldBePossibleToCreateVectorIndexAfterUpgrade(EntityType entityType, VectorIndexVersion indexVersion) {
        KernelVersion previousVersion = this.previousFrom(indexVersion.minimumRequiredKernelVersion());
        this.setup(previousVersion);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.dbms, (GraphDatabaseAPI)this.database, (KernelVersion)previousVersion, (KernelVersion)LATEST_KERNEL_VERSION);
        try (Transaction tx = this.database.beginTx();){
            this.createIndex(tx, entityType, indexVersion, this.defaultSettings());
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).hasSize(1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexVersions"})
    void createVectorIndexShouldTriggerUpgrade(EntityType entityType, VectorIndexVersion indexVersion) {
        KernelVersion previousVersion = this.previousFrom(indexVersion.minimumRequiredKernelVersion());
        this.setup(previousVersion);
        UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.dbms);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)previousVersion);
        try (Transaction tx = this.database.beginTx();){
            this.createIndex(tx, entityType, indexVersion, this.defaultSettings());
            tx.commit();
        }
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)LATEST_KERNEL_VERSION);
        tx = this.database.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).hasSize(1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<Arguments> indexVersions() {
        return Stream.of(Arguments.of((Object[])new Object[]{EntityType.NODE, VectorIndexVersion.V1_0}), Arguments.of((Object[])new Object[]{EntityType.NODE, VectorIndexVersion.V2_0}), Arguments.of((Object[])new Object[]{EntityType.RELATIONSHIP, VectorIndexVersion.V2_0}));
    }

    @ParameterizedTest
    @MethodSource(value={"introducedSettings"})
    void shouldBeBlockedFromCreatingVectorIndexWithNewSettingsOnOlderVersion(EntityType entityType, IndexSetting setting, Object validValue) {
        VectorIndexVersion indexVersion = VectorIndexVersion.V2_0;
        KernelVersion introducedKernelVersion = (KernelVersion)VectorIndexConfigUtils.INDEX_SETTING_INTRODUCED_VERSIONS.get((Object)setting);
        KernelVersion previousVersion = this.previousFrom(introducedKernelVersion);
        this.setup(previousVersion);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = this.database.beginTx();){
                this.createIndex(tx, entityType, indexVersion, this.defaultSettings().set(setting, validValue));
                tx.commit();
            }
        }).isInstanceOf(UnsupportedOperationException.class)).hasMessageContainingAll(new CharSequence[]{"Failed to create vector index with provided settings.", "Version was", previousVersion.name(), "but required version for operation is", introducedKernelVersion.name(), "Please upgrade dbms using", "dbms.upgrade()"});
    }

    @ParameterizedTest
    @MethodSource(value={"introducedSettings"})
    void shouldBePossibleToCreateVectorIndexWithNewSettingsAfterUpgrade(EntityType entityType, IndexSetting setting, Object validValue) {
        VectorIndexVersion indexVersion = VectorIndexVersion.V2_0;
        KernelVersion introducedKernelVersion = (KernelVersion)VectorIndexConfigUtils.INDEX_SETTING_INTRODUCED_VERSIONS.get((Object)setting);
        KernelVersion previousVersion = this.previousFrom(introducedKernelVersion);
        this.setup(previousVersion);
        UpgradeTestUtil.upgradeDatabase((DatabaseManagementService)this.dbms, (GraphDatabaseAPI)this.database, (KernelVersion)previousVersion, (KernelVersion)LATEST_KERNEL_VERSION);
        try (Transaction tx = this.database.beginTx();){
            this.createIndex(tx, entityType, indexVersion, this.defaultSettings().set(setting, validValue));
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).hasSize(1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"introducedSettings"})
    void createVectorIndexWithNewSettingsShouldTriggerUpgrade(EntityType entityType, IndexSetting setting, Object validValue) {
        VectorIndexVersion indexVersion = VectorIndexVersion.V2_0;
        KernelVersion introducedKernelVersion = (KernelVersion)VectorIndexConfigUtils.INDEX_SETTING_INTRODUCED_VERSIONS.get((Object)setting);
        KernelVersion previousVersion = this.previousFrom(introducedKernelVersion);
        this.setup(previousVersion);
        UpgradeTestUtil.upgradeDbms((DatabaseManagementService)this.dbms);
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)previousVersion);
        try (Transaction tx = this.database.beginTx();){
            this.createIndex(tx, entityType, indexVersion, this.defaultSettings().set(setting, validValue));
            tx.commit();
        }
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)LATEST_KERNEL_VERSION);
        tx = this.database.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).hasSize(1);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<Arguments> introducedSettings() {
        return Stream.of(Tuples.pair((Object)IndexSetting.vector_Quantization_Enabled(), (Object)true), Tuples.pair((Object)IndexSetting.vector_Hnsw_M(), (Object)32), Tuples.pair((Object)IndexSetting.vector_Hnsw_M(), (Object)256)).flatMap(pair -> Arrays.stream(EntityType.values()).map(entityType -> Arguments.of((Object[])new Object[]{entityType, pair.getOne(), pair.getTwo()})));
    }

    private void createIndex(Transaction tx, EntityType entityType, VectorIndexVersion indexVersion, VectorTestUtils.VectorIndexSettings settings) {
        try {
            KernelTransaction ktx = ((TransactionImpl)tx).kernelTransaction();
            int propKeyId = Tokens.Factories.PROPERTY_KEY.getId(ktx, PROP_KEY);
            LabelSchemaDescriptor schemaDescriptor = switch (entityType) {
                default -> throw new IncompatibleClassChangeError();
                case EntityType.NODE -> SchemaDescriptors.forLabel((int)Tokens.Factories.LABEL.getId(ktx, LABEL), (int[])new int[]{propKeyId});
                case EntityType.RELATIONSHIP -> SchemaDescriptors.forRelType((int)Tokens.Factories.RELATIONSHIP_TYPE.getId(ktx, REL_TYPE), (int[])new int[]{propKeyId});
            };
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schemaDescriptor).withIndexType(IndexType.VECTOR).withIndexProvider(indexVersion.descriptor()).withIndexConfig(settings.toIndexConfig());
            ktx.schemaWrite().indexCreate(prototype);
        }
        catch (KernelException exception) {
            throw new RuntimeException(exception);
        }
    }

    private VectorTestUtils.VectorIndexSettings defaultSettings() {
        return VectorTestUtils.VectorIndexSettings.from((Map)IndexSettingUtil.defaultSettingsForTesting((org.neo4j.graphdb.schema.IndexType)IndexType.VECTOR.toPublicApi()));
    }

    private KernelVersion previousFrom(KernelVersion kernelVersion) {
        if (kernelVersion == KernelVersion.GLORIOUS_FUTURE) {
            return LatestVersions.LATEST_KERNEL_VERSION;
        }
        byte previous = (byte)(kernelVersion.version() - 1);
        return KernelVersion.getForVersion((byte)previous);
    }

    private void setup(KernelVersion kernelVersion) {
        ZippedStoreCommunity store = switch (kernelVersion) {
            case KernelVersion.V5_10 -> ZippedStoreCommunity.REC_AF11_V510_EMPTY;
            case KernelVersion.V5_15 -> ZippedStoreCommunity.REC_AF11_V515_EMPTY;
            case KernelVersion.V5_22 -> ZippedStoreCommunity.REC_AF11_V522_EMPTY;
            default -> throw new InvalidArgumentException("Test not setup to find a %s for %s.".formatted(ZippedStore.class.getSimpleName(), kernelVersion));
        };
        this.setup(store);
    }

    private void setup(ZippedStoreCommunity snapshot) {
        try {
            snapshot.unzip(this.testDirectory.homePath());
        }
        catch (IOException exc) {
            Assertions.fail((String)"Could not setup %s:%s".formatted(snapshot.name(), exc));
        }
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)false).setConfig(GraphDatabaseInternalSettings.latest_runtime_version, (Object)LATEST_RUNTIME_VERSION.getVersion()).setConfig(GraphDatabaseInternalSettings.latest_kernel_version, (Object)LATEST_KERNEL_VERSION.version()).setConfig(GraphDatabaseInternalSettings.always_use_latest_index_provider, (Object)false).build();
        this.database = (GraphDatabaseAPI)this.dbms.database("neo4j");
        UpgradeTestUtil.assertKernelVersion((GraphDatabaseAPI)this.database, (KernelVersion)snapshot.statistics().kernelVersion());
    }
}

