/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.description.Description;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.Tags;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ImpermanentDbmsExtension(configurationCallback="configure")
@ExtendWith(value={RandomExtension.class})
class DenseNodeConcurrencyIT {
    private static final int NUM_INITIAL_RELATIONSHIPS_PER_DENSE_NODE = 500;
    private static final int NUM_INITIAL_RELATIONSHIPS_PER_SPARSE_NODE = 10;
    private static final int NUM_DENSE_NODES_IN_MULTI_SETUP = 10;
    private static final int NUM_TASKS = 1000;
    private static final List<Label> LABELS = new Tags.Suppliers.Label(Tags.Suppliers.Suffixes.incrementing((long)0L)).get(4);
    private static final List<String> PROPERTY_KEYS = new Tags.Suppliers.PropertyKey(Tags.Suppliers.Suffixes.incrementing((long)0L)).get(3);
    private static final List<RelationshipType> RELATIONSHIP_TYPES = new Tags.Suppliers.RelationshipType(Tags.Suppliers.Suffixes.incrementing((long)0L)).get(3);
    private static final RelationshipType INITIAL_DENSE_NODE_TYPE = RELATIONSHIP_TYPES.get(0);
    @Inject
    DatabaseManagementService dbms;
    @Inject
    GraphDatabaseAPI database;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    RandomSupport random;

    DenseNodeConcurrencyIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs));
    }

    @BeforeEach
    void setUp() {
        try (Transaction tx = this.database.beginTx();){
            tx.createNode().setProperty("Test separator", (Object)"separator");
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterEach
    void consistencyCheck() throws ConsistencyCheckIncompleteException, IOException {
        try {
            DependencyResolver deps = this.database.getDependencyResolver();
            Config config = (Config)deps.resolveDependency(Config.class);
            DatabaseLayout layout = this.database.databaseLayout();
            this.dbms.shutdown();
            final ConsistencyCheckService.Result result = new ConsistencyCheckService(layout).with(config).with((FileSystemAbstraction)deps.resolveDependency(FileSystemAbstraction.class)).runFullConsistencyCheck();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isSuccessful()).as(new Description(){

                public String value() {
                    return DenseNodeConcurrencyIT.this.consistencyCheckReportAsString(result);
                }
            })).isTrue();
        }
        finally {
            this.fs.close();
        }
    }

    @Test
    void shouldHandleDetachDeleteWithConcurrentAdds() {
        long initialRelationships;
        long initialNodes;
        try (Transaction tx = this.database.beginTx();){
            initialNodes = Iterables.count((Iterable)tx.getAllNodes());
            initialRelationships = Iterables.count((Iterable)tx.getAllRelationships());
        }
        long denseNodeToDelete = this.createNode(new HashSet<Relationship>(), 100);
        AtomicInteger numNodes = new AtomicInteger(2);
        int numModifiers = Runtime.getRuntime().availableProcessors() - 1;
        int numCreators = Math.max(numModifiers * 2 / 3, 2);
        int numDeleters = Math.max(numModifiers / 3, 1);
        CountDownLatch latch = new CountDownLatch(numCreators * 2);
        AtomicBoolean done = new AtomicBoolean();
        Race race = new Race().withFailureAction(t -> done.set(true));
        race.addContestants(1, Race.throwing(() -> {
            latch.await();
            while (true) {
                try (Transaction tx = this.database.beginTx();){
                    InternalTransaction internalTx = (InternalTransaction)tx;
                    internalTx.kernelTransaction().dataWrite().nodeDetachDelete(denseNodeToDelete);
                    tx.commit();
                }
                catch (DeadlockDetectedException deadlockDetectedException) {
                    continue;
                }
                break;
            }
            numNodes.decrementAndGet();
            done.set(true);
        }));
        race.addContestants(numCreators, Race.throwing(() -> {
            try {
                int creations = 0;
                while (!done.get() && creations < 20) {
                    latch.countDown();
                    try {
                        Transaction tx = this.database.beginTx();
                        try {
                            Node denseNode = tx.getNodeById(denseNodeToDelete);
                            MyRelTypes type = this.random.nextBoolean() ? MyRelTypes.TEST : MyRelTypes.TEST2;
                            boolean increment = false;
                            switch (this.random.nextInt(3)) {
                                case 0: {
                                    denseNode.createRelationshipTo(tx.createNode(), (RelationshipType)type);
                                    increment = true;
                                    break;
                                }
                                case 1: {
                                    tx.createNode().createRelationshipTo(denseNode, (RelationshipType)type);
                                    increment = true;
                                }
                                default: {
                                    denseNode.createRelationshipTo(denseNode, (RelationshipType)type);
                                }
                            }
                            tx.commit();
                            ++creations;
                            if (increment) {
                                numNodes.incrementAndGet();
                            }
                            Thread.sleep(1L);
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                        }
                    }
                    catch (DeadlockDetectedException deadlockDetectedException) {}
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }));
        race.addContestants(numDeleters, Race.throwing(() -> {
            block9: while (true) {
                try {
                    while (!done.get()) {
                        try {
                            Transaction tx = this.database.beginTx();
                            try {
                                Node denseNode = tx.getNodeById(denseNodeToDelete);
                                Object[] relationships = (Relationship[])Iterables.asArray(Relationship.class, (Iterable)denseNode.getRelationships());
                                if (relationships.length > 0) {
                                    ((Relationship)this.random.among(relationships)).delete();
                                }
                                tx.commit();
                                Thread.sleep(1L);
                                continue block9;
                            }
                            finally {
                                if (tx != null) {
                                    tx.close();
                                }
                                continue block9;
                            }
                        }
                        catch (DeadlockDetectedException deadlockDetectedException) {
                        }
                    }
                    break;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                    break;
                }
            }
        }));
        race.goUnchecked();
        try (Transaction tx = this.database.beginTx();){
            Assertions.assertThat((long)Iterables.count((Iterable)tx.getAllNodes())).isEqualTo((long)numNodes.get() + initialNodes);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.getAllRelationships())).isEqualTo(initialRelationships);
            Assertions.assertThatThrownBy(() -> tx.getNodeById(denseNodeToDelete)).isInstanceOf(NotFoundException.class);
        }
    }

    @MethodSource(value={"permutations"})
    @ParameterizedTest(name="multipleDenseNodes:{0}, startAsDense:{1}, multipleOpsPerTx:{2}, multipleTypes:{3}, hasIndexes:{4}, opWeights:{5}")
    void shouldCreateAndDeleteRelationshipsConcurrently(boolean multipleDenseNodes, boolean startAsDense, boolean multipleOperationsInOneTx, boolean multipleTypes, boolean hasIndexes, Map<WorkType, Integer> operationWeights) {
        if (hasIndexes) {
            this.createIndexes();
        }
        ConcurrentHashMap<Long, Set<Relationship>> relationships = new ConcurrentHashMap<Long, Set<Relationship>>();
        ConcurrentHashMap.KeySetView allRelationships = ConcurrentHashMap.newKeySet();
        HashSet<Long> initialDenseNodes = new HashSet<Long>(this.createInitialNodes(multipleDenseNodes, startAsDense, relationships));
        ConcurrentHashMap.KeySetView denseNodeIds = ConcurrentHashMap.newKeySet();
        denseNodeIds.addAll(initialDenseNodes);
        relationships.forEach((nodeId, rels) -> allRelationships.addAll(rels));
        ConcurrentLinkedDeque<WorkTask> workQueue = new ConcurrentLinkedDeque<WorkTask>(this.createWork(operationWeights));
        Race race = new Race().withFailureAction(t -> workQueue.clear());
        int numWorkers = Runtime.getRuntime().availableProcessors();
        List<RelationshipType> types = multipleTypes ? RELATIONSHIP_TYPES : List.of(RELATIONSHIP_TYPES.get(0));
        AtomicInteger numDeadlocks = new AtomicInteger();
        Transaction outerTx = this.database.beginTx();
        race.addContestants(numWorkers, Race.throwing(() -> {
            WorkTask work;
            while ((work = (WorkTask)workQueue.poll()) != null) {
                boolean retry;
                ArrayList<WorkTask> txTasks = new ArrayList<WorkTask>();
                txTasks.add(work);
                while (multipleOperationsInOneTx && this.random.nextBoolean() && (work = (WorkTask)workQueue.poll()) != null) {
                    txTasks.add(work);
                }
                int numRetries = 0;
                do {
                    HashMap<Long, TxNodeChanges> txCreated = new HashMap<Long, TxNodeChanges>();
                    HashMap<Long, TxNodeChanges> txDeleted = new HashMap<Long, TxNodeChanges>();
                    try (Transaction tx = this.database.beginTx();){
                        for (WorkTask task : txTasks) {
                            task.perform(tx, denseNodeIds, (RelationshipType)this.random.among(types), relationships, allRelationships, this.random, txCreated, txDeleted);
                        }
                        tx.commit();
                        retry = false;
                        txCreated.forEach((nodeId, changes) -> ((Set)relationships.get(nodeId)).addAll(changes.relationships));
                        txDeleted.forEach((nodeId, changes) -> ((Set)relationships.get(nodeId)).removeAll(changes.relationships));
                        txCreated.forEach((nodeId, changes) -> allRelationships.addAll(changes.relationships));
                    }
                    catch (TransientTransactionFailureException e) {
                        retry = true;
                        ++numRetries;
                        allRelationships.addAll(txDeleted.values().stream().flatMap(change -> change.relationships.stream()).collect(Collectors.toSet()));
                        denseNodeIds.addAll(txDeleted.values().stream().map(change -> change.id).toList());
                        numDeadlocks.incrementAndGet();
                        Thread.sleep(this.random.nextInt(1, 10 * numRetries));
                    }
                } while (retry);
            }
        }), 1);
        race.goUnchecked();
        outerTx.commit();
        HashSet<Long> deletedDenseNodes = new HashSet<Long>(initialDenseNodes);
        deletedDenseNodes.removeAll(denseNodeIds);
        this.assertDeletedNodes(deletedDenseNodes);
        Iterator iterator = denseNodeIds.iterator();
        while (iterator.hasNext()) {
            long denseNodeId = (Long)iterator.next();
            this.assertRelationshipsAndDegrees(denseNodeId, (Set)relationships.get(denseNodeId));
        }
        Assertions.assertThat((int)numDeadlocks.get()).isLessThan(200);
    }

    private void createIndexes() {
        try (Transaction tx = this.database.beginTx();){
            for (Label label : LABELS) {
                for (String key1 : PROPERTY_KEYS) {
                    tx.schema().indexFor(label).on(key1).create();
                    for (String key2 : PROPERTY_KEYS) {
                        if (Objects.equals(key1, key2)) continue;
                        tx.schema().indexFor(label).on(key1).on(key2).create();
                    }
                }
            }
            for (RelationshipType type : RELATIONSHIP_TYPES) {
                for (String key1 : PROPERTY_KEYS) {
                    tx.schema().indexFor(type).on(key1).create();
                    for (String key2 : PROPERTY_KEYS) {
                        if (Objects.equals(key1, key2)) continue;
                        tx.schema().indexFor(type).on(key1).on(key2).create();
                    }
                }
            }
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertDeletedNodes(Set<Long> deletedInitialNodes) {
        try (Transaction tx = this.database.beginTx();){
            deletedInitialNodes.forEach(id -> {
                try {
                    Node node = tx.getNodeById(id.longValue());
                    Assertions.assertThat((Iterable)node.getLabels()).doesNotContain((Object[])new Label[]{LABELS.get(0)});
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            });
        }
    }

    static Stream<Arguments> permutations() {
        ArrayList<Arguments> permutations = new ArrayList<Arguments>();
        for (boolean multipleDenseNodes : new boolean[]{true, false}) {
            for (boolean startAsDense : new boolean[]{true, false}) {
                for (boolean multipleOpsPerTx : new boolean[]{true, false}) {
                    for (boolean multipleTypes : new boolean[]{true, false}) {
                        for (boolean hasIndexes : new boolean[]{true, false}) {
                            permutations.add(Arguments.arguments((Object[])new Object[]{multipleDenseNodes, startAsDense, multipleOpsPerTx, multipleTypes, hasIndexes, DenseNodeConcurrencyIT.operationWeights(WorkType.CREATE, 1)}));
                            if (startAsDense) {
                                permutations.add(Arguments.arguments((Object[])new Object[]{multipleDenseNodes, startAsDense, multipleOpsPerTx, multipleTypes, hasIndexes, DenseNodeConcurrencyIT.operationWeights(WorkType.DELETE, 1)}));
                                permutations.add(Arguments.arguments((Object[])new Object[]{multipleDenseNodes, startAsDense, multipleOpsPerTx, multipleTypes, hasIndexes, DenseNodeConcurrencyIT.operationWeights(WorkType.CREATE, 3, WorkType.DELETE, 4)}));
                            }
                            permutations.add(Arguments.arguments((Object[])new Object[]{multipleDenseNodes, startAsDense, multipleOpsPerTx, multipleTypes, hasIndexes, DenseNodeConcurrencyIT.operationWeights(WorkType.CREATE, 3, WorkType.DELETE, 1)}));
                            permutations.add(Arguments.arguments((Object[])new Object[]{multipleDenseNodes, startAsDense, multipleOpsPerTx, multipleTypes, hasIndexes, DenseNodeConcurrencyIT.operationWeights(WorkType.CREATE, 10, WorkType.DELETE, 6, WorkType.DELETE_ALL_TYPE_DIRECTION, 2, WorkType.DELETE_ALL_TYPE, 1, WorkType.DELETE_ALL, 1)}));
                            permutations.add(Arguments.arguments((Object[])new Object[]{multipleDenseNodes, startAsDense, multipleOpsPerTx, multipleTypes, hasIndexes, DenseNodeConcurrencyIT.operationWeights(WorkType.CREATE, 40, WorkType.DELETE, 20, WorkType.DELETE_ALL_TYPE_DIRECTION, 8, WorkType.DELETE_ALL_TYPE, 6, WorkType.DELETE_ALL, 4, WorkType.CHANGE_OTHER_DATA, 1)}));
                        }
                    }
                }
            }
        }
        return permutations.stream();
    }

    private static Map<WorkType, Integer> operationWeights(Object ... weights) {
        return MapUtil.genericMap((Object[])weights);
    }

    private void assertRelationshipsAndDegrees(long denseNodeId, final Set<Relationship> relationships) {
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.getNodeById(denseNodeId);
            final Set currentRelationships = Iterables.asSet((Iterable)node.getRelationships());
            ((IterableAssert)Assertions.assertThat((Iterable)currentRelationships).as(new Description(){

                public String value() {
                    Set shouldContain = DenseNodeConcurrencyIT.diff(relationships, currentRelationships);
                    Set shouldNotContain = DenseNodeConcurrencyIT.diff(currentRelationships, relationships);
                    return (String)(shouldContain.isEmpty() ? "" : " Should contain: " + shouldContain) + (!shouldContain.isEmpty() && !shouldNotContain.isEmpty() ? System.lineSeparator() : "") + (String)(shouldNotContain.isEmpty() ? "" : " Should not contain: " + shouldNotContain);
                }
            })).isEqualTo(relationships);
            Assertions.assertThat((int)node.getDegree()).isEqualTo(relationships.size());
            for (RelationshipType type : currentRelationships.stream().map(Relationship::getType).collect(Collectors.toSet())) {
                Assertions.assertThat((int)node.getDegree(type)).isEqualTo(currentRelationships.stream().filter(r -> r.isType(type)).count());
                Assertions.assertThat((int)node.getDegree(type, Direction.OUTGOING)).isEqualTo(currentRelationships.stream().filter(r -> r.isType(type) && r.getStartNode().equals(node)).count());
                Assertions.assertThat((int)node.getDegree(type, Direction.INCOMING)).isEqualTo(currentRelationships.stream().filter(r -> r.isType(type) && r.getEndNode().equals(node)).count());
            }
        }
    }

    private static <T> Set<T> diff(Set<T> s1, Set<T> s2) {
        HashSet<T> s = new HashSet<T>(s1);
        s.removeAll(s2);
        return s;
    }

    private Collection<WorkTask> createWork(Map<WorkType, Integer> weights) {
        ArrayList weightedWork = new ArrayList();
        weights.forEach((workType, weight) -> weightedWork.addAll(Collections.nCopies(weight, workType)));
        ArrayList<WorkTask> work = new ArrayList<WorkTask>();
        for (int i = 0; i < 1000; ++i) {
            work.add((WorkTask)this.random.among(weightedWork));
        }
        return work;
    }

    @Test
    void shouldNotBlockOnCreateOnLongChain() throws ExecutionException, InterruptedException {
        ConcurrentHashMap.KeySetView relationships = ConcurrentHashMap.newKeySet();
        long denseNodeId = this.createDenseNode(relationships);
        this.assertNotBlocking(tx -> relationships.add(tx.getNodeById(denseNodeId).createRelationshipTo(tx.createNode(), INITIAL_DENSE_NODE_TYPE)), tx -> relationships.add(tx.getNodeById(denseNodeId).createRelationshipTo(tx.createNode(), INITIAL_DENSE_NODE_TYPE)));
        this.assertRelationshipsAndDegrees(denseNodeId, relationships);
    }

    @Test
    void shouldBlockOnCreateWithNewType() throws Throwable {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        long denseNodeId = this.createDenseNode(relationships);
        this.assertBlocking(tx -> relationships.add(tx.getNodeById(denseNodeId).createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST)), tx -> relationships.add(tx.getNodeById(denseNodeId).createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST)));
        this.assertRelationshipsAndDegrees(denseNodeId, relationships);
    }

    @Test
    void shouldBlockOnCreateWithExistingTypeNewDirection() throws Throwable {
        Assumptions.assumeThat((Object)((StorageEngine)this.database.getDependencyResolver().resolveDependency(StorageEngine.class))).isInstanceOf(RecordStorageEngine.class);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        long denseNodeId = this.createDenseNode(relationships);
        this.assertBlocking(tx -> relationships.add(tx.createNode().createRelationshipTo(tx.getNodeById(denseNodeId), INITIAL_DENSE_NODE_TYPE)), tx -> relationships.add(tx.getNodeById(denseNodeId).createRelationshipTo(tx.createNode(), INITIAL_DENSE_NODE_TYPE)));
        this.assertRelationshipsAndDegrees(denseNodeId, relationships);
    }

    @Test
    void shouldNotBlockOnDeleteOnSameLongChain() throws Throwable {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        long denseNodeId = this.createDenseNode(relationships);
        long[] relationshipIds = new long[10];
        for (int i = 0; i < relationshipIds.length; ++i) {
            try (Transaction tx2 = this.database.beginTx();){
                Node denseNode = tx2.getNodeById(denseNodeId);
                Relationship relationship = denseNode.createRelationshipTo(tx2.createNode(), INITIAL_DENSE_NODE_TYPE);
                tx2.commit();
                relationships.add(relationship);
                relationshipIds[i] = relationship.getId();
                continue;
            }
        }
        this.assertNotBlocking(tx -> DenseNodeConcurrencyIT.deleteRelationship(tx.getRelationshipById(relationshipIds[3]), relationships), tx -> DenseNodeConcurrencyIT.deleteRelationship(tx.getRelationshipById(relationshipIds[7]), relationships));
        this.assertRelationshipsAndDegrees(denseNodeId, relationships);
    }

    @Test
    void shouldBlockOnCreateForNodeThatIsBeingDeleted() throws Throwable {
        long denseNodeId = this.createDenseNode(new HashSet<Relationship>());
        this.assertBlocking(tx -> {
            Node denseNode = tx.getNodeById(denseNodeId);
            Iterables.forEach((Iterable)denseNode.getRelationships(), Entity::delete);
            denseNode.delete();
        }, tx -> Assertions.assertThatThrownBy(() -> tx.getNodeById(denseNodeId).createRelationshipTo(tx.createNode(), INITIAL_DENSE_NODE_TYPE)).isInstanceOfAny(new Class[]{NotFoundException.class}), details -> details.isAt(NodeEntity.class, "createRelationshipTo"));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void txNodeLocksShouldBlockNodeOperations(boolean writeLock) throws Throwable {
        this.nodeOperationShouldBeBlockedByNodeLock(Node::delete, "delete", writeLock);
        this.nodeOperationShouldBeBlockedByNodeLock(node -> node.addLabel(Label.label((String)"foo")), "addLabel", writeLock);
        this.nodeOperationShouldBeBlockedByNodeLock(node -> node.setProperty("foo", (Object)"bar"), "setProperty", writeLock);
    }

    @Test
    void txNodeWriteLockShouldBlockRelationshipOperations() throws Throwable {
        this.nodeOperationShouldBeBlockedByNodeLock(node -> node.createRelationshipTo(node, RelationshipType.withName((String)"foo")), "createRelationshipTo", true);
        this.relationshipOperationShouldBeBlockedByNodeLock(Entity::delete, "delete", true);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void txRelationshipWriteLockShouldBlockRelationshipOperation(boolean writeLock) throws Throwable {
        this.relationshipOperationShouldBeBlockedByRelationshipLock(Entity::delete, "delete", writeLock);
        this.relationshipOperationShouldBeBlockedByRelationshipLock(relationship -> relationship.setProperty("foo", (Object)"bar"), "setProperty", writeLock);
    }

    private void nodeOperationShouldBeBlockedByNodeLock(Consumer<Node> blockedOperation, String blockedAt, boolean writeLock) throws Throwable {
        long nodeId = this.createEmptyDenseNode();
        this.operationShouldBeBlocked(tx -> tx.getNodeById(nodeId), blockedOperation, writeLock, NodeEntity.class, blockedAt);
    }

    private void relationshipOperationShouldBeBlockedByRelationshipLock(Consumer<Relationship> blockedOperation, String blockedAt, boolean writeLock) throws Throwable {
        long relId;
        long nodeId = this.createEmptyDenseNode();
        try (Transaction tx2 = this.database.beginTx();){
            relId = tx2.getNodeById(nodeId).createRelationshipTo(tx2.createNode(), INITIAL_DENSE_NODE_TYPE).getId();
            tx2.commit();
        }
        this.operationShouldBeBlocked(tx -> tx.getRelationshipById(relId), blockedOperation, writeLock, RelationshipEntity.class, blockedAt);
    }

    private void relationshipOperationShouldBeBlockedByNodeLock(Consumer<Relationship> blockedOperation, String blockedAt, boolean writeLock) throws Throwable {
        long nodeId = this.createEmptyDenseNode();
        try (Transaction tx2 = this.database.beginTx();){
            tx2.getNodeById(nodeId).createRelationshipTo(tx2.createNode(), INITIAL_DENSE_NODE_TYPE).getId();
            tx2.commit();
        }
        this.operationShouldBeBlocked(tx -> tx.getNodeById(nodeId), node -> blockedOperation.accept((Relationship)Iterables.first((Iterable)node.getRelationships())), writeLock, RelationshipEntity.class, blockedAt);
    }

    private <T extends Entity> void operationShouldBeBlocked(Function<Transaction, T> resourceSupplier, Consumer<T> blockedOperation, boolean writeLock, Class<?> blockedClass, String blockedAt) throws Throwable {
        this.assertBlocking(tx -> {
            Entity entity = (Entity)resourceSupplier.apply((Transaction)tx);
            Lock lock = writeLock ? tx.acquireWriteLock(entity) : tx.acquireReadLock(entity);
        }, tx -> blockedOperation.accept((Entity)resourceSupplier.apply((Transaction)tx)), details -> details.isAt(blockedClass, blockedAt));
    }

    private long createEmptyDenseNode() {
        long nodeId;
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getId();
            Node otherNode = tx.createNode();
            for (int i = 0; i < (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue() * 2; ++i) {
                node.createRelationshipTo(otherNode, INITIAL_DENSE_NODE_TYPE);
            }
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            Iterables.forEach((Iterable)tx.getNodeById(nodeId).getRelationships(), Entity::delete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return nodeId;
    }

    private static void deleteRelationship(Relationship relationship, Set<Relationship> relationships) {
        relationship.delete();
        relationships.remove(relationship);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotBlocking(Consumer<Transaction> tx1, Consumer<Transaction> tx2) throws InterruptedException, ExecutionException {
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("T2");){
            Barrier.Control barrier = new Barrier.Control();
            Future t2Future = null;
            try {
                t2Future = t2.executeDontWait(OtherThreadExecutor.command(() -> {
                    try (Transaction tx = this.database.beginTx();){
                        tx1.accept(tx);
                        ((TransactionImpl)tx).commit(() -> ((Barrier.Control)barrier).reached());
                    }
                }));
                barrier.await();
                try (Transaction tx = this.database.beginTx();){
                    tx2.accept(tx);
                    tx.commit();
                }
            }
            finally {
                barrier.release();
                DenseNodeConcurrencyIT.waitFor(t2Future);
            }
        }
    }

    private void assertBlocking(Consumer<Transaction> tx1, Consumer<Transaction> tx2) throws InterruptedException, ExecutionException, TimeoutException {
        this.assertBlocking(tx1, tx2, details -> details.isAt(KernelTransactionImplementation.class, "commit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertBlocking(Consumer<Transaction> tx1, Consumer<Transaction> tx2, Predicate<OtherThreadExecutor.WaitDetails> waitDetailsPredicate) throws InterruptedException, ExecutionException, TimeoutException {
        try (OtherThreadExecutor t2 = new OtherThreadExecutor("T2");
             OtherThreadExecutor t3 = new OtherThreadExecutor("T3");){
            Barrier.Control barrier = new Barrier.Control();
            Future t2Future = null;
            Future t3Future = null;
            try {
                t2Future = t2.executeDontWait(OtherThreadExecutor.command(() -> {
                    try (Transaction tx = this.database.beginTx();){
                        tx1.accept(tx);
                        tx.createNode();
                        ((TransactionImpl)tx).commit(() -> ((Barrier.Control)barrier).reached());
                    }
                }));
                barrier.await();
                t3Future = t3.executeDontWait(OtherThreadExecutor.command(() -> {
                    try (Transaction tx = this.database.beginTx();){
                        tx2.accept(tx);
                        tx.commit();
                    }
                }));
                t3.waitUntilWaiting(waitDetailsPredicate);
            }
            finally {
                barrier.release();
                DenseNodeConcurrencyIT.waitFor(t2Future);
                DenseNodeConcurrencyIT.waitFor(t3Future);
            }
        }
    }

    private static void waitFor(Future<?> future) throws ExecutionException, InterruptedException {
        if (future != null) {
            future.get();
        }
    }

    private long createDenseNode(Set<Relationship> createdRelationships) {
        return this.createNode(createdRelationships, 500);
    }

    private long createNode(Set<Relationship> createdRelationships, int numInitialRelationships) {
        try (Transaction tx = this.database.beginTx();){
            Node denseNode = tx.createNode();
            Node otherNode = tx.createNode();
            for (int i = 0; i < numInitialRelationships; ++i) {
                createdRelationships.add(denseNode.createRelationshipTo(otherNode, INITIAL_DENSE_NODE_TYPE));
            }
            tx.commit();
            long l = denseNode.getId();
            return l;
        }
    }

    private Collection<Long> createConnectedNodes(Map<Long, Set<Relationship>> createdRelationships, int numInitialRelationshipsPerNode) {
        try (Transaction tx = this.database.beginTx();){
            Object[] denseNodes = new Node[10];
            for (int i = 0; i < denseNodes.length; ++i) {
                denseNodes[i] = tx.createNode();
                createdRelationships.put(denseNodes[i].getId(), ConcurrentHashMap.newKeySet());
            }
            int numRelationships = numInitialRelationshipsPerNode * denseNodes.length;
            for (int i = 0; i < numRelationships; ++i) {
                Node startNode = (Node)this.random.among(denseNodes);
                Node endNode = (Node)this.random.among(denseNodes);
                Relationship relationship = startNode.createRelationshipTo(endNode, INITIAL_DENSE_NODE_TYPE);
                createdRelationships.get(startNode.getId()).add(relationship);
                createdRelationships.get(endNode.getId()).add(relationship);
            }
            tx.commit();
            Collection collection = Arrays.stream(denseNodes).map(Entity::getId).collect(Collectors.toList());
            return collection;
        }
    }

    private Collection<Long> createInitialNodes(boolean multipleDenseNodes, boolean startAsDense, Map<Long, Set<Relationship>> relationships) {
        Collection<Long> denseNodeIds;
        int numInitialRelationshipsPerNode;
        int n = numInitialRelationshipsPerNode = startAsDense ? 500 : 10;
        if (multipleDenseNodes) {
            denseNodeIds = this.createConnectedNodes(relationships, numInitialRelationshipsPerNode);
        } else {
            ConcurrentHashMap.KeySetView nodeRelationships = ConcurrentHashMap.newKeySet();
            long node = this.createNode(nodeRelationships, numInitialRelationshipsPerNode);
            denseNodeIds = List.of(Long.valueOf(node));
            relationships.put(node, nodeRelationships);
        }
        try (Transaction tx = this.database.beginTx();){
            denseNodeIds.forEach(l -> tx.getNodeById(l.longValue()).addLabel(LABELS.get(0)));
        }
        return denseNodeIds;
    }

    private String consistencyCheckReportAsString(ConsistencyCheckService.Result result) {
        try {
            StringBuilder builder = new StringBuilder();
            List lines = FileSystemUtils.readLines((FileSystemAbstraction)this.fs, (Path)result.reportFile(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            for (String line : lines) {
                builder.append(String.format("%s%n", line));
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum WorkType implements WorkTask
    {
        CREATE{

            @Override
            public void perform(Transaction tx, Set<Long> denseNodeIds, RelationshipType type, Map<Long, Set<Relationship>> relationshipsMirror, Set<Relationship> allRelationships, RandomSupport random, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted) {
                Node from;
                Node to = switch (random.nextInt(6)) {
                    case 0, 1, 2 -> {
                        from = WorkType.randomDenseNode(tx, denseNodeIds, random);
                        yield denseNodeIds.size() > 1 && random.nextBoolean() ? WorkType.randomDenseNode(tx, denseNodeIds, random) : tx.createNode();
                    }
                    case 3, 4 -> {
                        from = denseNodeIds.size() > 1 && random.nextBoolean() ? WorkType.randomDenseNode(tx, denseNodeIds, random) : tx.createNode();
                        yield WorkType.randomDenseNode(tx, denseNodeIds, random);
                    }
                    default -> from = WorkType.randomDenseNode(tx, denseNodeIds, random);
                };
                int numRelationships = random.nextInt(3) + 1;
                for (int i = 0; i < numRelationships; ++i) {
                    Relationship relationship = from.createRelationshipTo(to, type);
                    WorkType.trackTxRelationship(relationship, txCreated, txDeleted, denseNodeIds, true);
                }
            }
        }
        ,
        DELETE{

            @Override
            public void perform(Transaction tx, Set<Long> denseNodeIds, RelationshipType type, Map<Long, Set<Relationship>> relationshipsMirror, Set<Relationship> allRelationships, RandomSupport random, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted) {
                Node onNode = WorkType.randomDenseNode(tx, denseNodeIds, random);
                List rels = Iterables.asList((Iterable)onNode.getRelationships(new RelationshipType[]{type}));
                int batch = random.nextInt(3) + 1;
                for (int i = 0; i < batch; ++i) {
                    Relationship rel;
                    Relationship relationship = rel = rels.isEmpty() ? null : (Relationship)rels.get(random.nextInt(rels.size()));
                    if (rel == null || !allRelationships.remove(rel)) continue;
                    rels.remove(rel);
                    WorkType.safeDeleteRelationship(rel, txCreated, txDeleted, denseNodeIds);
                }
            }
        }
        ,
        DELETE_ALL_TYPE_DIRECTION{

            @Override
            public void perform(Transaction tx, Set<Long> denseNodeIds, RelationshipType type, Map<Long, Set<Relationship>> relationshipsMirror, Set<Relationship> allRelationships, RandomSupport random, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted) {
                Node onNode = WorkType.randomDenseNode(tx, denseNodeIds, random);
                try (ResourceIterable relationships = onNode.getRelationships((Direction)random.among((Object[])Direction.values()), new RelationshipType[]{type});){
                    WorkType.deleteRelationships(allRelationships, txCreated, txDeleted, (Iterable<Relationship>)relationships, denseNodeIds);
                }
            }
        }
        ,
        DELETE_ALL_TYPE{

            @Override
            public void perform(Transaction tx, Set<Long> denseNodeIds, RelationshipType type, Map<Long, Set<Relationship>> relationshipsMirror, Set<Relationship> allRelationships, RandomSupport random, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted) {
                Node onNode = WorkType.randomDenseNode(tx, denseNodeIds, random);
                WorkType.deleteRelationships(allRelationships, txCreated, txDeleted, (Iterable<Relationship>)onNode.getRelationships(new RelationshipType[]{type}), denseNodeIds);
            }
        }
        ,
        DELETE_ALL{

            @Override
            public void perform(Transaction tx, Set<Long> denseNodeIds, RelationshipType type, Map<Long, Set<Relationship>> relationshipsMirror, Set<Relationship> allRelationships, RandomSupport random, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted) {
                Node onNode = WorkType.randomDenseNode(tx, denseNodeIds, random);
                WorkType.deleteRelationships(allRelationships, txCreated, txDeleted, (Iterable<Relationship>)onNode.getRelationships(), denseNodeIds);
            }
        }
        ,
        CHANGE_OTHER_DATA{

            @Override
            public void perform(Transaction tx, Set<Long> denseNodeIds, RelationshipType type, Map<Long, Set<Relationship>> relationshipsMirror, Set<Relationship> allRelationships, RandomSupport random, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted) {
                for (int attempt = 0; attempt < 10; ++attempt) {
                    try {
                        Node onNode = WorkType.randomDenseNode(tx, denseNodeIds, random);
                        switch (random.nextInt(5)) {
                            case 0: {
                                onNode.setProperty((String)random.among(PROPERTY_KEYS), (Object)random.nextInt());
                                break;
                            }
                            case 1: {
                                onNode.removeProperty((String)random.among(PROPERTY_KEYS));
                                break;
                            }
                            case 2: {
                                onNode.addLabel((Label)random.among(LABELS));
                                break;
                            }
                            case 3: {
                                onNode.removeLabel((Label)random.among(LABELS));
                                break;
                            }
                            case 4: {
                                this.modifyRandomRelationship(onNode, type, r -> r.setProperty((String)random.among(PROPERTY_KEYS), (Object)random.nextInt()), allRelationships, random);
                            }
                            default: {
                                this.modifyRandomRelationship(onNode, type, r -> r.removeProperty((String)random.among(PROPERTY_KEYS)), allRelationships, random);
                            }
                        }
                        return;
                    }
                    catch (NotFoundException notFoundException) {
                        continue;
                    }
                }
            }

            private void modifyRandomRelationship(Node fromNode, RelationshipType type, Consumer<Relationship> modifier, Set<Relationship> allRelationships, RandomSupport random) {
                List rels = Iterables.asList((Iterable)fromNode.getRelationships(new RelationshipType[]{type}));
                while (!rels.isEmpty()) {
                    Relationship rel = (Relationship)random.among(rels);
                    if (allRelationships.remove(rel)) {
                        modifier.accept(rel);
                        allRelationships.add(rel);
                        return;
                    }
                    rels.remove(rel);
                }
            }
        };


        private static Node randomDenseNode(Transaction tx, Set<Long> denseNodeIds, RandomSupport random) {
            long id = WorkType.randomAmong(denseNodeIds, random);
            Assertions.assertThat((boolean)Record.isNull((long)id)).isFalse();
            return tx.getNodeById(id);
        }

        private static long randomAmong(Set<Long> ids, RandomSupport randomRule) {
            long value = Record.NULL_REFERENCE.longValue();
            do {
                Object[] array;
                if ((array = ids.toArray()).length < 1) continue;
                value = (Long)randomRule.among(array);
            } while (!ids.contains(value) && !ids.isEmpty());
            return ids.isEmpty() ? Record.NULL_REFERENCE.longValue() : value;
        }

        private static void safeDeleteRelationship(Relationship relationship, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted, Set<Long> denseNodeIds) {
            try {
                WorkType.trackTxRelationship(relationship, txCreated, txDeleted, denseNodeIds, false);
                relationship.delete();
            }
            catch (NotFoundException e) {
                throw new TransientTransactionFailureException((Status)Status.Database.Unknown, "Relationship vanished in front of us, hmm");
            }
        }

        private static void trackTxRelationship(Relationship relationship, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted, Set<Long> denseNodeIds, boolean create) {
            Map<Long, TxNodeChanges> map2;
            Map<Long, TxNodeChanges> map1 = create ? txCreated : txDeleted;
            Map<Long, TxNodeChanges> map = map2 = create ? txDeleted : txCreated;
            if (denseNodeIds.contains(relationship.getStartNodeId())) {
                map1.computeIfAbsent((Long)Long.valueOf((long)relationship.getStartNodeId()), (Function<Long, TxNodeChanges>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(long ), (Ljava/lang/Long;)Lorg/neo4j/graphdb/DenseNodeConcurrencyIT$TxNodeChanges;)()).relationships.add(relationship);
                map2.computeIfAbsent((Long)Long.valueOf((long)relationship.getStartNodeId()), (Function<Long, TxNodeChanges>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(long ), (Ljava/lang/Long;)Lorg/neo4j/graphdb/DenseNodeConcurrencyIT$TxNodeChanges;)()).relationships.remove(relationship);
            }
            if (denseNodeIds.contains(relationship.getEndNodeId())) {
                map1.computeIfAbsent((Long)Long.valueOf((long)relationship.getEndNodeId()), (Function<Long, TxNodeChanges>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(long ), (Ljava/lang/Long;)Lorg/neo4j/graphdb/DenseNodeConcurrencyIT$TxNodeChanges;)()).relationships.add(relationship);
                map2.computeIfAbsent((Long)Long.valueOf((long)relationship.getEndNodeId()), (Function<Long, TxNodeChanges>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(long ), (Ljava/lang/Long;)Lorg/neo4j/graphdb/DenseNodeConcurrencyIT$TxNodeChanges;)()).relationships.remove(relationship);
            }
        }

        private static void deleteRelationships(Set<Relationship> allRelationships, Map<Long, TxNodeChanges> txCreated, Map<Long, TxNodeChanges> txDeleted, Iterable<Relationship> relationships, Set<Long> denseNodeIds) {
            List readRelationships = Iterables.asList(relationships);
            readRelationships.stream().filter(allRelationships::remove).forEach(relationship -> WorkType.safeDeleteRelationship(relationship, txCreated, txDeleted, denseNodeIds));
        }
    }

    private static interface WorkTask {
        public void perform(Transaction var1, Set<Long> var2, RelationshipType var3, Map<Long, Set<Relationship>> var4, Set<Relationship> var5, RandomSupport var6, Map<Long, TxNodeChanges> var7, Map<Long, TxNodeChanges> var8);
    }

    private static class TxNodeChanges {
        final long id;
        Set<Relationship> relationships = new HashSet<Relationship>();

        private TxNodeChanges(long id) {
            this.id = id;
        }
    }
}

