/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.util.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@DbmsExtension(configurationCallback="configuration")
@ExtendWith(value={RandomExtension.class})
public class FindEntityByTokenAndPropertyIT {
    private static final String TOKEN = "token";
    private static final String PROPERTY_KEY = "prop";
    private static final String PROPERTY_KEY_2 = "prop2";
    private static final String PROPERTY_KEY_3 = "prop3";
    private static final String[] PROPERTY_KEYS = new String[]{"prop", "prop2", "prop3"};
    private final MyIndexMonitor indexMonitor = new MyIndexMonitor();
    @Inject
    private GraphDatabaseService db;
    @Inject
    private RandomSupport random;

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)this.indexMonitor, new String[0]);
        builder.setMonitors(monitors);
    }

    @BeforeEach
    private void cleanDb() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
        tx = this.db.beginTx();
        try (ResourceIterable allRelationships = tx.getAllRelationships();){
            allRelationships.forEach(Entity::delete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try (ResourceIterable allNodes = tx.getAllNodes();){
            allNodes.forEach(Node::delete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilities"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatiblePropertyValue(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex) {
        IndexDescriptor firstDescriptor;
        Object value = this.random.nextValue().asObject();
        Entity entity = this.createEntity(entityCreator, value);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, value);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, firstIndex.supportedType(value));
        this.validateUsedExpectedIndex("exact match single property: " + this.valueAsString(value), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesMultiIndex"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatiblePropertyValueMultipleIndexes(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex, SupportedIndexType secondIndex) {
        IndexDescriptor secondDescriptor;
        IndexDescriptor firstDescriptor;
        Object value = this.random.nextValue().asObject();
        Entity entity = this.createEntity(entityCreator, value);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY);
            secondDescriptor = entityCreator.createIndex(tx, secondIndex.indexType(), TOKEN, PROPERTY_KEY);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, value);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, secondDescriptor, firstIndex.supportedType(value), secondIndex.supportedType(value));
        this.validateUsedExpectedIndex("exact match single property: " + this.valueAsString(value), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesComposite2"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatiblePropertyValueCompositeQuery2(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex) {
        IndexDescriptor firstDescriptor;
        Object value1 = this.random.nextValue().asObject();
        Object value2 = this.random.nextValue().asObject();
        Entity entity = this.createEntity(entityCreator, value1, value2);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY, PROPERTY_KEY_2);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, value1, PROPERTY_KEY_2, value2);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, firstIndex.supportedType(value1, value2));
        this.validateUsedExpectedIndex("exact match composite property: " + this.compositeValueString(value1, value2), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesComposite2MultiIndex"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatiblePropertyValueCompositeQuery2MultiIndex(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex, SupportedIndexType secondIndex) {
        IndexDescriptor secondDescriptor;
        IndexDescriptor firstDescriptor;
        Object value1 = this.random.nextValue().asObject();
        Object value2 = this.random.nextValue().asObject();
        Entity entity = this.createEntity(entityCreator, value1, value2);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY, PROPERTY_KEY_2);
            secondDescriptor = entityCreator.createIndex(tx, secondIndex.indexType(), TOKEN, PROPERTY_KEY, PROPERTY_KEY_2);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, value1, PROPERTY_KEY_2, value2);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, secondDescriptor, firstIndex.supportedType(value1, value2), secondIndex.supportedType(value1, value2));
        this.validateUsedExpectedIndex("exact match composite property: " + this.compositeValueString(value1, value2), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesComposite3"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatiblePropertyValueCompositeQuery3(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex) {
        IndexDescriptor firstDescriptor;
        Object value1 = this.random.nextValue().asObject();
        Object value2 = this.random.nextValue().asObject();
        Object value3 = this.random.nextValue().asObject();
        Entity entity = this.createEntity(entityCreator, value1, value2, value3);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY, PROPERTY_KEY_2, PROPERTY_KEY_3);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, value1, PROPERTY_KEY_2, value2, PROPERTY_KEY_3, value3);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, firstIndex.supportedType(value1, value2, value3));
        this.validateUsedExpectedIndex("exact match composite property: " + this.compositeValueString(value1, value2, value3), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesComposite3MultiIndex"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatiblePropertyValueCompositeQuery3MultiIndex(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex, SupportedIndexType secondIndex) {
        IndexDescriptor secondDescriptor;
        IndexDescriptor firstDescriptor;
        Object value1 = this.random.nextValue().asObject();
        Object value2 = this.random.nextValue().asObject();
        Object value3 = this.random.nextValue().asObject();
        Entity entity = this.createEntity(entityCreator, value1, value2, value3);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY, PROPERTY_KEY_2, PROPERTY_KEY_3);
            secondDescriptor = entityCreator.createIndex(tx, secondIndex.indexType(), TOKEN, PROPERTY_KEY, PROPERTY_KEY_2, PROPERTY_KEY_3);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, value1, PROPERTY_KEY_2, value2, PROPERTY_KEY_3, value3);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, secondDescriptor, firstIndex.supportedType(value1, value2, value3), secondIndex.supportedType(value1, value2, value3));
        this.validateUsedExpectedIndex("exact match composite property: " + this.compositeValueString(value1, value2, value3), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesStringSearch"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatibleStringSearch(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndexType, SearchMode searchMode) {
        IndexDescriptor firstDescriptor;
        String value = this.random.randomValues().nextBasicMultilingualPlaneTextValue(4, 20).stringValue();
        String template = searchMode.asTemplate(value);
        StringSearchMode stringSearchMode = searchMode.mode();
        Entity entity = this.createEntity(entityCreator, value);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndexType.indexType(), TOKEN, PROPERTY_KEY);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, template, stringSearchMode);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, firstIndexType.supportedStringSearch(stringSearchMode));
        this.validateUsedExpectedIndex("string search: " + stringSearchMode + " on template " + template + ", expecting " + this.valueAsString(value), expectedDescriptors);
    }

    @ParameterizedTest
    @MethodSource(value={"indexCompatibilitiesStringSearchMultiIndex"})
    void shouldUseIndexWhenFindingEntityWithIndexCompatibleStringSearchMultiIndex(EntityCreator entityCreator, FindMethod findMethod, SupportedIndexType firstIndex, SupportedIndexType secondIndex, SearchMode searchMode) {
        IndexDescriptor secondDescriptor;
        IndexDescriptor firstDescriptor;
        String value = this.random.randomValues().nextBasicMultilingualPlaneTextValue(4, 20).stringValue();
        String template = searchMode.asTemplate(value);
        StringSearchMode stringSearchMode = searchMode.mode();
        Entity entity = this.createEntity(entityCreator, value);
        try (Transaction tx = this.db.beginTx();){
            firstDescriptor = entityCreator.createIndex(tx, firstIndex.indexType(), TOKEN, PROPERTY_KEY);
            secondDescriptor = entityCreator.createIndex(tx, secondIndex.indexType(), TOKEN, PROPERTY_KEY);
            tx.commit();
        }
        this.awaitIndexes();
        this.indexMonitor.clear();
        tx = this.db.beginTx();
        try {
            ResourceIterator<? extends Entity> result = findMethod.find(tx, TOKEN, PROPERTY_KEY, template, stringSearchMode);
            FindEntityByTokenAndPropertyIT.assertFoundEntity(entity, result);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        IndexDescriptor[] expectedDescriptors = FindEntityByTokenAndPropertyIT.expectedDescriptors(firstDescriptor, secondDescriptor, firstIndex.supportedStringSearch(stringSearchMode), secondIndex.supportedStringSearch(stringSearchMode));
        this.validateUsedExpectedIndex("string search: " + stringSearchMode + " on template " + template + ", expecting " + this.valueAsString(value), expectedDescriptors);
    }

    private Entity createEntity(EntityCreator entityCreator, Object ... values) {
        Entity entity;
        try (Transaction tx = this.db.beginTx();){
            entity = entityCreator.createEntity(tx, TOKEN);
            for (int i = 0; i < values.length; ++i) {
                entity.setProperty(PROPERTY_KEYS[i], values[i]);
            }
            tx.commit();
        }
        return entity;
    }

    private void validateUsedExpectedIndex(String queryDescription, IndexDescriptor ... anyExpectedIndexDescriptor) {
        boolean expectedToUseIndex = anyExpectedIndexDescriptor.length > 0;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.indexMonitor.queriedIndex).as("used an index for " + queryDescription, new Object[0])).isEqualTo(expectedToUseIndex);
        if (expectedToUseIndex) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])anyExpectedIndexDescriptor).as("used any of expected index for " + queryDescription, new Object[0])).contains((Object[])new IndexDescriptor[]{this.indexMonitor.descriptor});
        }
    }

    private String valueAsString(Object value) {
        if (Arrays.isArray((Object)value)) {
            return ArrayUtils.toString((Object)value);
        }
        return value.toString();
    }

    private String compositeValueString(Object ... values) {
        StringJoiner joiner = new StringJoiner(" AND ");
        java.util.Arrays.stream(values).forEach(v -> joiner.add(this.valueAsString(v)));
        return joiner.toString();
    }

    private void awaitIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
    }

    private static void assertFoundEntity(Entity entity, ResourceIterator<? extends Entity> result) {
        ((IteratorAssert)Assertions.assertThat(result).as("result iterator", new Object[0])).isNotNull();
        ((IteratorAssert)Assertions.assertThat(result).as("result iterator", new Object[0])).hasNext();
        ((ObjectAssert)Assertions.assertThat((Object)((Entity)result.next())).as("entity", new Object[0])).isEqualTo((Object)entity);
        ((IteratorAssert)Assertions.assertThat(result).as("result iterator", new Object[0])).isExhausted();
    }

    private static IndexDescriptor[] expectedDescriptors(IndexDescriptor firstDescriptor, boolean firstIndexSupportType) {
        IndexDescriptor[] indexDescriptorArray;
        if (firstIndexSupportType) {
            IndexDescriptor[] indexDescriptorArray2 = new IndexDescriptor[1];
            indexDescriptorArray = indexDescriptorArray2;
            indexDescriptorArray2[0] = firstDescriptor;
        } else {
            indexDescriptorArray = new IndexDescriptor[]{};
        }
        return indexDescriptorArray;
    }

    private static IndexDescriptor[] expectedDescriptors(IndexDescriptor firstDescriptor, IndexDescriptor secondDescriptor, boolean firstIndexSupportType, boolean secondIndexSupportType) {
        ArrayList<IndexDescriptor> expectedIndexes = new ArrayList<IndexDescriptor>();
        if (firstIndexSupportType) {
            expectedIndexes.add(firstDescriptor);
        }
        if (secondIndexSupportType) {
            expectedIndexes.add(secondDescriptor);
        }
        return (IndexDescriptor[])expectedIndexes.toArray(IndexDescriptor[]::new);
    }

    public static Stream<Arguments> indexCompatibilities() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (SupportedIndexType index : SupportedIndexType.values()) {
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.singleNode, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.singleNodeFromExecutionContext, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodes, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContext, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesMap, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextMap, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.singleRelationship, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationships, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsMap, index}));
        }
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesMultiIndex() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (SupportedIndexType firstIndex : SupportedIndexType.values()) {
            for (SupportedIndexType secondIndex : SupportedIndexType.values()) {
                if (firstIndex == secondIndex) continue;
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.singleNode, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.singleNodeFromExecutionContext, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodes, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContext, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesMap, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextMap, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.singleRelationship, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationships, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsMap, firstIndex, secondIndex}));
            }
        }
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesComposite2() {
        ArrayList arguments = new ArrayList();
        java.util.Arrays.stream(SupportedIndexType.values()).filter(SupportedIndexType::supportCompositeIndex).forEach(index -> {
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesComposite2, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextComposite2, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesMap, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextMap, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsComposite2, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsMap, index}));
        });
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesComposite2MultiIndex() {
        ArrayList arguments = new ArrayList();
        java.util.Arrays.stream(SupportedIndexType.values()).filter(SupportedIndexType::supportCompositeIndex).forEach(firstIndex -> java.util.Arrays.stream(SupportedIndexType.values()).filter(SupportedIndexType::supportCompositeIndex).forEach(secondIndex -> {
            if (firstIndex != secondIndex) {
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesComposite2, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextComposite2, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesMap, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextMap, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsComposite2, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsMap, firstIndex, secondIndex}));
            }
        }));
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesComposite3() {
        ArrayList arguments = new ArrayList();
        java.util.Arrays.stream(SupportedIndexType.values()).filter(SupportedIndexType::supportCompositeIndex).forEach(index -> {
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesComposite3, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextComposite3, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesMap, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextMap, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsComposite3, index}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsMap, index}));
        });
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesComposite3MultiIndex() {
        ArrayList arguments = new ArrayList();
        java.util.Arrays.stream(SupportedIndexType.values()).filter(SupportedIndexType::supportCompositeIndex).forEach(firstIndex -> java.util.Arrays.stream(SupportedIndexType.values()).filter(SupportedIndexType::supportCompositeIndex).forEach(secondIndex -> {
            if (firstIndex != secondIndex) {
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesComposite3, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextComposite3, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesMap, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.multipleNodesFromExecutionContextMap, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsComposite3, firstIndex, secondIndex}));
                arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.multipleRelationshipsMap, firstIndex, secondIndex}));
            }
        }));
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesStringSearch() {
        ArrayList arguments = new ArrayList();
        java.util.Arrays.stream(SupportedIndexType.values()).forEach(index -> java.util.Arrays.stream(SearchMode.values()).forEach(searchMode -> {
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.stringSearchNodes, index, searchMode}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.stringSearchNodesFromExecution, index, searchMode}));
            arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.stringSearchRelationships, index, searchMode}));
        }));
        return arguments.stream();
    }

    public static Stream<Arguments> indexCompatibilitiesStringSearchMultiIndex() {
        ArrayList arguments = new ArrayList();
        java.util.Arrays.stream(SupportedIndexType.values()).forEach(firstIndex -> java.util.Arrays.stream(SupportedIndexType.values()).forEach(secondIndex -> {
            if (firstIndex != secondIndex) {
                java.util.Arrays.stream(SearchMode.values()).forEach(searchMode -> {
                    arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.stringSearchNodes, firstIndex, secondIndex, searchMode}));
                    arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.NODE, FindMethod.stringSearchNodesFromExecution, firstIndex, secondIndex, searchMode}));
                    arguments.add(Arguments.of((Object[])new Object[]{EntityCreator.RELATIONSHIP, FindMethod.stringSearchRelationships, firstIndex, secondIndex, searchMode}));
                });
            }
        }));
        return arguments.stream();
    }

    private static Transaction executionContextTransaction(Transaction tx) {
        InternalTransaction internalTx = (InternalTransaction)tx;
        KernelTransaction ktx = internalTx.kernelTransaction();
        internalTx.registerCloseableResource((AutoCloseable)ktx.acquireStatement());
        ExecutionContext executionContext = ktx.createExecutionContext();
        internalTx.registerCloseableResource(() -> {
            executionContext.complete();
            executionContext.close();
        });
        return new ExecutionContextProcedureTransaction(executionContext);
    }

    private static class MyIndexMonitor
    extends IndexMonitor.MonitorAdapter {
        private IndexDescriptor descriptor;
        private boolean queriedIndex;

        private MyIndexMonitor() {
        }

        public void queried(IndexDescriptor descriptor) {
            this.queriedIndex = true;
            this.descriptor = descriptor;
        }

        private void clear() {
            this.descriptor = null;
            this.queriedIndex = false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum EntityCreator {
        NODE{

            @Override
            Entity createEntity(Transaction tx, String token) {
                return tx.createNode(new Label[]{Label.label((String)token)});
            }

            @Override
            IndexDescriptor createIndex(Transaction tx, IndexType indexType, String token, String ... propertyKeys) {
                Label label = Label.label((String)token);
                IndexCreator indexCreator = tx.schema().indexFor(label);
                indexCreator = EntityCreator.onProperties(indexCreator, propertyKeys);
                IndexDefinition indexDefinition = indexCreator.withIndexType(indexType).create();
                return ((IndexDefinitionImpl)indexDefinition).getIndexReference();
            }
        }
        ,
        RELATIONSHIP{

            @Override
            Entity createEntity(Transaction tx, String token) {
                return tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)token));
            }

            @Override
            IndexDescriptor createIndex(Transaction tx, IndexType indexType, String token, String ... propertyKeys) {
                RelationshipType type = RelationshipType.withName((String)token);
                IndexCreator indexCreator = tx.schema().indexFor(type);
                indexCreator = EntityCreator.onProperties(indexCreator, propertyKeys);
                IndexDefinition indexDefinition = indexCreator.withIndexType(indexType).create();
                return ((IndexDefinitionImpl)indexDefinition).getIndexReference();
            }
        };


        abstract Entity createEntity(Transaction var1, String var2);

        abstract IndexDescriptor createIndex(Transaction var1, IndexType var2, String var3, String ... var4);

        private static IndexCreator onProperties(IndexCreator indexCreator, String[] propertyKeys) {
            for (String propertyKey : propertyKeys) {
                indexCreator = indexCreator.on(propertyKey);
            }
            return indexCreator;
        }
    }

    private static enum SupportedIndexType {
        RANGE(IndexType.RANGE, Predicates.alwaysTrue(), Predicates.alwaysTrue(), true),
        TEXT(IndexType.TEXT, value -> value instanceof String || value instanceof Character, Predicates.alwaysTrue(), false),
        POINT(IndexType.POINT, value -> value instanceof Point, Predicates.alwaysFalse(), false),
        FULLTEXT(IndexType.FULLTEXT, Predicates.alwaysFalse(), Predicates.alwaysFalse(), true);

        private final IndexType indexType;
        private final Predicate<Object> supportedType;
        private final Predicate<StringSearchMode> supportedStringSearch;
        private final boolean supportCompositeIndex;

        private SupportedIndexType(IndexType indexType, Predicate<Object> supportedType, Predicate<StringSearchMode> supportedStringSearch, boolean supportCompositeIndex) {
            this.indexType = indexType;
            this.supportedType = supportedType;
            this.supportedStringSearch = supportedStringSearch;
            this.supportCompositeIndex = supportCompositeIndex;
        }

        IndexType indexType() {
            return this.indexType;
        }

        boolean supportedType(Object ... values) {
            return java.util.Arrays.stream(values).allMatch(this.supportedType);
        }

        boolean supportedStringSearch(StringSearchMode searchMode) {
            return this.supportedStringSearch.test(searchMode);
        }

        boolean supportCompositeIndex() {
            return this.supportCompositeIndex;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum FindMethod {
        singleNode{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return Iterators.asResourceIterator(Collections.singletonList(tx.findNode(Label.label((String)token), propertyKey, propertyValue)));
            }
        }
        ,
        singleNodeFromExecutionContext{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return Iterators.asResourceIterator(Collections.singletonList(FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNode(Label.label((String)token), propertyKey, propertyValue)));
            }
        }
        ,
        multipleNodes{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return tx.findNodes(Label.label((String)token), propertyKey, propertyValue);
            }
        }
        ,
        multipleNodesFromExecutionContext{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), propertyKey, propertyValue);
            }
        }
        ,
        multipleNodesComposite2{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
                return tx.findNodes(Label.label((String)token), propertyKey1, propertyValue1, propertyKey2, propertyValue2);
            }
        }
        ,
        multipleNodesFromExecutionContextComposite2{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), propertyKey1, propertyValue1, propertyKey2, propertyValue2);
            }
        }
        ,
        multipleNodesComposite3{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
                return tx.findNodes(Label.label((String)token), propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3);
            }
        }
        ,
        multipleNodesFromExecutionContextComposite3{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3);
            }
        }
        ,
        multipleNodesMap{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return tx.findNodes(Label.label((String)token), Map.of(propertyKey, propertyValue));
            }

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
                return tx.findNodes(Label.label((String)token), Map.of(propertyKey1, propertyValue1, propertyKey2, propertyValue2));
            }

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
                return tx.findNodes(Label.label((String)token), Map.of(propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3));
            }
        }
        ,
        multipleNodesFromExecutionContextMap{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), Map.of(propertyKey, propertyValue));
            }

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), Map.of(propertyKey1, propertyValue1, propertyKey2, propertyValue2));
            }

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), Map.of(propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3));
            }
        }
        ,
        stringSearchNodes{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, String template, StringSearchMode searchMode) {
                return tx.findNodes(Label.label((String)token), propertyKey, template, searchMode);
            }
        }
        ,
        stringSearchNodesFromExecution{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, String template, StringSearchMode searchMode) {
                return FindEntityByTokenAndPropertyIT.executionContextTransaction(tx).findNodes(Label.label((String)token), propertyKey, template, searchMode);
            }
        }
        ,
        singleRelationship{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return Iterators.asResourceIterator(Collections.singletonList(tx.findRelationship(RelationshipType.withName((String)token), propertyKey, propertyValue)));
            }
        }
        ,
        multipleRelationships{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return tx.findRelationships(RelationshipType.withName((String)token), propertyKey, propertyValue);
            }
        }
        ,
        multipleRelationshipsComposite2{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
                return tx.findRelationships(RelationshipType.withName((String)token), propertyKey1, propertyValue1, propertyKey2, propertyValue2);
            }
        }
        ,
        multipleRelationshipsComposite3{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
                return tx.findRelationships(RelationshipType.withName((String)token), propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3);
            }
        }
        ,
        multipleRelationshipsMap{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
                return tx.findRelationships(RelationshipType.withName((String)token), Map.of(propertyKey, propertyValue));
            }

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
                return tx.findRelationships(RelationshipType.withName((String)token), Map.of(propertyKey1, propertyValue1, propertyKey2, propertyValue2));
            }

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
                return tx.findRelationships(RelationshipType.withName((String)token), Map.of(propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3));
            }
        }
        ,
        stringSearchRelationships{

            @Override
            ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, String template, StringSearchMode searchMode) {
                return tx.findRelationships(RelationshipType.withName((String)token), propertyKey, template, searchMode);
            }
        };


        ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, Object propertyValue) {
            throw new UnsupportedOperationException("This FindMethod does not support single property query");
        }

        ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2) {
            throw new UnsupportedOperationException("This FindMethod does not support composite query with 2 property keys");
        }

        ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey1, Object propertyValue1, String propertyKey2, Object propertyValue2, String propertyKey3, Object propertyValue3) {
            throw new UnsupportedOperationException("This FindMethod does not support composite query with 3 property keys");
        }

        ResourceIterator<? extends Entity> find(Transaction tx, String token, String propertyKey, String template, StringSearchMode searchMode) {
            throw new UnsupportedOperationException("This FindMethod does not support string search");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SearchMode {
        EXACT(StringSearchMode.EXACT){

            @Override
            String asTemplate(String propertyValue) {
                return propertyValue;
            }
        }
        ,
        PREFIX(StringSearchMode.PREFIX){

            @Override
            String asTemplate(String propertyValue) {
                return propertyValue.substring(0, propertyValue.length() / 2);
            }
        }
        ,
        SUFFIX(StringSearchMode.SUFFIX){

            @Override
            String asTemplate(String propertyValue) {
                return propertyValue.substring(propertyValue.length() / 2);
            }
        }
        ,
        CONTAINS(StringSearchMode.CONTAINS){

            @Override
            String asTemplate(String propertyValue) {
                int quarter = propertyValue.length() / 4;
                return propertyValue.substring(quarter, quarter * 3);
            }
        };

        private final StringSearchMode mode;

        private SearchMode(StringSearchMode mode) {
            this.mode = mode;
        }

        StringSearchMode mode() {
            return this.mode;
        }

        abstract String asTemplate(String var1);
    }
}

