/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class FindRelationshipsIT {
    private static final RelationshipType REL_TYPE = RelationshipType.withName((String)"REL_TYPE");
    private static final RelationshipType OTHER_REL_TYPE = RelationshipType.withName((String)"OTHER_REL_TYPE");
    @Inject
    GraphDatabaseService db;

    private static Stream<Arguments> indexConfiguration() {
        return Stream.of(Arguments.of((Object[])new Object[]{"with token indexes", false}), Arguments.of((Object[])new Object[]{"without token indexes", true}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"indexConfiguration"})
    void findRelationshipsWhenTypeNotExistShouldGiveEmptyIterator(String name, boolean removeTokenIndex) {
        this.prepareIndexSetup(removeTokenIndex);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            tx.commit();
        }
        tx = this.db.beginTx();
        try (ResourceIterator relationships = tx.findRelationships(REL_TYPE);){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)relationships.hasNext());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"indexConfiguration"})
    void findRelationshipsShouldGiveAllRelationshipsOfType(String name, boolean removeTokenIndex) {
        List result;
        Relationship rel2;
        Relationship rel1;
        this.prepareIndexSetup(removeTokenIndex);
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            rel1 = tx.createNode().createRelationshipTo(tx.createNode(), REL_TYPE);
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            rel2 = tx.createNode().createRelationshipTo(tx.createNode(), REL_TYPE);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            result = Iterators.asList((Iterator)tx.findRelationships(REL_TYPE));
        }
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new Relationship[]{rel1, rel2});
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"indexConfiguration"})
    void findRelationshipsShouldIncludeChangesInTx(String name, boolean removeTokenIndex) {
        List result;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        this.prepareIndexSetup(removeTokenIndex);
        Label label = Label.label((String)"label");
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            Node node = tx.createNode(new Label[]{label});
            node.setProperty("key", (Object)"value");
            node.createRelationshipTo(tx.createNode(), REL_TYPE);
            node.createRelationshipTo(tx.createNode(), REL_TYPE);
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            rel1 = tx.createNode().createRelationshipTo(tx.createNode(), REL_TYPE);
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Node node2 = tx.createNode();
            rel2 = node.createRelationshipTo(node2, REL_TYPE);
            tx.createNode().createRelationshipTo(tx.createNode(), OTHER_REL_TYPE);
            rel3 = node2.createRelationshipTo(node, REL_TYPE);
            Iterables.forEach((Iterable)tx.findNode(label, "key", (Object)"value").getRelationships(), Entity::delete);
            result = Iterators.asList((Iterator)tx.findRelationships(REL_TYPE));
        }
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new Relationship[]{rel1, rel2, rel3});
    }

    private void prepareIndexSetup(boolean removeTokenIndex) {
        if (removeTokenIndex) {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexes().forEach(IndexDefinition::drop);
                tx.commit();
            }
        }
    }
}

