/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ImpermanentDbmsExtension
@ExtendWith(value={RandomExtension.class})
public class TransactionStoreConcurrentIT {
    public static final int TX_COUNT = 1000;
    @Inject
    private GraphDatabaseService db;
    @Inject
    private GraphDatabaseAPI dbapi;
    @Inject
    private RandomSupport random;

    @BeforeEach
    void before() {
        for (int i = 0; i < 1000; ++i) {
            this.createTx();
        }
    }

    @RepeatedTest(value=10)
    void testConcurentScanOfTransactionLog() throws Throwable {
        Race race = new Race();
        race.addContestants(100, this::doThings);
        race.addContestant(this::createTx, 100);
        race.go();
    }

    private void doThings() {
        try {
            LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)this.dbapi.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
            try (TransactionCursor txCursor = logicalTransactionStore.getTransactions(this.random.nextLong(500L, 1000L));){
                while (txCursor.next()) {
                    txCursor.position();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Thread.currentThread().getName(), e);
        }
    }

    private void createTx() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().setProperty("test", (Object)"Test");
            tx.commit();
        }
    }
}

