/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.PrimitiveIterator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexPartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.PropertyIndexSeekPartitionedScanTestSuite;

abstract class RelationshipPropertyIndexSeekPartitionedScanTestSuite
extends PropertyIndexSeekPartitionedScanTestSuite<RelationshipValueIndexCursor> {
    RelationshipPropertyIndexSeekPartitionedScanTestSuite(PropertyIndexPartitionedScanTestSuite.TestIndexType index) {
        super(index);
    }

    public final PartitionedScanFactories.RelationshipPropertyIndexSeek getFactory() {
        return PartitionedScanFactories.RelationshipPropertyIndexSeek.FACTORY;
    }

    @Nested
    class WithData
    extends PropertyIndexSeekPartitionedScanTestSuite.WithData<RelationshipValueIndexCursor> {
        WithData() {
            super(RelationshipPropertyIndexSeekPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> setupDatabase() {
            boolean numberOfRelTypes = true;
            int numberOfPropKeys = 2;
            int numberOfProperties = 4096;
            this.ratioForExactQuery = 0.002;
            Integer relTypeId = this.createTags(1, this.factory.getTokenSupplier()).get(0);
            int[] propKeyIds = this.createTags(2, this.factory.getPropKeySupplier()).stream().mapToInt(i -> i).toArray();
            this.createIndexes(RelationshipPropertyIndexSeekPartitionedScanTestSuite.this.createIndexPrototypes(relTypeId, propKeyIds));
            return this.createData(4096, relTypeId, propKeyIds);
        }

        @Override
        protected PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> createData(int numberOfProperties, int relTypeId, int[] propKeyIds) {
            PropertyIndexSeekPartitionedScanTestSuite.TrackEntityIdsMatchingQuery tracking = new PropertyIndexSeekPartitionedScanTestSuite.TrackEntityIdsMatchingQuery();
            PrimitiveIterator.OfInt propValues = this.random.ints((long)numberOfProperties).iterator();
            int numberOfCreatedProperties = 0;
            try (KernelTransaction tx = this.beginTx();){
                Write write = tx.dataWrite();
                while (propValues.hasNext()) {
                    PropertyIndexPartitionedScanTestSuite.PropertyRecord[] assignedProperties = new PropertyIndexPartitionedScanTestSuite.PropertyRecord[propKeyIds.length];
                    long relId = write.relationshipCreate(write.nodeCreate(), relTypeId, write.nodeCreate());
                    for (int i = 0; i < propKeyIds.length; ++i) {
                        if (!propValues.hasNext()) continue;
                        PropertyIndexPartitionedScanTestSuite.PropertyRecord prop = PropertyIndexPartitionedScanTestSuite.createRandomPropertyRecord(this.random, propKeyIds[i], propValues.next());
                        write.relationshipSetProperty(relId, prop.id(), prop.value());
                        ++numberOfCreatedProperties;
                        assignedProperties[i] = prop;
                        IndexDescriptor index = this.factory.getIndex(tx, relTypeId, prop.id());
                        tracking.generateAndTrack(relId, this.shouldIncludeExactQuery(), index, prop);
                    }
                    IndexDescriptor index = this.factory.getIndex(tx, relTypeId, propKeyIds);
                    tracking.generateAndTrack(relId, this.shouldIncludeExactQuery(), index, assignedProperties);
                }
                tx.commit();
            }
            catch (KernelException e) {
                throw new AssertionError("failed to create database", e);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCreatedProperties).as("node properties created", new Object[0])).isEqualTo(numberOfProperties);
            return tracking.get();
        }
    }

    @Nested
    class WithoutData
    extends PropertyIndexSeekPartitionedScanTestSuite.WithoutData<RelationshipValueIndexCursor> {
        WithoutData() {
            super(RelationshipPropertyIndexSeekPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<PropertyIndexSeekPartitionedScanTestSuite.PropertyKeySeekQuery> setupDatabase() {
            boolean numberOfRelTypes = true;
            int numberOfPropKeys = 2;
            Integer relTypeId = this.createTags(1, this.factory.getTokenSupplier()).get(0);
            int[] propKeyIds = this.createTags(2, this.factory.getPropKeySupplier()).stream().mapToInt(i -> i).toArray();
            this.createIndexes(RelationshipPropertyIndexSeekPartitionedScanTestSuite.this.createIndexPrototypes(relTypeId, propKeyIds));
            return this.emptyQueries(relTypeId, propKeyIds);
        }
    }
}

