/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.WorkerContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.newapi.DefaultNodeBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;

public final class TestUtils {
    private TestUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    static void assertDistinct(LongList ... lists) {
        TestUtils.assertDistinct(Arrays.asList(lists));
    }

    static void assertDistinct(List<LongList> lists) {
        TestUtils.assertDistinct(lists, "");
    }

    static void assertDistinct(List<LongList> lists, String errorMessage) {
        MutableLongSet seen = LongSets.mutable.empty();
        for (LongList list : lists) {
            list.forEach((LongProcedure & Serializable)item -> Assertions.assertTrue((boolean)seen.add(item), (String)String.format("%s was seen multiple times, %s", item, errorMessage)));
        }
    }

    static LongList concat(LongList ... lists) {
        return TestUtils.concat(Arrays.asList(lists));
    }

    static LongList concat(List<LongList> lists) {
        MutableLongList concat = LongLists.mutable.empty();
        lists.forEach(arg_0 -> ((MutableLongList)concat).addAll(arg_0));
        return concat;
    }

    static <T extends Cursor> List<WorkerContext<T>> createContexts(KernelTransaction tx, Function<CursorContext, T> cursorFactory, int numberOfWorkers) {
        ArrayList<WorkerContext<T>> workers = new ArrayList<WorkerContext<T>>(numberOfWorkers);
        for (int i = 0; i < numberOfWorkers; ++i) {
            Statement statement = tx.acquireStatement();
            ExecutionContext executionContext = tx.createExecutionContext();
            WorkerContext<Cursor> workerContext = new WorkerContext<Cursor>((Cursor)cursorFactory.apply(executionContext.cursorContext()), executionContext, tx, statement);
            workers.add(workerContext);
        }
        return workers;
    }

    static <T extends Cursor> Callable<LongList> singleBatchWorker(Scan<T> scan, WorkerContext<T> workerContext, ToLongFunction<T> producer, int sizeHint) {
        return () -> {
            try {
                LongArrayList result = new LongArrayList();
                Cursor cursor = (Cursor)workerContext.getCursor();
                ExecutionContext executionContext = workerContext.getContext();
                while (scan.reserveBatch(cursor, sizeHint, executionContext.cursorContext(), executionContext.securityContext().mode())) {
                    while (cursor.next()) {
                        result.add(producer.applyAsLong(cursor));
                    }
                }
                LongArrayList longArrayList = result;
                return longArrayList;
            }
            finally {
                workerContext.complete();
            }
        };
    }

    static <T extends Cursor> Callable<LongList> singleBatchWorker(PartitionedScan<T> scan, WorkerContext<T> workerContext, ToLongFunction<T> producer) {
        return () -> {
            try {
                LongArrayList batch = new LongArrayList();
                Cursor cursor = (Cursor)workerContext.getCursor();
                ExecutionContext executionContext = workerContext.getContext();
                scan.reservePartition(cursor, executionContext.cursorContext(), executionContext.securityContext().mode());
                while (cursor.next()) {
                    batch.add(producer.applyAsLong(cursor));
                }
                LongArrayList longArrayList = batch;
                return longArrayList;
            }
            finally {
                workerContext.complete();
            }
        };
    }

    static <T extends Cursor> Callable<LongList> singleBatchWorker(Scan<T> scan, T cursor, CursorContext cursorContext, AccessMode accessMode, ToLongFunction<T> producer, int sizeHint) {
        return () -> {
            LongArrayList longArrayList;
            try {
                LongArrayList result = new LongArrayList();
                while (scan.reserveBatch(cursor, sizeHint, cursorContext, accessMode)) {
                    while (cursor.next()) {
                        result.add(producer.applyAsLong(cursor));
                    }
                }
                longArrayList = result;
            }
            catch (Throwable throwable) {
                IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{cursor, cursorContext});
                throw throwable;
            }
            IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{cursor, cursorContext});
            return longArrayList;
        };
    }

    static <T extends Cursor> List<Callable<LongList>> createWorkers(int sizeHint, Scan<T> scan, int numberOfWorkers, List<WorkerContext<T>> workerContexts, ToLongFunction<T> toLongFunction) {
        ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(workerContexts.size());
        for (int i = 0; i < numberOfWorkers; ++i) {
            workers.add(TestUtils.singleBatchWorker(scan, workerContexts.get(i), toLongFunction, sizeHint));
        }
        return workers;
    }

    static <T extends Cursor> List<Callable<LongList>> createWorkers(PartitionedScan<T> scan, List<WorkerContext<T>> workerContexts, ToLongFunction<T> toLongFunction) {
        ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(workerContexts.size());
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            workers.add(TestUtils.singleBatchWorker(scan, workerContexts.get(i), toLongFunction));
        }
        return workers;
    }

    static <T extends Cursor> List<Callable<LongList>> createRandomWorkers(Scan<T> scan, int numberOfWorkers, List<WorkerContext<T>> workerContexts, ToLongFunction<T> toLongFunction) {
        ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(workerContexts.size());
        for (int i = 0; i < numberOfWorkers; ++i) {
            workers.add(TestUtils.randomBatchWorker(scan, workerContexts.get(i), toLongFunction));
        }
        return workers;
    }

    static <T extends Cursor> Callable<LongList> randomBatchWorker(Scan<T> scan, WorkerContext<T> workerContext, ToLongFunction<T> producer) {
        return () -> {
            try {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                Cursor cursor = (Cursor)workerContext.getCursor();
                int sizeHint = random.nextInt(1, 5);
                LongArrayList batch = new LongArrayList();
                ExecutionContext executionContext = workerContext.getContext();
                while (scan.reserveBatch(cursor, sizeHint, executionContext.cursorContext(), executionContext.securityContext().mode())) {
                    while (cursor.next()) {
                        batch.add(producer.applyAsLong(cursor));
                    }
                }
                LongArrayList longArrayList = batch;
                return longArrayList;
            }
            finally {
                workerContext.complete();
            }
        };
    }

    static <T extends Cursor> Callable<LongList> randomBatchWorker(Scan<T> scan, T cursor, CursorContext cursorContext, AccessMode accessMode, ToLongFunction<T> producer) {
        return () -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int sizeHint = random.nextInt(1, 5);
            LongArrayList batch = new LongArrayList();
            while (scan.reserveBatch(cursor, sizeHint, cursorContext, accessMode)) {
                while (cursor.next()) {
                    batch.add(producer.applyAsLong(cursor));
                }
            }
            return batch;
        };
    }

    static <T extends AutoCloseable> void closeWorkContexts(List<WorkerContext<T>> workers) {
        for (WorkerContext<T> worker : workers) {
            worker.close();
        }
    }

    static int count(Cursor cursor) {
        int count = 0;
        while (cursor.next()) {
            ++count;
        }
        return count;
    }

    static boolean isNodeBased() {
        boolean bl;
        block8: {
            KernelTransaction tx = KernelAPIWriteTestBase.beginTransaction();
            try {
                bl = TestUtils.isNodeBased(tx);
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KernelException ex) {
                    Assertions.fail((String)"Unable to determine whether the transaction would create a cursor over the relationship type index that is node-based");
                    return false;
                }
            }
            tx.close();
        }
        return bl;
    }

    public static boolean isNodeBased(Transaction tx) {
        return TestUtils.isNodeBased(((InternalTransaction)tx).kernelTransaction());
    }

    public static boolean isNodeBased(KernelTransaction tx) {
        RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
        return cursor instanceof DefaultNodeBasedRelationshipTypeIndexCursor;
    }
}

