/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;

abstract class TokenIndexOrderTestBase<TOKEN_INDEX_CURSOR extends Cursor>
extends KernelAPIWriteTestBase<WriteTestSupport> {
    TokenIndexOrderTestBase() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldTokenScanInOrder(IndexOrder indexOrder) throws Exception {
        ArrayList<Long> expected = new ArrayList<Long>();
        try (KernelTransaction tx = TokenIndexOrderTestBase.beginTransaction();){
            expected.add(this.entityWithToken(tx, "INSIDE"));
            this.entityWithToken(tx, "OUTSIDE1");
            expected.add(this.entityWithToken(tx, "INSIDE"));
            expected.add(this.entityWithToken(tx, "INSIDE"));
            expected.add(this.entityWithToken(tx, "INSIDE"));
            this.entityWithToken(tx, "OUTSIDE2");
            expected.add(this.entityWithToken(tx, "INSIDE"));
            expected.add(this.entityWithToken(tx, "INSIDE"));
            expected.add(this.entityWithToken(tx, "INSIDE"));
            expected.add(this.entityWithToken(tx, "INSIDE"));
            this.entityWithToken(tx, "OUTSIDE1");
            expected.add(this.entityWithToken(tx, "INSIDE"));
            this.entityWithToken(tx, "OUTSIDE1");
            this.entityWithToken(tx, "OUTSIDE1");
            this.entityWithToken(tx, "OUTSIDE2");
            expected.add(this.entityWithToken(tx, "INSIDE"));
            this.entityWithToken(tx, "OUTSIDE2");
            tx.commit();
        }
        tx = TokenIndexOrderTestBase.beginTransaction();
        try {
            int label = this.tokenByName(tx, "INSIDE");
            try (TOKEN_INDEX_CURSOR cursor = this.getIndexCursor(tx);){
                this.entityWithToken(tx, "OUTSIDE1");
                this.entityWithToken(tx, "OUTSIDE1");
                expected.add(this.entityWithToken(tx, "INSIDE"));
                this.entityWithToken(tx, "OUTSIDE1");
                this.entityWithToken(tx, "OUTSIDE2");
                expected.add(this.entityWithToken(tx, "INSIDE"));
                expected.add(this.entityWithToken(tx, "INSIDE"));
                expected.add(this.entityWithToken(tx, "INSIDE"));
                this.entityWithToken(tx, "OUTSIDE2");
                expected.add(this.entityWithToken(tx, "INSIDE"));
                this.tokenScan(indexOrder, tx, label, cursor);
                if (TestUtils.isNodeBased(tx)) {
                    Assertions.assertThat(this.exhaust(cursor)).containsExactlyInAnyOrderElementsOf(expected);
                } else {
                    this.assertTokenResultsInOrder(expected, cursor, indexOrder);
                }
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    protected void assertTokenResultsInOrder(List<Long> expected, TOKEN_INDEX_CURSOR cursor, IndexOrder indexOrder) {
        expected.sort(indexOrder == IndexOrder.ASCENDING ? Comparator.naturalOrder() : Comparator.reverseOrder());
        Assertions.assertThat(this.exhaust(cursor)).isEqualTo(expected);
    }

    protected List<Long> exhaust(TOKEN_INDEX_CURSOR cursor) {
        ArrayList<Long> actual = new ArrayList<Long>();
        while (cursor.next()) {
            actual.add(this.entityReference(cursor));
        }
        return actual;
    }

    protected abstract long entityWithToken(KernelTransaction var1, String var2) throws Exception;

    protected abstract int tokenByName(KernelTransaction var1, String var2);

    protected abstract void tokenScan(IndexOrder var1, KernelTransaction var2, int var3, TOKEN_INDEX_CURSOR var4) throws KernelException;

    protected abstract long entityReference(TOKEN_INDEX_CURSOR var1);

    protected abstract TOKEN_INDEX_CURSOR getIndexCursor(KernelTransaction var1);
}

