/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.assertj.core.api.AbstractIterableSizeAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ProxyableIterableAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.test.Tags;

public abstract class TokenIndexScanPartitionedScanTestSuite<CURSER extends Cursor>
implements PartitionedScanTestSuite.TestSuite<TokenScanQuery, TokenReadSession, CURSER> {

    protected record TokenScanQuery(String indexName, TokenPredicate predicate) implements PartitionedScanTestSuite.Query<TokenPredicate>
    {
        @Override
        public TokenPredicate get() {
            return this.predicate;
        }

        @Override
        public String toString() {
            return String.format("%s[index='%s', pred='%s']", this.getClass().getSimpleName(), this.indexName, this.predicate.tokenId());
        }
    }

    static abstract class WithData<CURSER extends Cursor>
    extends PartitionedScanTestSuite.WithData<TokenScanQuery, TokenReadSession, CURSER> {
        WithData(TokenIndexScanPartitionedScanTestSuite<CURSER> testSuite) {
            super(testSuite);
        }

        abstract PartitionedScanTestSuite.Queries<TokenScanQuery> createData(long var1, SortedMap<Integer, List<PartitionedScanTestSuite.Range>> var3);

        protected List<List<PartitionedScanTestSuite.Range>> createTokenRanges(long numberOfEntities) {
            PartitionedScanTestSuite.Range range = new PartitionedScanTestSuite.Range(0L, numberOfEntities);
            long leadingTokenRangeSize = range.randomBetweenQuantiles(this.random.random(), 40L, 60L, 100L) - range.min();
            long leadingTokenCenter = range.randomBetweenQuantiles(this.random.random(), 40L, 60L, 100L);
            PartitionedScanTestSuite.Range leadingTokenRange = new PartitionedScanTestSuite.Range(leadingTokenCenter - leadingTokenRangeSize / 2L, leadingTokenCenter + leadingTokenRangeSize / 2L);
            ObjectAssert leadingTokenRangeAssert = (ObjectAssert)Assertions.assertThat((Object)leadingTokenRange).as("leading range is within total range", new Object[0]);
            ((AbstractLongAssert)leadingTokenRangeAssert.extracting(PartitionedScanTestSuite.Range::min, InstanceOfAssertFactories.LONG)).isGreaterThanOrEqualTo(range.min());
            ((AbstractLongAssert)leadingTokenRangeAssert.extracting(PartitionedScanTestSuite.Range::max, InstanceOfAssertFactories.LONG)).isLessThanOrEqualTo(range.max());
            long gapSize = leadingTokenRange.randomBetweenQuantiles(this.random.random(), 25L, 35L, 100L) - leadingTokenRange.min();
            long gapCenter = leadingTokenRange.randomBetweenQuantiles(this.random.random(), 40L, 60L, 100L);
            PartitionedScanTestSuite.Range gap = new PartitionedScanTestSuite.Range(gapCenter - gapSize / 2L, gapCenter + gapSize / 2L);
            ObjectAssert gapAssert = (ObjectAssert)Assertions.assertThat((Object)gap).as("gap range is within leading range", new Object[0]);
            ((AbstractLongAssert)gapAssert.extracting(PartitionedScanTestSuite.Range::min, InstanceOfAssertFactories.LONG)).isGreaterThanOrEqualTo(leadingTokenRange.min());
            ((AbstractLongAssert)gapAssert.extracting(PartitionedScanTestSuite.Range::max, InstanceOfAssertFactories.LONG)).isLessThanOrEqualTo(leadingTokenRange.max());
            PartitionedScanTestSuite.Range former = new PartitionedScanTestSuite.Range(leadingTokenRange.min(), gap.min());
            PartitionedScanTestSuite.Range latter = new PartitionedScanTestSuite.Range(gap.max(), leadingTokenRange.max());
            PartitionedScanTestSuite.Range before = new PartitionedScanTestSuite.Range(range.min(), former.min());
            PartitionedScanTestSuite.Range after = new PartitionedScanTestSuite.Range(latter.max(), range.max());
            return List.of(List.of(former, latter), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), before, before)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), before, former)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), former, former)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), gap, gap)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), former, latter)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), latter, after)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), after, after)), List.of(WithData.saneSpanningRangeFromRanges(this.random.random(), before, before), WithData.saneSpanningRangeFromRanges(this.random.random(), after, after)));
        }

        protected final <TAG> SortedMap<Integer, List<PartitionedScanTestSuite.Range>> tokenRangesFromTokenId(Tags.Suppliers.Supplier<TAG> token, List<List<PartitionedScanTestSuite.Range>> ranges) {
            List<Integer> tokenIds = this.createTags(ranges.size(), token);
            TreeMap<Integer, List<PartitionedScanTestSuite.Range>> tokenRanges = new TreeMap<Integer, List<PartitionedScanTestSuite.Range>>();
            for (int i = 0; i < ranges.size(); ++i) {
                tokenRanges.put(tokenIds.get(i), ranges.get(i));
            }
            return tokenRanges;
        }

        @ParameterizedTest(name="desiredNumberOfPartitions={0}")
        @MethodSource(value={"rangeFromOneToMaxPartitions"})
        final void shouldFollowTheLeadingScanSingles(int desiredNumberOfPartitions) throws KernelException {
            try (KernelTransaction tx = this.beginTx();
                 Object entities = this.factory.getCursor(tx.cursors()).with(tx.cursorContext());){
                Iterator validQueryEntries = this.queries.valid().iterator();
                Map.Entry leadingQueryEntry = validQueryEntries.next();
                ((IteratorAssert)Assumptions.assumeThat(validQueryEntries).as("there are queries to follow the partitioning of the leader", new Object[0])).hasNext();
                TokenScanQuery leadingQuery = (TokenScanQuery)leadingQueryEntry.getKey();
                Set<Long> leadingExpectedMatches = leadingQueryEntry.getValue();
                PartitionedScan leadingScan = this.factory.partitionedScan(tx, desiredNumberOfPartitions, leadingQuery);
                List<PartitionedScanTestSuite.Range> estimatedLeadingRanges = this.assertLeadingScan(tx, entities, desiredNumberOfPartitions, leadingScan, leadingQuery, leadingExpectedMatches);
                PartitionedScanFactories.TokenIndex tokenIndexFactory = (PartitionedScanFactories.TokenIndex)this.factory;
                while (validQueryEntries.hasNext()) {
                    Map.Entry followingQueryEntry = validQueryEntries.next();
                    TokenScanQuery followingQuery = (TokenScanQuery)followingQueryEntry.getKey();
                    Set<Long> followingExpectedMatched = followingQueryEntry.getValue();
                    PartitionedScan followingScan = tokenIndexFactory.partitionedScan(tx, leadingScan, followingQuery);
                    this.assertFollowingScan(tx, entities, leadingScan.getNumberOfPartitions(), estimatedLeadingRanges, followingScan, followingQuery, followingExpectedMatched);
                }
            }
        }

        @ParameterizedTest(name="desiredNumberOfPartitions={0}")
        @MethodSource(value={"rangeFromOneToMaxPartitions"})
        final void shouldFollowTheLeadingScanList(int desiredNumberOfPartitions) throws KernelException {
            try (KernelTransaction tx = this.beginTx();
                 Object entities = this.factory.getCursor(tx.cursors()).with(tx.cursorContext());){
                ArrayList<TokenScanQuery> validQueries = new ArrayList<TokenScanQuery>();
                ArrayList<Set<Long>> expectedMatches = new ArrayList<Set<Long>>();
                for (Map.Entry entry : this.queries.valid()) {
                    validQueries.add((TokenScanQuery)entry.getKey());
                    expectedMatches.add(entry.getValue());
                }
                ((AbstractIterableSizeAssert)Assumptions.assumeThat(validQueries).size().as("there are queries to follow the partitioning of the leader", new Object[0])).isGreaterThan(1);
                PartitionedScanFactories.TokenIndex tokenIndexFactory = (PartitionedScanFactories.TokenIndex)this.factory;
                List partitionScans = tokenIndexFactory.partitionedScans(tx, desiredNumberOfPartitions, validQueries);
                ((AbstractIterableSizeAssert)this.softly.assertThat(partitionScans).size().as("returned number of %s is the same as the number of given queries", new Object[]{PartitionedScan.class.getSimpleName()})).isEqualTo(validQueries.size());
                List<PartitionedScanTestSuite.Range> estimatedLeadingRanges = this.assertLeadingScan(tx, entities, desiredNumberOfPartitions, partitionScans.get(0), validQueries.get(0), (Set)expectedMatches.get(0));
                int numberOfPartitions = partitionScans.get(0).getNumberOfPartitions();
                for (int i = 1; i < partitionScans.size(); ++i) {
                    this.assertFollowingScan(tx, entities, numberOfPartitions, estimatedLeadingRanges, partitionScans.get(i), validQueries.get(i), (Set)expectedMatches.get(i));
                }
            }
        }

        private List<PartitionedScanTestSuite.Range> assertLeadingScan(KernelTransaction tx, CURSER entities, int desiredNumberOfPartitions, PartitionedScan<CURSER> leadingScan, TokenScanQuery leadingQuery, Set<Long> leadingExpectedMatches) {
            int numberOfPartitions = leadingScan.getNumberOfPartitions();
            ((IntegerAssert)((IntegerAssert)((IntegerAssert)this.softly.assertThat(numberOfPartitions).as("number of partitions", new Object[0])).isGreaterThan(0)).isLessThanOrEqualTo(desiredNumberOfPartitions)).isLessThanOrEqualTo(this.maxNumberOfPartitions);
            HashSet<Long> foundInLeading = new HashSet<Long>();
            ArrayList<PartitionedScanTestSuite.Range> estimatedLeadingRanges = new ArrayList<PartitionedScanTestSuite.Range>(numberOfPartitions);
            for (int i = 0; i < numberOfPartitions; ++i) {
                estimatedLeadingRanges.add(this.findAllAndGetRange(tx, entities, leadingScan, foundInLeading));
            }
            if (!leadingExpectedMatches.equals(foundInLeading)) {
                ((ProxyableIterableAssert)this.softly.assertThat(foundInLeading).as("only the expected data found matching %s", new Object[]{leadingQuery})).containsExactlyInAnyOrderElementsOf(leadingExpectedMatches);
            }
            return estimatedLeadingRanges;
        }

        private void assertFollowingScan(KernelTransaction tx, CURSER entities, int numberOfPartitions, List<PartitionedScanTestSuite.Range> estimatedLeadingRanges, PartitionedScan<CURSER> followingScan, TokenScanQuery followingQuery, Set<Long> followingExpectedMatched) {
            int i;
            ((IntegerAssert)this.softly.assertThat(followingScan.getNumberOfPartitions()).as("number of partitions", new Object[0])).isEqualTo(numberOfPartitions);
            HashSet<Long> foundInFollowing = new HashSet<Long>();
            ArrayList<PartitionedScanTestSuite.Range> estimatedRanges = new ArrayList<PartitionedScanTestSuite.Range>(numberOfPartitions);
            for (i = 0; i < numberOfPartitions; ++i) {
                PartitionedScanTestSuite.Range estimatedFollowingRange = this.findAllAndGetRange(tx, entities, followingScan, foundInFollowing);
                PartitionedScanTestSuite.Range estimatedLeadingRange = estimatedLeadingRanges.get(i);
                PartitionedScanTestSuite.Range estimatedRange = PartitionedScanTestSuite.Range.union(estimatedLeadingRange, estimatedFollowingRange);
                if (estimatedRange == null) continue;
                estimatedRanges.add(estimatedRange);
            }
            if (!followingExpectedMatched.equals(foundInFollowing)) {
                ((ProxyableIterableAssert)this.softly.assertThat(foundInFollowing).as("only the expected data found matching %s", new Object[]{followingQuery})).containsExactlyInAnyOrderElementsOf(followingExpectedMatched);
            }
            if (!this.storageEngine.indexingBehaviour().useNodeIdsInRelationshipTypeScanIndex()) {
                for (i = 1; i < estimatedRanges.size(); ++i) {
                    PartitionedScanTestSuite.Range prev = (PartitionedScanTestSuite.Range)estimatedRanges.get(i - 1);
                    PartitionedScanTestSuite.Range curr = (PartitionedScanTestSuite.Range)estimatedRanges.get(i);
                    ((BooleanAssert)this.softly.assertThat(PartitionedScanTestSuite.Range.strictlyLessThan(prev, curr)).as("%s is strictly less than %s", new Object[]{prev, curr})).isTrue();
                }
            }
        }

        protected final PartitionedScanTestSuite.Range findAllAndGetRange(KernelTransaction tx, CURSER entities, PartitionedScan<CURSER> scan, Set<Long> found) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            scan.reservePartition(entities, tx.cursorContext(), tx.securityContext().mode());
            while (entities.next()) {
                long entity = this.factory.getEntityReference(entities);
                min = Math.min(min, entity);
                max = Math.max(max, entity);
                ((BooleanAssert)this.softly.assertThat(found.add(entity)).as("no duplicate", new Object[0])).isTrue();
            }
            return min != Long.MAX_VALUE && max != Long.MIN_VALUE ? new PartitionedScanTestSuite.Range(min, max) : null;
        }

        protected static PartitionedScanTestSuite.Range saneSpanningRangeFromRanges(Random random, PartitionedScanTestSuite.Range start, PartitionedScanTestSuite.Range end) {
            return PartitionedScanTestSuite.Range.createSane(start.random(random), end.random(random));
        }
    }

    static abstract class WithoutData<CURSER extends Cursor>
    extends PartitionedScanTestSuite.WithoutData<TokenScanQuery, TokenReadSession, CURSER> {
        WithoutData(TokenIndexScanPartitionedScanTestSuite<CURSER> testSuite) {
            super(testSuite);
        }

        PartitionedScanTestSuite.Queries<TokenScanQuery> emptyQueries(EntityType entityType, List<Integer> tokenIds) {
            String tokenIndexName = this.getTokenIndexName(entityType);
            PartitionedScanTestSuite.EntityIdsMatchingQuery empty = tokenIds.stream().map(TokenPredicate::new).map(pred -> new TokenScanQuery(tokenIndexName, (TokenPredicate)pred)).collect(PartitionedScanTestSuite.EntityIdsMatchingQuery.collector());
            return new PartitionedScanTestSuite.Queries<TokenScanQuery>(empty);
        }
    }
}

