/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ExecutionContextProcedureTransactionIT {
    @Inject
    private GraphDatabaseAPI db;

    ExecutionContextProcedureTransactionIT() {
    }

    @Test
    void testGettingAllNodes() {
        ArrayList<String> nodeIds = new ArrayList<String>();
        try (Transaction tx = this.db.beginTx();){
            nodeIds.add(tx.createNode().getElementId());
            nodeIds.add(tx.createNode().getElementId());
            nodeIds.add(tx.createNode().getElementId());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            List retrievedIds = ExecutionContextProcedureTransactionIT.executionContextTransaction(tx).getAllNodes().stream().map(Entity::getElementId).collect(Collectors.toList());
            Assertions.assertThat(retrievedIds).containsExactlyInAnyOrderElementsOf(nodeIds);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Transaction executionContextTransaction(Transaction tx) {
        InternalTransaction internalTx = (InternalTransaction)tx;
        KernelTransaction ktx = internalTx.kernelTransaction();
        internalTx.registerCloseableResource((AutoCloseable)ktx.acquireStatement());
        ExecutionContext executionContext = ktx.createExecutionContext();
        internalTx.registerCloseableResource(() -> {
            executionContext.complete();
            executionContext.close();
        });
        return new ExecutionContextProcedureTransaction(executionContext);
    }
}

