/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class CheckpointKernelVersionIT {
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private MetadataProvider metadataProvider;
    @Inject
    private LogFiles logFiles;

    @Test
    void checkPointRecordContainsDatabaseKernelVersion() throws IOException {
        this.metadataProvider.setKernelVersion(KernelVersion.V5_0);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Forced 5.0"));
        List checkpointInfos = this.logFiles.getCheckpointFile().reachableCheckpoints();
        Assertions.assertThat((List)checkpointInfos).hasSize(1);
        Assertions.assertThat((Comparable)((CheckpointInfo)checkpointInfos.get(0)).version()).isEqualTo((Object)KernelVersion.V5_0);
    }
}

