/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointLogFileRotationIT;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;

@EnabledOnOs(value={OS.LINUX})
class PreallocatedCheckpointLogFileRotationIT
extends CheckpointLogFileRotationIT {
    PreallocatedCheckpointLogFileRotationIT() {
    }

    @Override
    protected boolean preallocateLogs() {
        return true;
    }

    @Override
    protected long expectedNewFileSize() {
        return ROTATION_THRESHOLD;
    }

    @Test
    void writeCheckpointsIntoPreallocatedFile() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L);
        String reason = "checkpoints in preallocated file";
        for (int i = 0; i < 3; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, logPosition, Instant.now(), reason);
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(1);
    }

    @Test
    void writeCheckpointsIntoSeveralPreallocatedFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L);
        String reason = "checkpoint in preallocated file";
        for (int fileCount = 1; fileCount < 6; ++fileCount) {
            int i = 128;
            while ((long)i < ROTATION_THRESHOLD) {
                ((ObjectArrayAssert)Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(fileCount)).allMatch(this::sizeEqualsToPreallocatedFile);
                checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, logPosition, Instant.now(), reason);
                i += 232;
            }
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(6)).allMatch(this::sizeEqualsToPreallocatedFile);
    }

    private boolean sizeEqualsToPreallocatedFile(Path path) {
        try {
            return Files.size(path) < ROTATION_THRESHOLD + 232L;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

