/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.parallel.Isolated;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.nativeimpl.LinuxNativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@Isolated
class TransactionLogChannelAllocatorIT {
    private static final long ROTATION_THRESHOLD = ByteUnit.mebiBytes((long)25L);
    private static final StoreId STORE_ID = new StoreId(1L, 1L, "engine-1", "format-1", 1, 1);
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    private TransactionLogFilesHelper fileHelper;
    private TransactionLogChannelAllocator fileAllocator;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final Config config = Config.defaults();

    TransactionLogChannelAllocatorIT() {
    }

    @BeforeEach
    void setUp() {
        this.fileHelper = new TransactionLogFilesHelper(this.fileSystem, this.testDirectory.homePath());
        this.fileAllocator = this.createLogFileAllocator();
    }

    @Test
    void rawChannelDoesNotTryToAdviseOnFileContent() throws IOException {
        Path path = this.fileHelper.getLogFileForVersion(1L);
        try (StoreChannel storeChannel = this.fileSystem.write(path);){
            LogHeaderWriter.writeLogHeader((StoreChannel)storeChannel, (LogHeader)new LogHeader(8, 1L, 1L, STORE_ID, 1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        LogHeaderCache logHeaderCache = new LogHeaderCache(10);
        TransactionLogFilesContext logFileContext = this.createLogFileContext();
        AdviseCountingChannelNativeAccessor nativeChannelAccessor = new AdviseCountingChannelNativeAccessor();
        TransactionLogChannelAllocator channelAllocator = new TransactionLogChannelAllocator(logFileContext, this.fileHelper, logHeaderCache, (ChannelNativeAccessor)nativeChannelAccessor);
        try (PhysicalLogVersionedStoreChannel channel = channelAllocator.openLogChannel(1L, true);){
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)nativeChannelAccessor.getCallCounter());
        }
    }

    @Test
    void defaultChannelTryToAdviseOnFileContent() throws IOException {
        Path path = this.fileHelper.getLogFileForVersion(1L);
        try (StoreChannel storeChannel = this.fileSystem.write(path);){
            LogHeaderWriter.writeLogHeader((StoreChannel)storeChannel, (LogHeader)new LogHeader(8, 1L, 1L, STORE_ID, 1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        LogHeaderCache logHeaderCache = new LogHeaderCache(10);
        TransactionLogFilesContext logFileContext = this.createLogFileContext();
        AdviseCountingChannelNativeAccessor nativeChannelAccessor = new AdviseCountingChannelNativeAccessor();
        TransactionLogChannelAllocator channelAllocator = new TransactionLogChannelAllocator(logFileContext, this.fileHelper, logHeaderCache, (ChannelNativeAccessor)nativeChannelAccessor);
        try (PhysicalLogVersionedStoreChannel channel = channelAllocator.openLogChannel(1L);){
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)nativeChannelAccessor.getCallCounter());
        }
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void allocateNewTransactionLogFile() throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = this.fileAllocator.createLogChannel(10L, () -> 1L);
        org.junit.jupiter.api.Assertions.assertEquals((long)ROTATION_THRESHOLD, (long)logChannel.size());
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void failToPreallocateFileWithOutOfDiskSpaceError() throws IOException {
        TransactionLogFilesContext logFileContext = this.createLogFileContext(this.getUnavailableBytes(), (NativeAccess)new PreallocationFailingChannelNativeAccess());
        LogFileChannelNativeAccessor nativeChannelAccessor = new LogFileChannelNativeAccessor(this.fileSystem, logFileContext);
        TransactionLogChannelAllocator unreasonableAllocator = new TransactionLogChannelAllocator(logFileContext, this.fileHelper, new LogHeaderCache(10), (ChannelNativeAccessor)nativeChannelAccessor);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> unreasonableAllocator.createLogChannel(10L, () -> 1L));
        Assertions.assertThat((String)this.logProvider.serialize()).containsSequence(new CharSequence[]{"Warning! System is running out of disk space. Failed to preallocate log file since disk does not have enough space left. Please provision more space to avoid that."});
        Assertions.assertThat((Iterable)((Iterable)this.config.get(GraphDatabaseSettings.read_only_databases))).contains((Object[])new String[]{"neo4j"});
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void failToPreallocateFileWithOutOfDiskSpaceErrorAndDisabledFailover() throws IOException {
        this.config.setDynamic(GraphDatabaseInternalSettings.dynamic_read_only_failover, (Object)false, "test");
        TransactionLogFilesContext logFileContext = this.createLogFileContext(this.getUnavailableBytes(), (NativeAccess)new PreallocationFailingChannelNativeAccess());
        LogFileChannelNativeAccessor nativeChannelAccessor = new LogFileChannelNativeAccessor(this.fileSystem, logFileContext);
        TransactionLogChannelAllocator unreasonableAllocator = new TransactionLogChannelAllocator(logFileContext, this.fileHelper, new LogHeaderCache(10), (ChannelNativeAccessor)nativeChannelAccessor);
        try (PhysicalLogVersionedStoreChannel channel = unreasonableAllocator.createLogChannel(10L, () -> 1L);){
            org.junit.jupiter.api.Assertions.assertEquals((long)128L, (long)channel.size());
            ((AbstractStringAssert)Assertions.assertThat((String)this.logProvider.serialize()).containsSequence(new CharSequence[]{"Warning! System is running out of disk space. Failed to preallocate log file since disk does not have enough space left. Please provision more space to avoid that."})).containsSequence(new CharSequence[]{"Dynamic switchover to read-only mode is disabled. The database will continue execution in the current mode."});
        }
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void allocateNewTransactionLogFileOnSystemThatDoesNotSupportPreallocations() throws IOException {
        try (PhysicalLogVersionedStoreChannel logChannel = this.fileAllocator.createLogChannel(10L, () -> 1L);){
            org.junit.jupiter.api.Assertions.assertEquals((long)128L, (long)logChannel.size());
        }
    }

    @Test
    void openExistingFileDoesNotPerformAnyAllocations() throws IOException {
        Path file = this.fileHelper.getLogFileForVersion(11L);
        this.fileSystem.write(file).close();
        TransactionLogChannelAllocator fileAllocator = this.createLogFileAllocator();
        try (PhysicalLogVersionedStoreChannel channel = fileAllocator.createLogChannel(11L, () -> 1L);){
            org.junit.jupiter.api.Assertions.assertEquals((long)128L, (long)channel.size());
        }
    }

    private long getUnavailableBytes() throws IOException {
        return Files.getFileStore(this.testDirectory.homePath()).getUsableSpace() + ByteUnit.gibiBytes((long)10L);
    }

    private TransactionLogChannelAllocator createLogFileAllocator() {
        return this.createLogFileAllocator(ROTATION_THRESHOLD);
    }

    private TransactionLogFilesContext createLogFileContext() {
        return this.createLogFileContext(ROTATION_THRESHOLD);
    }

    private TransactionLogChannelAllocator createLogFileAllocator(long rotationsThreshold) {
        LogHeaderCache logHeaderCache = new LogHeaderCache(10);
        TransactionLogFilesContext logFileContext = this.createLogFileContext(rotationsThreshold);
        LogFileChannelNativeAccessor nativeChannelAccessor = new LogFileChannelNativeAccessor(this.fileSystem, logFileContext);
        return new TransactionLogChannelAllocator(logFileContext, this.fileHelper, logHeaderCache, (ChannelNativeAccessor)nativeChannelAccessor);
    }

    private TransactionLogFilesContext createLogFileContext(long rotationThreshold) {
        return this.createLogFileContext(rotationThreshold, NativeAccessProvider.getNativeAccess());
    }

    private TransactionLogFilesContext createLogFileContext(long rotationThreshold, NativeAccess nativeAccess) {
        return new TransactionLogFilesContext(new AtomicLong(rotationThreshold), new AtomicBoolean(true), (CommandReaderFactory)new TestCommandReaderFactory(), any -> 1L, () -> 1L, any -> new LogPosition(0L, 1L), any -> new SimpleLogVersionRepository(), this.fileSystem, (InternalLogProvider)this.logProvider, DatabaseTracers.EMPTY, () -> STORE_ID, nativeAccess, (MemoryTracker)EmptyMemoryTracker.INSTANCE, new Monitors(), true, new DatabaseHealth(PanicEventGenerator.NO_OP, (InternalLog)NullLog.getInstance()), () -> KernelVersion.LATEST, Clock.systemUTC(), "neo4j", this.config, null, null);
    }

    private static class AdviseCountingChannelNativeAccessor
    extends ChannelNativeAccessor.EmptyChannelNativeAccessor {
        private long callCounter;

        private AdviseCountingChannelNativeAccessor() {
        }

        public void adviseSequentialAccessAndKeepInCache(StoreChannel storeChannel, long version) {
            ++this.callCounter;
        }

        public long getCallCounter() {
            return this.callCounter;
        }
    }

    private static class PreallocationFailingChannelNativeAccess
    extends LinuxNativeAccess {
        private PreallocationFailingChannelNativeAccess() {
        }

        public NativeCallResult tryPreallocateSpace(int fd, long bytes) {
            return new NativeCallResult(28, "Sometimes science is more art than science");
        }
    }
}

