/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
class KernelRecoveryTest {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    KernelRecoveryTest() {
    }

    @AfterEach
    void cleanUp() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void shouldHandleWritesProperlyAfterRecovery() throws Exception {
        long node2;
        GraphDatabaseService db = this.newDB((FileSystemAbstraction)this.fileSystem, "main");
        long txIdToExtractFrom = KernelRecoveryTest.getLastClosedTransactionId((GraphDatabaseAPI)db) + 1L;
        long node1 = KernelRecoveryTest.createNode(db, "k", "v1");
        ArrayList<CommittedTransactionRepresentation> transactions = new ArrayList<CommittedTransactionRepresentation>();
        try (EphemeralFileSystemAbstraction crashedFs = this.fileSystem.snapshot();){
            this.managementService.shutdown();
            db = this.newDB((FileSystemAbstraction)crashedFs, "main");
            node2 = KernelRecoveryTest.createNode(db, "k", "v2");
            KernelRecoveryTest.extractTransactions((GraphDatabaseAPI)db, transactions, txIdToExtractFrom);
            this.managementService.shutdown();
        }
        GraphDatabaseService rebuilt = this.newDB((FileSystemAbstraction)this.fileSystem, "rebuilt");
        KernelRecoveryTest.applyTransactions(transactions, (GraphDatabaseAPI)rebuilt);
        try (Transaction tx = rebuilt.beginTx();){
            Assertions.assertEquals((Object)"v1", (Object)tx.getNodeById(node1).getProperty("k"));
            Assertions.assertEquals((Object)"v2", (Object)tx.getNodeById(node2).getProperty("k"));
            tx.commit();
        }
    }

    private static void applyTransactions(List<CommittedTransactionRepresentation> transactions, GraphDatabaseAPI rebuilt) throws TransactionFailureException {
        DependencyResolver dependencyResolver = rebuilt.getDependencyResolver();
        StorageEngine storageEngine = (StorageEngine)dependencyResolver.resolveDependency(StorageEngine.class);
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)dependencyResolver.resolveDependency(TransactionCommitProcess.class);
        TransactionCommitmentFactory commitmentFactory = (TransactionCommitmentFactory)dependencyResolver.resolveDependency(TransactionCommitmentFactory.class);
        TransactionIdGenerator transactionIdGenerator = (TransactionIdGenerator)dependencyResolver.resolveDependency(TransactionIdGenerator.class);
        try (StoreCursors storeCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            for (CommittedTransactionRepresentation transaction : transactions) {
                commitProcess.commit((CommandBatchToApply)new TransactionToApply(transaction, CursorContext.NULL_CONTEXT, storeCursors, commitmentFactory.newCommitment(), transactionIdGenerator), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            }
        }
    }

    private static void extractTransactions(GraphDatabaseAPI db, List<CommittedTransactionRepresentation> transactions, long txIdToStartFrom) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        try (TransactionCursor cursor = txStore.getTransactions(txIdToStartFrom);){
            cursor.forAll(transactions::add);
        }
    }

    private static long getLastClosedTransactionId(GraphDatabaseAPI database) {
        MetadataProvider metaDataStore = (MetadataProvider)database.getDependencyResolver().resolveDependency(MetadataProvider.class);
        return metaDataStore.getLastClosedTransaction().transactionId();
    }

    private GraphDatabaseService newDB(FileSystemAbstraction fs, String name) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.directory(name)).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fs)).build();
        return this.managementService.database("neo4j");
    }

    private static long createNode(GraphDatabaseService db, String key, Object value) {
        long nodeId;
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(key, value);
            nodeId = node.getId();
            tx.commit();
        }
        return nodeId;
    }
}

