/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.admin.commands;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.mockito.Mockito;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ContextInjectingFactory;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.commandline.admin.security.SetInitialPasswordCommand;
import org.neo4j.commandline.dbms.DiagnosticsReportCommand;
import org.neo4j.commandline.dbms.DumpCommand;
import org.neo4j.commandline.dbms.LoadCommand;
import org.neo4j.commandline.dbms.MemoryRecommendationsCommand;
import org.neo4j.commandline.dbms.StoreInfoCommand;
import org.neo4j.commandline.dbms.UnbindCommand;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.consistency.CheckCommand;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.importer.ImportCommand;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import picocli.CommandLine;

@TestDirectoryExtension
@DisabledOnOs(value={OS.WINDOWS})
class AdminCommandsIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    private Path confDir;
    private PrintStream out;
    private PrintStream err;
    private ExecutionContext context;
    private Path home;
    private Path dumpFolder;

    AdminCommandsIT() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.out = (PrintStream)Mockito.mock(PrintStream.class);
        this.err = (PrintStream)Mockito.mock(PrintStream.class);
        this.confDir = this.testDirectory.directory("test.conf");
        this.home = this.testDirectory.homePath("home");
        this.dumpFolder = this.testDirectory.directory("dumpFolder");
        this.context = new ExecutionContext(this.home, this.confDir, this.out, this.err, this.testDirectory.getFileSystem());
        Path configFile = this.confDir.resolve("neo4j.conf");
        try (OutputStream outputStream = this.fs.openAsOutputStream(configFile, false);
             PrintStream out = new PrintStream(outputStream);){
            out.printf("%s=%s%n", BootloaderSettings.initial_heap_size.name(), "$(expr 500)");
        }
        Assertions.assertThat((Object)this.fs).isInstanceOf(DefaultFileSystemAbstraction.class);
        Files.setPosixFilePermissions(configFile, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    }

    @Test
    void shouldExpandCommands() {
        this.assertSuccess((AbstractCommand)new SetInitialPasswordCommand(this.context), "--expand-commands", "password");
        this.assertSuccess((AbstractCommand)new SetDefaultAdminCommand(this.context), "--expand-commands", "admin");
        this.assertSuccess((AbstractCommand)new StoreInfoCommand(this.context), "--expand-commands", "path");
        this.assertSuccess((AbstractCommand)new CheckCommand(this.context), "--expand-commands", "neo4j");
        this.assertSuccess((AbstractCommand)new DiagnosticsReportCommand(this.context), "--expand-commands");
        this.assertSuccess((AbstractCommand)new LoadCommand(this.context, new Loader(this.fs)), "--expand-commands", "--from-path=" + this.testDirectory.directory("dump").toAbsolutePath(), "test");
        this.assertSuccess((AbstractCommand)new MemoryRecommendationsCommand(this.context), "--expand-commands");
        this.assertSuccess((AbstractCommand)new DumpCommand(this.context, new Dumper(this.context.err())), "--expand-commands", "test", "--to-path", this.dumpFolder.toString());
        this.assertSuccess((AbstractCommand)new UnbindCommand(this.context), "--expand-commands");
    }

    @Test
    void shouldNotExpandCommands() {
        this.assertExpansionError((AbstractCommand)new SetInitialPasswordCommand(this.context), "password");
        this.assertExpansionError((AbstractCommand)new SetDefaultAdminCommand(this.context), "user");
        this.assertExpansionError((AbstractCommand)new StoreInfoCommand(this.context), "path");
        this.assertExpansionError((AbstractCommand)new CheckCommand(this.context), "neo4j");
        this.assertExpansionError((AbstractCommand)new DiagnosticsReportCommand(this.context), new String[0]);
        this.assertExpansionError((AbstractCommand)new LoadCommand(this.context, new Loader(this.fs)), "--from-path=" + this.testDirectory.directory("dump").toAbsolutePath(), "test");
        this.assertExpansionError((AbstractCommand)new MemoryRecommendationsCommand(this.context), new String[0]);
        this.assertExpansionError((AbstractCommand)new ImportCommand.Full(this.context), "--nodes=" + this.testDirectory.createFile("foo.csv").toAbsolutePath());
        this.assertExpansionError((AbstractCommand)new ImportCommand.Incremental(this.context), "--force", "--nodes=" + this.testDirectory.createFile("foo.csv").toAbsolutePath());
        this.assertExpansionError((AbstractCommand)new DumpCommand(this.context, new Dumper(this.context.err())), "test", "--to-path", this.dumpFolder.toString());
        this.assertExpansionError((AbstractCommand)new UnbindCommand(this.context), new String[0]);
    }

    private void assertSuccess(AbstractCommand command, String ... args) {
        new CommandLine((Object)command, (CommandLine.IFactory)new ContextInjectingFactory(this.context)).execute(args);
    }

    private void assertExpansionError(AbstractCommand command, String ... args) {
        MutableObject exception = new MutableObject();
        new CommandLine((Object)command, (CommandLine.IFactory)new ContextInjectingFactory(this.context)).setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            exception.setValue((Object)ex);
            return 1;
        }).execute(args);
        Assertions.assertThat((Throwable)((Exception)exception.getValue())).hasMessageContaining("is a command, but config is not explicitly told to expand it.");
    }
}

