/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.disk;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.internal.kernel.api.exceptions.TransactionApplyKernelException;
import org.neo4j.internal.nativeimpl.ErrorTranslator;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.time.SystemNanoClock;

@Neo4jLayoutExtension
class OutOfDiskByStoreGrowTest {
    private static final long FILE_LIMIT = ByteUnit.mebiBytes((long)33L);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private Neo4jLayout neo4jLayout;

    OutOfDiskByStoreGrowTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled
    @Test
    void outOfDiskDuringNodeStoreGrowCausesTheDatabaseToPanic() {
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilderWithCustomPageCacheNativeAccess(this.neo4jLayout.homeDirectory(), this.fs).build();
        try {
            GraphDatabaseService db = dbms.database("neo4j");
            try (Transaction tx = db.beginTx();){
                int i = 0;
                while ((long)i < FILE_LIMIT / 15L + 1L) {
                    tx.createNode();
                    ++i;
                }
                Assertions.assertThatThrownBy(() -> ((Transaction)tx).commit()).hasRootCauseInstanceOf(IOException.class).getRootCause().hasMessageContaining("System is out of disk space for store file ");
            }
            DatabaseHealth health = (DatabaseHealth)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(DatabaseHealth.class);
            Assertions.assertThat((boolean)health.hasNoPanic()).isFalse();
            Assertions.assertThat((Throwable)health.causeOfPanic()).isInstanceOf(TransactionApplyKernelException.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((GraphDatabaseService)db).beginTx()).isInstanceOf(TransactionFailureException.class)).hasRootCauseInstanceOf(IOException.class).getRootCause().hasMessageContaining("System is out of disk space for store file ");
        }
        finally {
            dbms.shutdown();
        }
    }

    private static class TestDatabaseManagementServiceBuilderWithCustomPageCacheNativeAccess
    extends TestDatabaseManagementServiceBuilder {
        private final FileSystemAbstraction fs;

        TestDatabaseManagementServiceBuilderWithCustomPageCacheNativeAccess(Path homeDirectory, FileSystemAbstraction fs) {
            super(homeDirectory);
            this.fs = fs;
        }

        protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
            return new DatabaseManagementServiceFactory(DbmsInfo.COMMUNITY, CommunityEditionModule::new){

                protected GlobalModule createGlobalModule(Config config, ExternalDependencies dependencies) {
                    GlobalModule globalModule = new GlobalModule(config, this.dbmsInfo, dependencies){

                        protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, JobScheduler jobScheduler, SystemNanoClock clock, MemoryPools memoryPools) {
                            long pageCacheMaxMemory = ByteUnit.mebiBytes((long)20L);
                            GlobalMemoryGroupTracker memoryPool = memoryPools.pool(MemoryGroup.PAGE_CACHE, pageCacheMaxMemory, false, null);
                            MemoryTracker memoryTracker = memoryPool.getPoolMemoryTracker();
                            SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(fs, tracers.getPageCacheTracer(), memoryTracker){

                                protected NativeAccess nativeAccess() {
                                    return new FileLimitingNativeAccess();
                                }
                            };
                            MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator((long)pageCacheMaxMemory, (MemoryTracker)memoryTracker);
                            ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(config, memoryTracker);
                            MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)memoryAllocator).memoryTracker(memoryTracker).bufferFactory((IOBufferFactory)bufferFactory).reservedPageBytes(24).preallocateStoreFiles(((Boolean)config.get(GraphDatabaseSettings.preallocate_store_files)).booleanValue()).clock(clock).pageCacheTracer(tracers.getPageCacheTracer());
                            return new MuninnPageCache((PageSwapperFactory)swapperFactory, jobScheduler, configuration);
                        }

                        protected FileSystemAbstraction createFileSystemAbstraction() {
                            return fs;
                        }
                    };
                    return globalModule;
                }
            }.build(config, dependencies);
        }
    }

    private static class FileLimitingNativeAccess
    implements NativeAccess {
        private final NativeCallResult OUT_OF_DISK = new NativeCallResult(123, "Out of disc");

        private FileLimitingNativeAccess() {
        }

        public boolean isAvailable() {
            return true;
        }

        public NativeCallResult tryEvictFromCache(int fd) {
            throw new UnsupportedOperationException();
        }

        public NativeCallResult tryAdviseSequentialAccess(int fd) {
            throw new UnsupportedOperationException();
        }

        public NativeCallResult tryAdviseToKeepInCache(int fd) {
            throw new UnsupportedOperationException();
        }

        public NativeCallResult tryPreallocateSpace(int fd, long bytes) {
            if (bytes > FILE_LIMIT) {
                return this.OUT_OF_DISK;
            }
            return NativeCallResult.SUCCESS;
        }

        public ErrorTranslator errorTranslator() {
            return callResult -> callResult == this.OUT_OF_DISK;
        }

        public String describe() {
            return "Test native access";
        }
    }
}

