/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@Neo4jLayoutExtension
class IndexRecoveryIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseLayout databaseLayout;
    private GraphDatabaseAPI db;
    private final IndexProvider mockedIndexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final ExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR.getKey(), (IndexProvider)this.mockedIndexProvider);
    private final String key = "number_of_bananas_owned";
    private final Label myLabel = Label.label((String)"MyLabel");
    private final Monitors monitors = new Monitors();
    private DatabaseManagementService managementService;
    private ExecutorService executor;
    private final Object lock = new Object();

    IndexRecoveryIT() {
    }

    @BeforeEach
    void setUp() {
        this.executor = Executors.newSingleThreadExecutor();
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant((FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.any(PageCache.class), (PageCacheTracer)ArgumentMatchers.any(), (StorageEngineFactory)ArgumentMatchers.any(), (CursorContextFactory)ArgumentMatchers.any())).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Mockito.when((Object)this.mockedIndexProvider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (StorageEngineIndexingBehaviour)ArgumentMatchers.any())).then(inv -> inv.getArgument(0));
    }

    @AfterEach
    void after() {
        this.executor.shutdown();
        if (this.db != null) {
            this.managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndexWhereLogHasRotated() throws Exception {
        Future<Void> killFuture;
        this.startDb();
        Semaphore populationSemaphore = new Semaphore(0);
        try {
            Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(populationSemaphore));
            this.createSomeData();
            this.createIndex();
            killFuture = this.killDbInSeparateThread();
            int iterations = 0;
            do {
                this.rotateLogsAndCheckPoint();
                Thread.sleep(10L);
            } while (iterations++ < 100 && !killFuture.isDone());
        }
        finally {
            populationSemaphore.release();
        }
        killFuture.get();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        Semaphore recoverySemaphore = new Semaphore(0);
        try {
            Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(recoverySemaphore));
            boolean recoveryRequired = Recovery.isRecoveryRequired((FileSystemAbstraction)this.testDirectory.getFileSystem(), (DatabaseLayout)this.databaseLayout, (Config)Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.monitors.addMonitorListener((Object)new MyRecoveryMonitor(recoverySemaphore), new String[0]);
            this.startDb();
            try (Transaction transaction = this.db.beginTx();){
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.POPULATING});
            }
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)(recoveryRequired ? 3 : 2)))).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.never())).getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
        }
        finally {
            recoverySemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndex() throws IOException, ExecutionException, InterruptedException, KernelException {
        Semaphore populationSemaphore = new Semaphore(1);
        try {
            this.startDb();
            Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(populationSemaphore));
            this.createSomeData();
            this.createIndex();
            Future<Void> killFuture = this.killDbInSeparateThread();
            populationSemaphore.release();
            killFuture.get();
        }
        finally {
            populationSemaphore.release();
        }
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.POPULATING);
        populationSemaphore = new Semaphore(1);
        try {
            Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)IndexRecoveryIT.indexPopulatorWithControlledCompletionTiming(populationSemaphore));
            this.startDb();
            try (Transaction transaction = this.db.beginTx();){
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
                Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.POPULATING});
            }
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)3))).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
            ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.never())).getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
        }
        finally {
            populationSemaphore.release();
        }
    }

    @Test
    void shouldBeAbleToRecoverAndUpdateOnlineIndex() throws Exception {
        this.startDb();
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)populator);
        Mockito.when((Object)populator.sample((CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)new IndexSample());
        IndexAccessor mockedAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)mockedAccessor.newUpdater((IndexUpdateMode)ArgumentMatchers.any(IndexUpdateMode.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)SwallowingIndexUpdater.INSTANCE);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)mockedAccessor);
        this.createIndexAndAwaitPopulation();
        this.rotateLogsAndCheckPoint();
        Set<IndexEntryUpdate<?>> expectedUpdates = this.createSomeBananas(this.myLabel);
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.ONLINE);
        GatheringIndexWriter writer = new GatheringIndexWriter();
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)writer);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.ONLINE});
        }
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
        int onlineAccessorInvocationCount = 3;
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)onlineAccessorInvocationCount))).getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals(expectedUpdates, writer.batchedUpdates);
    }

    @Test
    void shouldKeepFailedIndexesAsFailedAfterRestart() throws Exception {
        IndexPopulator indexPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)indexPopulator);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)indexAccessor);
        this.startDb();
        this.createIndex();
        this.rotateLogsAndCheckPoint();
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class), (ImmutableSet)ArgumentMatchers.any())).thenReturn((Object)InternalIndexState.FAILED);
        this.startDb();
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).hasSize(1);
            Assertions.assertThat((Iterable)transaction.schema().getIndexes(this.myLabel)).extracting(i -> transaction.schema().getIndexState(i)).containsOnly((Object[])new Schema.IndexState[]{Schema.IndexState.FAILED});
        }
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider)).getPopulator((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (IndexSamplingConfig)ArgumentMatchers.any(IndexSamplingConfig.class), (ByteBufferFactory)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any(TokenNameLookup.class), (ImmutableSet)ArgumentMatchers.any());
        ((IndexProvider)Mockito.verify((Object)this.mockedIndexProvider)).getMinimalIndexAccessor((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class));
    }

    private void startDb() {
        if (this.db != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem(this.testDirectory.getFileSystem()).addExtension(this.mockedIndexProviderFactory).noOpSystemGraphInitializer().setMonitors(this.monitors).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killDb() {
        if (this.db != null) {
            Path snapshotDir = this.testDirectory.directory("snapshot");
            Object object = this.lock;
            synchronized (object) {
                this.snapshotFs(snapshotDir);
            }
            this.managementService.shutdown();
            this.restoreSnapshot(snapshotDir);
        }
    }

    private void snapshotFs(Path snapshotDir) {
        try {
            DatabaseLayout layout = this.databaseLayout;
            FileUtils.copyDirectory((Path)layout.databaseDirectory(), (Path)snapshotDir.resolve("data"));
            FileUtils.copyDirectory((Path)layout.getTransactionLogsDirectory(), (Path)snapshotDir.resolve("transactions"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void restoreSnapshot(Path snapshotDir) {
        try {
            DatabaseLayout layout = this.databaseLayout;
            FileUtils.deleteDirectory((Path)layout.databaseDirectory());
            FileUtils.deleteDirectory((Path)layout.getTransactionLogsDirectory());
            FileUtils.copyDirectory((Path)snapshotDir.resolve("data"), (Path)layout.databaseDirectory());
            FileUtils.copyDirectory((Path)snapshotDir.resolve("transactions"), (Path)layout.getTransactionLogsDirectory());
            FileUtils.deleteDirectory((Path)snapshotDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Future<Void> killDbInSeparateThread() {
        return this.executor.submit(() -> {
            this.killDb();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateLogsAndCheckPoint() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            ((LogFiles)this.db.getDependencyResolver().resolveDependency(LogFiles.class)).getLogFile().getLogRotation().rotateLogFile((LogRotateEvents)LogAppendEvent.NULL);
            ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        }
    }

    private void createIndexAndAwaitPopulation() throws KernelException {
        IndexDescriptor index = this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index.getName(), 1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    private IndexDescriptor createIndex() throws KernelException {
        try (TransactionImpl tx = (TransactionImpl)this.db.beginTx();){
            IndexDescriptor index = IndexingTestUtil.createNodePropIndexWithSpecifiedProvider(tx, TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR, this.myLabel, "number_of_bananas_owned");
            tx.commit();
            IndexDescriptor indexDescriptor = index;
            return indexDescriptor;
        }
    }

    private Set<IndexEntryUpdate<?>> createSomeBananas(Label label) {
        HashSet updates = new HashSet();
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            int labelId = ktx.tokenRead().nodeLabel(label.name());
            int propertyKeyId = ktx.tokenRead().propertyKey("number_of_bananas_owned");
            LabelSchemaDescriptor schemaDescriptor = SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
            for (int number : new int[]{4, 10}) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("number_of_bananas_owned", (Object)number);
                updates.add((IndexEntryUpdate<?>)IndexEntryUpdate.add((long)node.getId(), () -> schemaDescriptor, (Value[])new Value[]{Values.of((Object)number)}));
            }
            tx.commit();
            HashSet hashSet = updates;
            return hashSet;
        }
    }

    private static IndexPopulator indexPopulatorWithControlledCompletionTiming(final Semaphore semaphore) {
        return new IndexPopulator.Adapter(){

            public void create() {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new RuntimeException("this is expected");
            }
        };
    }

    private void createSomeData() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    private static class MyRecoveryMonitor
    implements RecoveryMonitor {
        private final Semaphore recoverySemaphore;

        MyRecoveryMonitor(Semaphore recoverySemaphore) {
            this.recoverySemaphore = recoverySemaphore;
        }

        public void recoveryCompleted(long recoveryTimeInMilliseconds) {
            this.recoverySemaphore.release();
        }
    }

    public static class GatheringIndexWriter
    extends IndexAccessor.Adapter {
        private final Set<IndexEntryUpdate<?>> regularUpdates = new HashSet();
        private final Set<IndexEntryUpdate<?>> batchedUpdates = new HashSet();

        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
            return new CollectingIndexUpdater(updates -> {
                switch (mode) {
                    case ONLINE: {
                        this.regularUpdates.addAll(updates);
                        break;
                    }
                    case RECOVERY: {
                        this.batchedUpdates.addAll(updates);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            });
        }
    }
}

