/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.core.EntityTest;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.token.api.NamedToken;

public class RelationshipTest
extends EntityTest {
    @Override
    protected long createEntity(Transaction tx) {
        return tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"FOO")).getId();
    }

    @Override
    protected Entity lookupEntity(Transaction transaction, long id) {
        return transaction.getRelationshipById(id);
    }

    @Test
    void shouldBeAbleToReferToIdsBeyondMaxInt() {
        InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)transaction.newNodeEntity(ArgumentMatchers.anyLong())).then(invocation -> RelationshipTest.nodeWithId((Long)invocation.getArgument(0)));
        Mockito.when((Object)transaction.getRelationshipTypeById(ArgumentMatchers.anyInt())).then(invocation -> new NamedToken("whatever", ((Integer)invocation.getArgument(0)).intValue()));
        long[] ids = new long[]{1437589437L, 2047587483L, 2147496246L, 2147342921L, 3276473721L, 4762746373L, 57587348738L, 59892898932L};
        int[] types = new int[]{0, 10, 101, 3024, 20123, 45008};
        for (int i = 0; i < ids.length - 2; ++i) {
            long id = ids[i];
            long nodeId1 = ids[i + 1];
            long nodeId2 = ids[i + 2];
            int type = types[i];
            RelationshipTest.verifyIds(transaction, id, nodeId1, type, nodeId2);
            RelationshipTest.verifyIds(transaction, id, nodeId2, type, nodeId1);
        }
    }

    @Test
    void shouldPrintCypherEsqueRelationshipToString() {
        RelationshipType type = RelationshipType.withName((String)"NICE");
        try (Transaction tx = db.beginTx();){
            Node start = tx.createNode();
            Node end = tx.createNode();
            Relationship relationship = start.createRelationshipTo(end, type);
            tx.commit();
            String toString = relationship.toString();
            org.junit.jupiter.api.Assertions.assertEquals((Object)("(" + start.getId() + ")-[" + type + "," + relationship.getId() + "]->(" + end.getId() + ")"), (Object)toString);
        }
    }

    @Test
    void relationshipNotFoundByElementId() {
        String elementId;
        try (Transaction transaction = db.beginTx();){
            Node node = transaction.createNode();
            Relationship relationship = node.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"test"));
            elementId = relationship.getElementId();
            transaction.rollback();
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Transaction tx = db.beginTx();){
                tx.getRelationshipByElementId(elementId);
            }
        }).isInstanceOf(NotFoundException.class)).hasMessageContaining(elementId + " not found").hasRootCauseInstanceOf(EntityNotFoundException.class).getRootCause().hasMessageContaining("Unable to load RELATIONSHIP " + elementId);
    }

    @Test
    void createDropRelationshipLongStringProperty(TestInfo testInfo) {
        Relationship relationship;
        String relationshipId;
        Label markerLabel = Label.label((String)("marker_" + testInfo.getTestMethod()));
        String testPropertyKey = "testProperty";
        String propertyValue = RandomStringUtils.randomAscii((int)255);
        try (Transaction tx = db.beginTx();){
            Node start = tx.createNode(new Label[]{markerLabel});
            Node end = tx.createNode(new Label[]{markerLabel});
            Relationship relationship2 = start.createRelationshipTo(end, RelationshipType.withName((String)"type"));
            relationshipId = relationship2.getElementId();
            relationship2.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            relationship = tx.getRelationshipByElementId(relationshipId);
            org.junit.jupiter.api.Assertions.assertEquals((Object)propertyValue, (Object)relationship.getProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            relationship = tx.getRelationshipByElementId(relationshipId);
            relationship.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            relationship = tx.getRelationshipByElementId(relationshipId);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createDropRelationshipLongArrayProperty(TestInfo testInfo) {
        Relationship relationship;
        String relationshipId;
        Label markerLabel = Label.label((String)("marker_" + testInfo.getTestMethod()));
        String testPropertyKey = "testProperty";
        byte[] propertyValue = RandomUtils.nextBytes((int)1024);
        try (Transaction tx = db.beginTx();){
            Node start = tx.createNode(new Label[]{markerLabel});
            Node end = tx.createNode(new Label[]{markerLabel});
            Relationship relationship2 = start.createRelationshipTo(end, RelationshipType.withName((String)"type"));
            relationshipId = relationship2.getElementId();
            relationship2.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            relationship = tx.getRelationshipByElementId(relationshipId);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])propertyValue, (byte[])((byte[])relationship.getProperty(testPropertyKey)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            relationship = tx.getRelationshipByElementId(relationshipId);
            relationship.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            relationship = tx.getRelationshipByElementId(relationshipId);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToForceTypeChangeOfProperty() {
        Relationship relationship;
        try (Transaction tx = db.beginTx();){
            relationship = tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            relationship.setProperty("prop", (Object)1337);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.getRelationshipById(relationship.getId()).setProperty("prop", (Object)1337.0);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            Assertions.assertThat((Object)tx.getRelationshipById(relationship.getId()).getProperty("prop")).isInstanceOf(Double.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowCorrectExceptionOnPropertyKeyTokensExceeded() throws KernelException {
        InternalTransaction transaction = RelationshipTest.mockedTransactionWithDepletedTokens();
        RelationshipEntity relationshipEntity = new RelationshipEntity(transaction, 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> relationshipEntity.setProperty("key", (Object)"value"));
    }

    private static void verifyIds(InternalTransaction transaction, long relationshipId, long nodeId1, int typeId, long nodeId2) {
        RelationshipEntity proxy = new RelationshipEntity(transaction, relationshipId, nodeId1, typeId, nodeId2);
        org.junit.jupiter.api.Assertions.assertEquals((long)relationshipId, (long)proxy.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId1, (long)proxy.getStartNode().getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId1, (long)proxy.getStartNodeId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId2, (long)proxy.getEndNode().getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId2, (long)proxy.getEndNodeId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId2, (long)proxy.getOtherNode(RelationshipTest.nodeWithId(nodeId1)).getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId2, (long)proxy.getOtherNodeId(nodeId1));
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId1, (long)proxy.getOtherNode(RelationshipTest.nodeWithId(nodeId2)).getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId1, (long)proxy.getOtherNodeId(nodeId2));
    }

    private static Node nodeWithId(long id) {
        NodeEntity node = (NodeEntity)Mockito.mock(NodeEntity.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)id);
        return node;
    }
}

