/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.graphdb.Label;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.TestAccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class NodeTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    void shouldSeeNodeInTransaction() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                org.junit.jupiter.api.Assertions.assertEquals((long)nodeId, (long)node.nodeReference());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)nodeId, (long)tx.getNodeById(nodeId).getId());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeNewLabeledNodeInTransaction() throws Exception {
        long nodeId;
        String labelName = "Town";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.token().labelGetOrCreateForName("Town");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                TokenSet labels = node.labels();
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)labels.numberOfTokens());
                org.junit.jupiter.api.Assertions.assertEquals((int)labelId, (int)labels.token(0));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.hasLabel(labelId));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasLabel(labelId + 1));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.getNodeById(nodeId).getLabels()).isEqualTo((Object)Iterables.iterable((Object[])new Label[]{Label.label((String)"Town")}));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeLabelChangesInTransaction() throws Exception {
        int toDelete;
        int toRetain;
        long nodeId;
        String toRetainName = "ToRetain";
        String toDeleteName = "ToDelete";
        String toAddName = "ToAdd";
        String toRegretName = "ToRegret";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            toRetain = tx.token().labelGetOrCreateForName("ToRetain");
            toDelete = tx.token().labelGetOrCreateForName("ToDelete");
            tx.dataWrite().nodeAddLabel(nodeId, toRetain);
            tx.dataWrite().nodeAddLabel(nodeId, toDelete);
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.getNodeById(nodeId).getLabels()).contains((Object[])new Label[]{Label.label((String)"ToRetain"), Label.label((String)"ToDelete")});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            int toAdd = tx.token().labelGetOrCreateForName("ToAdd");
            tx.dataWrite().nodeAddLabel(nodeId, toAdd);
            tx.dataWrite().nodeRemoveLabel(nodeId, toDelete);
            int toRegret = tx.token().labelGetOrCreateForName("ToRegret");
            tx.dataWrite().nodeAddLabel(nodeId, toRegret);
            tx.dataWrite().nodeRemoveLabel(nodeId, toRegret);
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                NodeTransactionStateTestBase.assertLabels(node.labels(), toRetain, toAdd);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.hasLabel(toAdd));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.hasLabel(toRetain));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasLabel(toDelete));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasLabel(toRegret));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.getNodeById(nodeId).getLabels()).contains((Object[])new Label[]{Label.label((String)"ToRetain"), Label.label((String)"ToAdd")});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void hasAnyLabelShouldSeeNewlyCreatedLabel() throws Exception {
        long nodeId;
        String labelName = "Town";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.token().labelGetOrCreateForName("Town");
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasLabel());
            }
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            node = tx.cursors().allocateNodeCursor(tx.cursorContext());
            try {
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.hasLabel());
            }
            finally {
                if (node != null) {
                    node.close();
                }
            }
            tx.commit();
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.getNodeById(nodeId).getLabels()).isEqualTo((Object)Iterables.iterable((Object[])new Label[]{Label.label((String)"Town")}));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void hasAnyLabelShouldNotSeeNewlyCreatedLabelAndThenDeleted() throws Exception {
        String labelName = "Town";
        try (KernelTransaction tx = this.beginTransaction();){
            long nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.token().labelGetOrCreateForName("Town");
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasLabel());
            }
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            tx.dataWrite().nodeRemoveLabel(nodeId, labelId);
            node = tx.cursors().allocateNodeCursor(tx.cursorContext());
            try {
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasLabel());
            }
            finally {
                if (node != null) {
                    node.close();
                }
            }
            tx.commit();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    void hasAnyLabelShouldHandleIfAllLabelsAreDeleted() throws Exception {
        long nodeId;
        int numberOfLabels = 100;
        String[] names = (String[])IntStream.range(0, numberOfLabels).mapToObj(value -> "L" + value).toArray(String[]::new);
        int[] labelIds = new int[numberOfLabels];
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.token().labelGetOrCreateForNames(names, labelIds);
            try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, nodeCursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next(), (String)"should access node");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)nodeCursor.hasLabel());
            }
            for (int labelId : labelIds) {
                tx.dataWrite().nodeAddLabel(nodeId, labelId);
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            void var7_10;
            boolean bl = false;
            while (var7_10 < numberOfLabels) {
                tx.dataWrite().nodeRemoveLabel(nodeId, labelIds[var7_10]);
                try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                    tx.dataRead().singleNode(nodeId, node);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                    Assertions.assertThat((boolean)node.hasLabel()).isEqualTo(var7_10 < numberOfLabels - 1);
                }
                ++var7_10;
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDiscoverDeletedNodeInTransaction() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeDelete(nodeId));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleMultipleNodeDeletions() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().nodeDelete(nodeId));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().nodeDelete(nodeId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeNewNodePropertyInTransaction() throws Exception {
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (KernelTransaction tx = this.beginTransaction();){
            long nodeId = tx.dataWrite().nodeCreate();
            int prop1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            int prop2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, prop1, (Value)Values.stringValue((String)"hello")));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, prop2, (Value)Values.stringValue((String)"world")));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                IntObjectHashMap foundProperties = IntObjectHashMap.newMap();
                while (property.next()) {
                    org.junit.jupiter.api.Assertions.assertNull((Object)foundProperties.put(property.propertyKey(), (Object)property.propertyValue()), (String)"should only find each property once");
                }
                Assertions.assertThat((Iterable)foundProperties).hasSize(2);
                Assertions.assertThat((Object)((Value)foundProperties.get(prop1))).isEqualTo((Object)Values.stringValue((String)"hello"));
                Assertions.assertThat((Object)((Value)foundProperties.get(prop2))).isEqualTo((Object)Values.stringValue((String)"world"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
    }

    @Test
    void shouldSeeAddedPropertyFromExistingNodeWithoutPropertiesInTransaction() throws Exception {
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should only find one properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey)).isEqualTo((Object)"hello");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeAddedPropertyFromExistingNodeWithPropertiesInTransaction() throws Exception {
        int propToken1;
        long nodeId;
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken1, (Value)Values.stringValue((String)"hello")));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int propToken2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken2, (Value)Values.stringValue((String)"world")));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken2, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken1, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should only find two properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey1)).isEqualTo((Object)"hello");
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey2)).isEqualTo((Object)"world");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeUpdatedPropertyFromExistingNodeWithPropertiesInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.stringValue((String)"hello"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should only find one property");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey)).isEqualTo((Object)"world");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeRemovedPropertyInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((Object)tx.dataWrite().nodeRemoveProperty(nodeId, propToken), (Object)Values.stringValue((String)"hello"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should not find any properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.getNodeById(nodeId).hasProperty(propKey));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeRemovedThenAddedPropertyInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((Object)tx.dataWrite().nodeRemoveProperty(nodeId, propToken), (Object)Values.stringValue((String)"hello"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"world")));
            try (NodeCursor node = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor property = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(nodeId, node);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)property.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                org.junit.jupiter.api.Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)property.next(), (String)"should not find any properties");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.graphDb.beginTx();
        try {
            Assertions.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey)).isEqualTo((Object)"world");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeExistingNode() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataRead().nodeExists(node));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotSeeNonExistingNode() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataRead().nodeExists(1337L));
        }
    }

    @Test
    void shouldSeeNodeExistingInTxOnly() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataRead().nodeExists(node));
        }
    }

    @Test
    void shouldNotSeeDeletedNode() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(node);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataRead().nodeExists(node));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotFindDeletedNodeInLabelScan() throws Exception {
        Node node = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());){
            tx.dataWrite().nodeDelete(node.node);
            tx.dataRead().nodeLabelScan(NodeTransactionStateTestBase.getTokenReadSession(tx, EntityType.NODE), cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(node.labels[0]), tx.cursorContext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindNodeWithRemovedLabelInLabelScan() throws Exception {
        Node node = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());){
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[0]);
            tx.dataRead().nodeLabelScan(NodeTransactionStateTestBase.getTokenReadSession(tx, EntityType.NODE), cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(node.labels[0]), tx.cursorContext());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldFindUpdatedNodeInInLabelScan() throws Exception {
        Node node = this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());){
            int label = tx.tokenWrite().labelGetOrCreateForName("label");
            tx.dataWrite().nodeAddLabel(node.node, label);
            tx.dataRead().nodeLabelScan(NodeTransactionStateTestBase.getTokenReadSession(tx, EntityType.NODE), cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(label), tx.cursorContext());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)node.node, (long)cursor.nodeReference());
        }
    }

    @Test
    void shouldFindSwappedNodeInLabelScan() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(tx.cursorContext());){
            tx.dataWrite().nodeRemoveLabel(node1.node, node1.labels[0]);
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            tx.dataRead().nodeLabelScan(NodeTransactionStateTestBase.getTokenReadSession(tx, EntityType.NODE), cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(node1.labels[0]), tx.cursorContext());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertEquals((long)node2.node, (long)cursor.nodeReference());
        }
    }

    @Test
    void shouldCountNewLabelsFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)countNoTxState);
        }
    }

    @Test
    void shouldCountNewNodesFromTxState() throws Exception {
        this.createNode(new String[0]);
        this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeCreate();
            long countTxState = tx.dataRead().countsForNode(-1);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(-1);
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedLabelsFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeRemoveLabel(node2.node, node2.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedNodesFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeDelete(node2.node);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldCountNewLabelsFromTxStateRestrictedUser() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)countNoTxState);
        }
    }

    @Test
    void shouldCountNewNodesFromTxStateRestrictedUser() throws Exception {
        this.createNode(new String[0]);
        this.createNode(new String[0]);
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeCreate();
            long countTxState = tx.dataRead().countsForNode(-1);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(-1);
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedLabelsFromTxStateRestrictedUser() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeRemoveLabel(node2.node, node2.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedNodesFromTxStateRestrictedUser() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false), ClientConnectionInfo.EMBEDDED_CONNECTION, null);
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeDelete(node2.node);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)countTxState);
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void hasPropertiesShouldSeeNewlyCreatedProperties() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor cursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor props = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(node, cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
            tx.dataWrite().nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static boolean hasProperties(NodeCursor cursor, PropertyCursor props) {
        cursor.properties(props);
        return props.next();
    }

    @Test
    void hasPropertiesShouldSeeNewlyCreatedPropertiesOnNewlyCreatedNode() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
                 PropertyCursor props = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
                tx.dataRead().singleNode(node, cursor);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
                tx.dataWrite().nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
            }
        }
    }

    @Test
    void hasPropertiesShouldSeeNewlyRemovedProperties() throws Exception {
        int prop3;
        int prop2;
        int prop1;
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            prop3 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop3");
            tx.dataWrite().nodeSetProperty(node, prop1, (Value)Values.longValue((long)1L));
            tx.dataWrite().nodeSetProperty(node, prop2, (Value)Values.longValue((long)2L));
            tx.dataWrite().nodeSetProperty(node, prop3, (Value)Values.longValue((long)3L));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor cursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor props = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(node, cursor);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop3);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)NodeTransactionStateTestBase.hasProperties(cursor, props));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void propertyTypeShouldBeTxStateAware() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor nodes = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor properties = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().singleNode(node, nodes);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodes.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)NodeTransactionStateTestBase.hasProperties(nodes, properties));
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(node, prop, (Value)Values.stringValue((String)"foo"));
            nodes.properties(properties);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.next());
            Assertions.assertThat((Comparable)properties.propertyType()).isEqualTo((Object)ValueGroup.TEXT);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void assertLabels(TokenSet labels, int ... expected) {
        org.junit.jupiter.api.Assertions.assertEquals((int)expected.length, (int)labels.numberOfTokens());
        Arrays.sort(expected);
        int[] labelArray = new int[labels.numberOfTokens()];
        for (int i = 0; i < labels.numberOfTokens(); ++i) {
            labelArray[i] = labels.token(i);
        }
        Arrays.sort(labelArray);
        org.junit.jupiter.api.Assertions.assertArrayEquals((int[])expected, (int[])labelArray, (String)"labels match expected");
    }

    public Node createNode(String ... labels) throws Exception {
        long node;
        int[] labelIds = new int[labels.length];
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            node = write.nodeCreate();
            for (int i = 0; i < labels.length; ++i) {
                labelIds[i] = tx.tokenWrite().labelGetOrCreateForName(labels[i]);
                write.nodeAddLabel(node, labelIds[i]);
            }
            tx.commit();
        }
        return new Node(node, labelIds);
    }

    private static TokenReadSession getTokenReadSession(KernelTransaction tx, EntityType entityType) throws IndexNotFoundKernelException {
        Iterator indexes = tx.schemaRead().index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType));
        IndexDescriptor index = (IndexDescriptor)indexes.next();
        Assertions.assertThat((boolean)indexes.hasNext()).isFalse();
        return tx.dataRead().tokenReadSession(index);
    }

    private static class Node {
        private final long node;
        private final int[] labels;

        private Node(long node, int[] labels) {
            this.node = node;
            this.labels = labels;
        }

        public long node() {
            return this.node;
        }

        public int[] labels() {
            return this.labels;
        }
    }
}

