/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelPartitionedNodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static LongList NODE_IDS;
    private static final int NUMBER_OF_NODES = 128;
    private static final ToLongFunction<NodeCursor> NODE_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            LongArrayList list = new LongArrayList(128);
            for (int i = 0; i < 128; ++i) {
                list.add(tx.createNode().getId());
            }
            NODE_IDS = list;
            tx.commit();
        }
    }

    @Test
    void shouldScanASubsetOfNodes() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            PartitionedScan scan = this.read.allNodesScan(32, CursorContext.NULL_CONTEXT);
            Assertions.assertTrue((boolean)scan.reservePartition((Cursor)nodes, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(0), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(1), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(2), (long)nodes.nodeReference());
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertEquals((long)NODE_IDS.get(3), (long)nodes.nodeReference());
            Assertions.assertFalse((boolean)nodes.next());
        }
    }

    @Test
    void shouldHandleSinglePartition() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            PartitionedScan scan = this.read.allNodesScan(1, CursorContext.NULL_CONTEXT);
            Assertions.assertTrue((boolean)scan.reservePartition((Cursor)nodes, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode()));
            LongArrayList ids = new LongArrayList();
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
            Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
        }
    }

    @Test
    void shouldFailOnZeroPartitions() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.read.allNodesScan(0, CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldScanAllNodesInBatchesWithGetNumberOfPartitions() {
        LongArrayList ids = new LongArrayList();
        PartitionedScan scan = this.read.allNodesScan(10, CursorContext.NULL_CONTEXT);
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
                scan.reservePartition((Cursor)nodes, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode());
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
                continue;
            }
        }
        Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
    }

    @Test
    void shouldScanAllNodesInBatchesWithoutGetNumberOfPartitions() {
        PartitionedScan scan = this.read.allNodesScan(10, CursorContext.NULL_CONTEXT);
        LongArrayList ids = new LongArrayList();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
            while (scan.reservePartition((Cursor)nodes, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode())) {
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
            }
        }
        Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
    }

    @Test
    void shouldHandleMorePartitionsThanNodes() {
        LongArrayList ids = new LongArrayList();
        PartitionedScan scan = this.read.allNodesScan(256, CursorContext.NULL_CONTEXT);
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
                scan.reservePartition((Cursor)nodes, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode());
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
                continue;
            }
        }
        Assertions.assertEquals((Object)NODE_IDS, (Object)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException {
        PartitionedScan scan = this.read.allNodesScan(4, CursorContext.NULL_CONTEXT);
        ExecutorService service = Executors.newFixedThreadPool(scan.getNumberOfPartitions());
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateNodeCursor(arg_0), scan.getNumberOfPartitions());
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(scan, workerContexts, NodeCursor::nodeReference));
            List ids = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(ids);
            Assertions.assertEquals((Object)NODE_IDS, (Object)TestUtils.concat(ids).toSortedList());
        }
        finally {
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleRandomNumberOfPartitions() throws InterruptedException, ExecutionException {
        int desiredNumberOfPartitions = ThreadLocalRandom.current().nextInt(128) + 1;
        PartitionedScan scan = this.read.allNodesScan(desiredNumberOfPartitions, CursorContext.NULL_CONTEXT);
        ExecutorService service = Executors.newFixedThreadPool(scan.getNumberOfPartitions());
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        String errorMessage = "Failed with: desiredNumberOfPartitions=" + desiredNumberOfPartitions;
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateNodeCursor(arg_0), scan.getNumberOfPartitions());
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(scan, workerContexts, NODE_GET));
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES), (String)errorMessage);
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists, errorMessage);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)NODE_IDS, (Object)concat, (String)errorMessage);
        }
        finally {
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES), (String)errorMessage);
        }
    }

    @Test
    void shouldBeReadCommitted() throws ExecutionException, InterruptedException, TimeoutException {
        LongHashSet ids = new LongHashSet();
        PartitionedScan scan = this.read.allNodesScan(10, CursorContext.NULL_CONTEXT);
        LongList newNodes = this.createNodesInSeparateTransaction(5);
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL_CONTEXT);){
                scan.reservePartition((Cursor)nodes, CursorContext.NULL_CONTEXT, this.tx.securityContext().mode());
                while (nodes.next()) {
                    ids.add(nodes.nodeReference());
                }
                continue;
            }
        }
        newNodes.forEach(arg_0 -> ParallelPartitionedNodeCursorTestBase.lambda$shouldBeReadCommitted$e6548c8d$1((MutableLongSet)ids, arg_0));
        newNodes.forEach((LongProcedure & Serializable)newNode -> {
            try {
                this.tx.dataWrite().nodeDelete(newNode);
            }
            catch (InvalidTransactionTypeKernelException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    private LongList createNodesInSeparateTransaction(int numberOfNodesToCreate) throws ExecutionException, InterruptedException, TimeoutException {
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<LongList> futureList = service.submit(() -> {
            LongArrayList newNodes = new LongArrayList(numberOfNodesToCreate);
            try (KernelTransaction tx = this.testSupport.kernelToTest().beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                for (int i = 0; i < numberOfNodesToCreate; ++i) {
                    newNodes.add(tx.dataWrite().nodeCreate());
                }
                tx.commit();
            }
            return newNodes;
        });
        return futureList.get(1L, TimeUnit.MINUTES);
    }

    private static /* synthetic */ void lambda$shouldBeReadCommitted$e6548c8d$1(MutableLongSet ids, long newNode) {
        Assertions.assertTrue((boolean)ids.contains(newNode));
    }

    static {
        NODE_GET = NodeCursor::nodeReference;
    }
}

