/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.Values;

public abstract class TransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    void shouldDetectNodeDeletedInTransaction() throws Exception {
        long unaffected;
        long deletedInTx;
        try (KernelTransaction tx = this.beginTransaction();){
            deletedInTx = tx.dataWrite().nodeCreate();
            unaffected = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            long addedInTx = tx.dataWrite().nodeCreate();
            long addedAndRemovedInTx = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeDelete(deletedInTx);
            tx.dataWrite().nodeDelete(addedAndRemovedInTx);
            Assertions.assertFalse((boolean)tx.dataRead().nodeDeletedInTransaction(addedInTx));
            Assertions.assertFalse((boolean)tx.dataRead().nodeDeletedInTransaction(unaffected));
            Assertions.assertTrue((boolean)tx.dataRead().nodeDeletedInTransaction(addedAndRemovedInTx));
            Assertions.assertTrue((boolean)tx.dataRead().nodeDeletedInTransaction(deletedInTx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDetectRelationshipDeletedInTransaction() throws Exception {
        long unaffected;
        long deletedInTx;
        int relType;
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            relType = tx.tokenWrite().relationshipTypeCreateForName("REL_TYPE", false);
            deletedInTx = tx.dataWrite().relationshipCreate(node, relType, node);
            unaffected = tx.dataWrite().relationshipCreate(node, relType, node);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            long addedInTx = tx.dataWrite().relationshipCreate(node, relType, node);
            long addedAndRemovedInTx = tx.dataWrite().relationshipCreate(node, relType, node);
            tx.dataWrite().relationshipDelete(deletedInTx);
            tx.dataWrite().relationshipDelete(addedAndRemovedInTx);
            Assertions.assertFalse((boolean)tx.dataRead().relationshipDeletedInTransaction(addedInTx));
            Assertions.assertFalse((boolean)tx.dataRead().relationshipDeletedInTransaction(unaffected));
            Assertions.assertTrue((boolean)tx.dataRead().relationshipDeletedInTransaction(addedAndRemovedInTx));
            Assertions.assertTrue((boolean)tx.dataRead().relationshipDeletedInTransaction(deletedInTx));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldReportInTransactionNodeProperty() throws Exception {
        int p5;
        int p4;
        int p3;
        int p2;
        int p1;
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            p1 = tx.tokenWrite().propertyKeyGetOrCreateForName("p1");
            p2 = tx.tokenWrite().propertyKeyGetOrCreateForName("p2");
            p3 = tx.tokenWrite().propertyKeyGetOrCreateForName("p3");
            p4 = tx.tokenWrite().propertyKeyGetOrCreateForName("p4");
            p5 = tx.tokenWrite().propertyKeyGetOrCreateForName("p5");
            tx.dataWrite().nodeSetProperty(node, p1, Values.of((Object)1));
            tx.dataWrite().nodeSetProperty(node, p3, Values.of((Object)3));
            tx.dataWrite().nodeSetProperty(node, p4, Values.of((Object)4));
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeSetProperty(node, p3, Values.of((Object)13));
            tx.dataWrite().nodeRemoveProperty(node, p4);
            tx.dataWrite().nodeSetProperty(node, p5, Values.of((Object)15));
            Assertions.assertNull((Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p1), (String)"Unchanged existing property is null");
            Assertions.assertNull((Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p2), (String)"Unchanged missing property is null");
            Assertions.assertEquals((Object)Values.of((Object)13), (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p3), (String)"Changed property is new value");
            Assertions.assertEquals((Object)Values.NO_VALUE, (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p4), (String)"Removed property is NO_VALUE");
            Assertions.assertEquals((Object)Values.of((Object)15), (Object)tx.dataRead().nodePropertyChangeInTransactionOrNull(node, p5), (String)"Added property is new value");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

