/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitmentFactory;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

class LabelAndIndexUpdateBatchingIT {
    private static final String PROPERTY_KEY = "key";
    private static final Label LABEL = Label.label((String)"label");

    LabelAndIndexUpdateBatchingIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void indexShouldIncludeNodesCreatedPreviouslyInBatch() throws Exception {
        List<CommittedCommandBatch> transactions;
        long txIdCutOffPoint;
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        long txIdToStartFrom = LabelAndIndexUpdateBatchingIT.getLastClosedTransactionId(db) + 1L;
        String nodeN = "our guy";
        String otherNode = "just to create the tokens";
        try {
            try (Transaction tx = db.beginTx();){
                tx.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)otherNode);
                for (int i = 0; i < 10000; ++i) {
                    tx.createNode();
                }
                tx.commit();
            }
            tx = db.beginTx();
            try {
                tx.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)nodeN);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            txIdCutOffPoint = ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
            tx = db.beginTx();
            try {
                tx.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            transactions = LabelAndIndexUpdateBatchingIT.extractTransactions(db, txIdToStartFrom);
        }
        finally {
            managementService.shutdown();
        }
        managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        db = (GraphDatabaseAPI)managementService.database("neo4j");
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)db.getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
        try {
            int cutoffIndex = LabelAndIndexUpdateBatchingIT.findCutoffIndex(transactions, txIdCutOffPoint);
            commitProcess.commit((CommandBatchToApply)LabelAndIndexUpdateBatchingIT.toApply(transactions.subList(0, cutoffIndex), db), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            commitProcess.commit((CommandBatchToApply)LabelAndIndexUpdateBatchingIT.toApply(transactions.subList(cutoffIndex, transactions.size()), db), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            try (Transaction tx = db.beginTx();){
                Assertions.assertNotNull((Object)Iterators.singleOrNull((Iterator)tx.findNodes(LABEL, PROPERTY_KEY, (Object)otherNode)), (String)"Verification node not found");
                Assertions.assertNotNull((Object)Iterators.singleOrNull((Iterator)tx.findNodes(LABEL, PROPERTY_KEY, (Object)nodeN)), (String)"Node N not found");
                tx.commit();
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    private static int findCutoffIndex(Collection<CommittedCommandBatch> transactions, long txId) {
        Iterator<CommittedCommandBatch> iterator = transactions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            CommittedCommandBatch tx = iterator.next();
            if (tx.txId() == txId) {
                return i;
            }
            ++i;
        }
        throw new AssertionError((Object)"Couldn't find the transaction which would be the cut-off point");
    }

    private static TransactionToApply toApply(Collection<CommittedCommandBatch> transactions, GraphDatabaseAPI db) {
        StorageEngine storageEngine = (StorageEngine)db.getDependencyResolver().resolveDependency(StorageEngine.class);
        TransactionCommitmentFactory commitmentFactory = (TransactionCommitmentFactory)db.getDependencyResolver().resolveDependency(TransactionCommitmentFactory.class);
        TransactionIdGenerator transactionIdGenerator = (TransactionIdGenerator)db.getDependencyResolver().resolveDependency(TransactionIdGenerator.class);
        TransactionToApply first = null;
        TransactionToApply last = null;
        try (StoreCursors storeCursors = storageEngine.createStorageCursors(CursorContext.NULL_CONTEXT);){
            for (CommittedCommandBatch tx : transactions) {
                TransactionToApply transaction = new TransactionToApply(tx, CursorContext.NULL_CONTEXT, storeCursors, commitmentFactory.newCommitment(), transactionIdGenerator);
                if (first == null) {
                    first = last = transaction;
                    continue;
                }
                last.next((CommandBatchToApply)transaction);
                last = transaction;
            }
        }
        return first;
    }

    private static List<CommittedCommandBatch> extractTransactions(GraphDatabaseAPI db, long txIdToStartOn) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        ArrayList<CommittedCommandBatch> transactions = new ArrayList<CommittedCommandBatch>();
        try (CommandBatchCursor cursor = txStore.getCommandBatches(txIdToStartOn);){
            cursor.forAll(transactions::add);
        }
        return transactions;
    }

    private static long getLastClosedTransactionId(GraphDatabaseAPI database) {
        MetadataProvider metaDataStore = (MetadataProvider)database.getDependencyResolver().resolveDependency(MetadataProvider.class);
        return metaDataStore.getLastClosedTransaction().transactionId();
    }
}

