/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.file.Files;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class VersionAwareLogEntryReaderIT {
    private static final long AT_LEAST_END_OF_DATA_OFFSET = 1128L;
    private static final long AT_MOST_END_OF_DATA_OFFSET = ByteUnit.kibiBytes((long)128L);
    private static final StoreId STORE_ID = new StoreId(4L, 5L, "engine-1", "format-1", 1, 2);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseManagementService managementService;
    private DatabaseLayout databaseLayout;
    private VersionAwareLogEntryReader entryReader;
    private StorageEngineFactory storageEngineFactory;

    VersionAwareLogEntryReaderIT() {
    }

    @BeforeEach
    void setUp() {
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.managementService.database("neo4j");
        VersionAwareLogEntryReaderIT.createNode((GraphDatabaseService)database);
        this.databaseLayout = database.databaseLayout();
        this.storageEngineFactory = (StorageEngineFactory)database.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        this.entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        this.managementService.shutdown();
    }

    @Test
    @EnabledOnOs(value={OS.LINUX})
    void readOnlyLogFilesWhileCommandsAreAvailable() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withStorageEngineFactory(this.storageEngineFactory).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(STORE_ID).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            this.getLastReadablePosition(logFiles);
            org.junit.jupiter.api.Assertions.assertEquals((long)ByteUnit.kibiBytes((long)128L), (long)Files.size(logFiles.getLogFile().getHighestLogFile()));
            LogPosition logPosition = this.entryReader.lastPosition();
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)logPosition.getLogVersion());
            Assertions.assertThat((long)logPosition.getByteOffset()).isGreaterThanOrEqualTo(1128L);
            Assertions.assertThat((long)logPosition.getByteOffset()).isLessThan(AT_MOST_END_OF_DATA_OFFSET);
        }
    }

    @Test
    void correctlyResetPositionWhenEndOfCommandsReached() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withStorageEngineFactory(this.storageEngineFactory).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(STORE_ID).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            long offset = 0L;
            for (int i = 0; i < 10; ++i) {
                long lastReadablePosition = this.getLastReadablePosition(logFiles);
                Assertions.assertThat((long)lastReadablePosition).isGreaterThanOrEqualTo(1000L);
                Assertions.assertThat((long)lastReadablePosition).isLessThan(AT_MOST_END_OF_DATA_OFFSET);
                if (i > 0) {
                    Assertions.assertThat((long)lastReadablePosition).isEqualTo(offset);
                }
                offset = lastReadablePosition;
            }
        }
    }

    @Test
    @DisabledOnOs(value={OS.LINUX})
    void readTillTheEndOfNotPreallocatedFile() throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withStorageEngineFactory(this.storageEngineFactory).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(STORE_ID).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            this.getLastReadablePosition(logFiles);
            LogPosition logPosition = this.entryReader.lastPosition();
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)logPosition.getLogVersion());
            org.junit.jupiter.api.Assertions.assertEquals((long)Files.size(logFiles.getLogFile().getHighestLogFile()), (long)logPosition.getByteOffset());
        }
    }

    private long getLastReadablePosition(LogFiles logFiles) throws IOException {
        LogFile logFile = logFiles.getLogFile();
        try (ReadableLogChannel logChannel = logFile.getReader(logFile.extractHeader(0L).getStartPosition());){
            while (this.entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)logChannel) != null) {
            }
            long l = this.entryReader.lastPosition().getByteOffset();
            return l;
        }
    }

    private static void createNode(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
    }
}

