/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configuration")
public class OutOfDiskSpaceMonitoringIT {
    private DatabaseEventContext eventContext;
    @Inject
    private DatabaseHealth databaseHealth;
    @Inject
    private GraphDatabaseService db;

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        DatabaseEventListenerAdapter listener = new DatabaseEventListenerAdapter(){

            public void databaseOutOfDiskSpace(DatabaseEventContext event) {
                OutOfDiskSpaceMonitoringIT.this.eventContext = event;
            }
        };
        builder.addDatabaseListener((DatabaseEventListener)listener);
    }

    @Test
    void shouldPropagateOutOfDiskSpaceEventToRegisteredListener() {
        this.databaseHealth.outOfDiskSpace();
        Assertions.assertThat((Object)this.eventContext).isNotNull();
        Assertions.assertThat((String)this.eventContext.getDatabaseName()).isEqualTo("neo4j");
    }

    @Test
    void shouldPutDatabaseIntoReadOnlyState() {
        this.databaseHealth.outOfDiskSpace();
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThatThrownBy(() -> ((Transaction)tx).createNode()).hasMessageContaining("No write operations are allowed on this database. The database is in read-only mode on this Neo4j instance.");
            tx.commit();
        }
    }
}

