/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.IndexingTestUtil;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class RecoveryWithTokenIndexesIT {
    @RegisterExtension
    static final PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;
    private Config config;
    private static final Label label = Label.label((String)"label");
    private static final RelationshipType type = RelationshipType.withName((String)"type");

    RecoveryWithTokenIndexesIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    private static Stream<Arguments> arguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"indexes created during recovery", false}), Arguments.of((Object[])new Object[]{"indexes updated during recovery", true}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"arguments"})
    void recoverDatabaseWithTokenIndexes(String name, boolean checkpointIndexes) throws Throwable {
        this.config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).build();
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        GraphDatabaseService db = this.startDatabase(fs);
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists(db);
        if (checkpointIndexes) {
            RecoveryWithTokenIndexesIT.checkPoint(db);
        }
        int numberOfEntities = 10;
        for (int i = 0; i < numberOfEntities; ++i) {
            RecoveryWithTokenIndexesIT.createEntities(db);
        }
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        this.managementService.shutdown();
        fs.close();
        try (PageCache cache = pageCacheExtension.getPageCache((FileSystemAbstraction)crashedFs);){
            DatabaseLayout layout = DatabaseLayout.of((Config)this.config);
            this.recoverDatabase(layout, (FileSystemAbstraction)crashedFs, cache);
        }
        db = this.startDatabase(crashedFs);
        IndexingTestUtil.assertOnlyDefaultTokenIndexesExists(db);
        RecoveryWithTokenIndexesIT.awaitIndexesOnline(db);
        try (Transaction tx = db.beginTx();){
            Assertions.assertEquals((long)numberOfEntities, (long)Iterators.count((Iterator)tx.findNodes(label)));
            Assertions.assertEquals((long)numberOfEntities, (long)Iterators.count((Iterator)tx.findRelationships(type)));
        }
    }

    private static void checkPoint(GraphDatabaseService db) throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Manual trigger"));
    }

    private static void awaitIndexesOnline(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            transaction.commit();
        }
    }

    private GraphDatabaseService startDatabase(EphemeralFileSystemAbstraction fs) {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setFileSystem((FileSystemAbstraction)fs).setConfig(this.config).build();
        return this.managementService.database("neo4j");
    }

    private void recoverDatabase(DatabaseLayout layout, FileSystemAbstraction fs, PageCache cache) throws Exception {
        Assertions.assertTrue((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (DatabaseLayout)layout, (Config)this.config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        Recovery.performRecovery((Recovery.Context)Recovery.context((FileSystemAbstraction)fs, (PageCache)cache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)this.config, (DatabaseLayout)layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)NullLogProvider.getInstance()));
        Assertions.assertFalse((boolean)Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (DatabaseLayout)layout, (Config)this.config, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    private static void createEntities(GraphDatabaseService service) {
        try (Transaction transaction = service.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.createRelationshipTo(node, type);
            transaction.commit();
        }
    }
}

