/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class CreateConstraintFromToStringITBase {
    protected static final Label LABEL = TestLabels.LABEL_ONE;
    protected static final RelationshipType REL_TYPE = RelationshipType.withName((String)"REL_TYPE");
    protected static final String PROP_ONE = "propOne";
    protected static final String PROP_TWO = "propTwo";
    @Inject
    private GraphDatabaseService db;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.rel_unique_constraints, (Object)true);
    }

    @BeforeEach
    void cleanupConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getConstraints().forEach(ConstraintDefinition::drop);
            tx.commit();
        }
    }

    protected void testShouldRecreateSimilarConstraintFromToStringMethod(ConstraintFunction constraintFunction) {
        ConstraintDefinition originalConstraint;
        try (Transaction tx = this.db.beginTx();){
            originalConstraint = constraintFunction.apply(tx.schema()).create();
            tx.commit();
        }
        this.assertConstraintCount(1);
        tx = this.db.beginTx();
        try {
            tx.schema().getConstraintByName(originalConstraint.getName()).drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertConstraintCount(0);
        tx = this.db.beginTx();
        try {
            tx.execute("CREATE CONSTRAINT " + originalConstraint);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertConstraintCount(1);
        tx = this.db.beginTx();
        try {
            ConstraintDefinition resultingConstraint = (ConstraintDefinition)Iterables.single((Iterable)tx.schema().getConstraints());
            Assertions.assertThat((String)resultingConstraint.toString()).isEqualTo(originalConstraint.toString());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertConstraintCount(int expectedNumberOfConstraints) {
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo((long)expectedNumberOfConstraints);
            tx.commit();
        }
    }

    @FunctionalInterface
    protected static interface ConstraintFunction {
        public ConstraintCreator apply(Schema var1);
    }
}

