/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class TestPropertyBlocks
extends AbstractNeo4jTestCase {
    TestPropertyBlocks() {
    }

    @Test
    void simpleAddIntegers() {
        int i;
        Node txNode;
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
                txNode.setProperty("prop" + i, (Object)i);
                Assertions.assertEquals((Object)i, (Object)txNode.getProperty("prop" + i));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
                Assertions.assertEquals((Object)i, (Object)txNode.getProperty("prop" + i));
            }
            for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
                Assertions.assertEquals((Object)i, (Object)txNode.removeProperty("prop" + i));
                Assertions.assertFalse((boolean)txNode.hasProperty("prop" + i));
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)inUseBefore, (long)this.propertyRecordsInUse());
    }

    @Test
    void simpleAddDoubles() {
        int i;
        Node txNode;
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
                txNode.setProperty("prop" + i, (Object)((double)i * -1.0));
                Assertions.assertEquals((Object)((double)i * -1.0), (Object)txNode.getProperty("prop" + i));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
                Assertions.assertEquals((Object)((double)i * -1.0), (Object)txNode.getProperty("prop" + i));
            }
            for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
                Assertions.assertEquals((Object)((double)i * -1.0), (Object)txNode.removeProperty("prop" + i));
                Assertions.assertFalse((boolean)txNode.hasProperty("prop" + i));
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)inUseBefore, (long)this.propertyRecordsInUse());
    }

    @Test
    void deleteEverythingInMiddleRecord() {
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.createNode();
        HashMap<CallSite, String> properties = new HashMap<CallSite, String>();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            for (int i = 0; i < 3 * PropertyType.getPayloadSizeLongs(); ++i) {
                String key = "shortString" + i;
                String value = String.valueOf(i);
                txNode.setProperty(key, (Object)value);
                properties.put((CallSite)((Object)key), value);
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(inUseBefore + 3L), (long)this.propertyRecordsInUse());
        List<Pair<String, Object>> middleRecordProps = this.getPropertiesFromNode(node.getId(), 1);
        try (Transaction transaction = this.getGraphDb().beginTx();){
            middleRecordProps.forEach(nameAndValue -> {
                String name = (String)nameAndValue.getOne();
                Object value = nameAndValue.getTwo();
                Assertions.assertEquals((Object)value, (Object)transaction.getNodeById(node.getId()).removeProperty(name));
                properties.remove(name);
            });
            transaction.commit();
        }
        Assertions.assertEquals((long)(inUseBefore + 2L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            Node txNode = transaction.getNodeById(node.getId());
            for (String key : properties.keySet()) {
                Assertions.assertEquals(properties.get(key), (Object)txNode.removeProperty(key));
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private List<Pair<String, Object>> getPropertiesFromNode(long nodeId, int recordIndexInChain) {
        NodeStore nodeStore = this.nodeStore();
        PropertyStore propertyStore = this.propertyStore();
        try (PageCursor cursor = nodeStore.openPageCursorForReading(0L, CursorContext.NULL_CONTEXT);){
            List<Pair<String, Object>> list;
            block13: {
                PageCursor propertyCursor = propertyStore.openPageCursorForReading(0L, CursorContext.NULL_CONTEXT);
                try {
                    NodeRecord nodeRecord = (NodeRecord)nodeStore.newRecord();
                    PropertyRecord propertyRecord = propertyStore.newRecord();
                    nodeStore.getRecordByCursor(nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.NORMAL, cursor);
                    long prop = nodeRecord.getNextProp();
                    for (int i = 0; i < recordIndexInChain; ++i) {
                        propertyStore.getRecordByCursor(prop, (AbstractBaseRecord)propertyRecord, RecordLoad.NORMAL, propertyCursor);
                        prop = propertyRecord.getNextProp();
                    }
                    list = this.getPropertiesFromRecord(prop);
                    if (propertyCursor == null) break block13;
                }
                catch (Throwable throwable) {
                    if (propertyCursor != null) {
                        try {
                            propertyCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                propertyCursor.close();
            }
            return list;
        }
    }

    private List<Pair<String, Object>> getPropertiesFromRecord(long recordId) {
        ArrayList<Pair<String, Object>> props = new ArrayList<Pair<String, Object>>();
        PropertyStore propertyStore = this.propertyStore();
        PropertyRecord record = propertyStore.newRecord();
        try (PageCursor cursor = propertyStore.openPageCursorForReading(0L, CursorContext.NULL_CONTEXT);){
            propertyStore.getRecordByCursor(recordId, (AbstractBaseRecord)record, RecordLoad.FORCE, cursor);
        }
        try (StoreCursors storeCursors = this.createStoreCursors();){
            record.forEach(block -> {
                Object value = propertyStore.getValue(block, storeCursors).asObject();
                String name = propertyStore.getPropertyKeyTokenStore().getToken(block.getKeyIndexId(), storeCursors).name();
                props.add(Tuples.pair((Object)name, (Object)value));
            });
        }
        return props;
    }

    @Test
    void largeTx() {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node node = transaction.createNode();
            node.setProperty("anchor", (Object)"hi");
            for (int i = 0; i < 255; ++i) {
                node.setProperty("foo", (Object)1);
                node.removeProperty("foo");
            }
            transaction.commit();
        }
    }

    @Test
    void deleteAndAddToFullPropertyRecord() {
        int i;
        Node txNode;
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs(); ++i) {
                txNode.setProperty("prop" + i, (Object)i);
            }
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs() - 1; ++i) {
                Assertions.assertEquals((Object)i, (Object)txNode.removeProperty("prop" + i));
            }
            txNode.setProperty("profit", (Object)5);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        int remainingProperty = PropertyType.getPayloadSizeLongs() - 1;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode2 = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)remainingProperty, (Object)txNode2.getProperty("prop" + remainingProperty));
            Assertions.assertEquals((Object)5, (Object)txNode2.getProperty("profit"));
            transaction.commit();
        }
    }

    @Test
    void checkPacking() {
        Node txNode;
        long inUseBefore = this.propertyRecordsInUse();
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(node.getId()).setProperty("prop0", (Object)0);
            transaction.commit();
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (int i = 1; i < PropertyType.getPayloadSizeLongs(); ++i) {
                txNode.setProperty("prop" + i, (Object)i);
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)0, (Object)txNode.removeProperty("prop0"));
            txNode.setProperty("prop-1", (Object)-1);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)-1, (Object)txNode.removeProperty("prop-1"));
            Assertions.assertEquals((Object)1, (Object)txNode.removeProperty("prop1"));
            txNode.setProperty("propDouble", (Object)1.0);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("prop-2", (Object)-2);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    void substituteOneLargeWithManySmallPropBlocks() {
        int i;
        Node txNode;
        Node node = this.createNode();
        long inUseBefore = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs() / 2; ++i) {
                txNode.setProperty("double" + i, (Object)((double)i * 1.0));
            }
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < PropertyType.getPayloadSizeLongs() % 2; ++i) {
                txNode.setProperty("int" + i, (Object)i);
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).removeProperty("double0");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("int-1", (Object)-1);
            txNode.setProperty("int-2", (Object)-2);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("int-3", (Object)-3);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    void testBlockDefragmentationWithTwoSpaces() {
        int stuffedIntegers;
        Node txNode;
        Assumptions.assumeTrue((PropertyType.getPayloadSizeLongs() > 2 ? 1 : 0) != 0);
        Node node = this.createNode();
        long inUseBefore = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (stuffedIntegers = 0; stuffedIntegers < PropertyType.getPayloadSizeLongs(); ++stuffedIntegers) {
                txNode.setProperty("int" + stuffedIntegers, (Object)stuffedIntegers);
            }
            transaction.commit();
        }
        Assertions.assertEquals((int)stuffedIntegers, (int)PropertyType.getPayloadSizeLongs());
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.removeProperty("int0");
            txNode.removeProperty("int2");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("theDouble", (Object)1.0);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(inUseBefore + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            Assertions.assertNull((Object)txNode.getProperty("int0", null));
            Assertions.assertEquals((Object)1, (Object)txNode.getProperty("int1"));
            Assertions.assertNull((Object)txNode.getProperty("int2", null));
            for (int i = 3; i < stuffedIntegers; ++i) {
                Assertions.assertEquals((Object)i, (Object)txNode.getProperty("int" + i));
            }
            Assertions.assertEquals((Object)1.0, (Object)txNode.getProperty("theDouble"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void checkDeletesRemoveRecordsWhenProper() {
        int i;
        int stuffedBooleans;
        Node txNode;
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (stuffedBooleans = 0; stuffedBooleans < PropertyType.getPayloadSizeLongs(); ++stuffedBooleans) {
                txNode.setProperty("boolean" + stuffedBooleans, (Object)(stuffedBooleans % 2 == 0 ? 1 : 0));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("theExraOne", (Object)true);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < stuffedBooleans; ++i) {
                Assertions.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)txNode.removeProperty("boolean" + i));
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (i = 0; i < stuffedBooleans; ++i) {
                Assertions.assertFalse((boolean)txNode.hasProperty("boolean" + i));
            }
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)txNode.getProperty("theExraOne"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testMessWithMiddleRecordDeletes() {
        Node txNode;
        int stuffedShortStrings;
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long offset = TestPropertyBlocks.lastUsedRecordId(this.propertyStore()) + 1L;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode2 = transaction.getNodeById(node.getId());
            for (stuffedShortStrings = 0; stuffedShortStrings < 3 * PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
                txNode2.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        List<Pair<String, Object>> middleRecordProps = this.getPropertiesFromRecord(offset + 1L);
        Pair<String, Object> secondBlockInMiddleRecord = middleRecordProps.get(1);
        Pair<String, Object> thirdBlockInMiddleRecord = middleRecordProps.get(2);
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)secondBlockInMiddleRecord.getTwo(), (Object)txNode.removeProperty((String)secondBlockInMiddleRecord.getOne()));
            Assertions.assertEquals((Object)thirdBlockInMiddleRecord.getTwo(), (Object)txNode.removeProperty((String)thirdBlockInMiddleRecord.getOne()));
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (int i = 0; i < stuffedShortStrings; ++i) {
                if (secondBlockInMiddleRecord.getTwo().equals(String.valueOf(i)) || thirdBlockInMiddleRecord.getTwo().equals(String.valueOf(i))) {
                    Assertions.assertFalse((boolean)txNode.hasProperty("shortString" + i));
                    continue;
                }
                Assertions.assertEquals((Object)String.valueOf(i), (Object)txNode.getProperty("shortString" + i));
            }
            int deletedProps = 0;
            for (Pair<String, Object> prop : middleRecordProps) {
                String name = (String)prop.getOne();
                if (!txNode.hasProperty(name)) continue;
                ++deletedProps;
                txNode.removeProperty(name);
            }
            Assertions.assertEquals((int)(PropertyType.getPayloadSizeLongs() - 2), (int)deletedProps);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            middleRecordProps.forEach(nameAndValue -> Assertions.assertFalse((boolean)txNode.hasProperty((String)nameAndValue.getOne())));
            this.getPropertiesFromRecord(offset).forEach(nameAndValue -> {
                String name = (String)nameAndValue.getOne();
                Object value = nameAndValue.getTwo();
                Assertions.assertEquals((Object)value, (Object)txNode.removeProperty(name));
            });
            this.getPropertiesFromRecord(offset + 2L).forEach(nameAndValue -> {
                String name = (String)nameAndValue.getOne();
                Object value = nameAndValue.getTwo();
                Assertions.assertEquals((Object)value, (Object)txNode.removeProperty(name));
            });
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void mixAndPackDifferentTypes() {
        int stuffedShortStrings;
        Node txNode;
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            for (stuffedShortStrings = 0; stuffedShortStrings < PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
                txNode.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.removeProperty("shortString0");
            txNode.removeProperty("shortString2");
            txNode.setProperty("theDoubleOne", (Object)-1.0);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            for (int i = 0; i < stuffedShortStrings; ++i) {
                if (i == 0) {
                    Assertions.assertFalse((boolean)txNode.hasProperty("shortString" + i));
                    continue;
                }
                if (i == 2) {
                    Assertions.assertFalse((boolean)txNode.hasProperty("shortString" + i));
                    continue;
                }
                Assertions.assertEquals((Object)String.valueOf(i), (Object)txNode.getProperty("shortString" + i));
            }
            Assertions.assertEquals((Object)-1.0, (Object)txNode.getProperty("theDoubleOne"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testAdditionsHappenAtTheFirstRecordIfFits1() {
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("int1", (Object)1);
            txNode.setProperty("double1", (Object)1.0);
            txNode.setProperty("int2", (Object)2);
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).removeProperty("double1");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("double2", (Object)1.0);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("paddingBoolean", (Object)false);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    void testAdditionHappensInTheMiddleIfItFits() {
        Node txNode;
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("int1", (Object)1);
            txNode.setProperty("double1", (Object)1.0);
            txNode.setProperty("int2", (Object)2);
            for (int stuffedShortStrings = 0; stuffedShortStrings < PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
                txNode.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.removeProperty("shortString1");
            txNode.setProperty("int3", (Object)3);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    void testChangePropertyType() {
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            for (int stuffedShortStrings = 0; stuffedShortStrings < PropertyType.getPayloadSizeLongs(); ++stuffedShortStrings) {
                txNode.setProperty("shortString" + stuffedShortStrings, (Object)String.valueOf(stuffedShortStrings));
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("shortString1", (Object)1.0);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testRevertOverflowingChange() {
        long valueRecordsInUseAtStart;
        long recordsInUseAtStart;
        Relationship rel;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            rel = transaction.createNode().createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"INVALIDATES"));
            recordsInUseAtStart = this.propertyRecordsInUse();
            valueRecordsInUseAtStart = this.dynamicArrayRecordsInUse();
            rel.setProperty("theByte", (Object)-8);
            rel.setProperty("theDoubleThatGrows", (Object)Math.PI);
            rel.setProperty("theInteger", (Object)-444345);
            rel.setProperty("theDoubleThatGrows", (Object)new long[]{Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE});
            rel.setProperty("theDoubleThatGrows", (Object)Math.E);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
            Assertions.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicArrayRecordsInUse());
            Relationship txRel = transaction.getRelationshipById(rel.getId());
            Assertions.assertEquals((Object)-8, (Object)txRel.getProperty("theByte"));
            Assertions.assertEquals((Object)-444345, (Object)txRel.getProperty("theInteger"));
            Assertions.assertEquals((Object)Math.E, (Object)txRel.getProperty("theDoubleThatGrows"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testYoYoArrayPropertyWithinTx() {
        this.testArrayBase(false);
    }

    @Test
    void testYoYoArrayPropertyOverTxs() {
        this.testArrayBase(true);
    }

    private void testArrayBase(boolean withNewTx) {
        Relationship rel;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            rel = transaction.createNode().createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"LOCKS"));
            transaction.commit();
        }
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long valueRecordsInUseAtStart = this.dynamicArrayRecordsInUse();
        ArrayList<Long> theData = new ArrayList<Long>();
        Transaction tx = this.getGraphDb().beginTx();
        for (int i = 0; i < PropertyType.getPayloadSizeLongs() - 1; ++i) {
            theData.add(Long.MIN_VALUE);
            Long[] value = theData.toArray(new Long[0]);
            tx.getRelationshipById(rel.getId()).setProperty("yoyo", (Object)value);
            if (!withNewTx) continue;
            tx.commit();
            tx = this.getGraphDb().beginTx();
            Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
            Assertions.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicArrayRecordsInUse());
        }
        tx.commit();
        theData.add(Long.MIN_VALUE);
        Long[] value = theData.toArray(new Long[0]);
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getRelationshipById(rel.getId()).setProperty("yoyo", (Object)value);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
            Assertions.assertEquals((long)(valueRecordsInUseAtStart + 1L), (long)this.dynamicArrayRecordsInUse());
            transaction.getRelationshipById(rel.getId()).setProperty("filler", (Object)new long[]{Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE});
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    void testRemoveZigZag() {
        int j;
        int i;
        Relationship txRel;
        int propRecCount;
        long recordsInUseAtStart;
        Relationship rel;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            rel = transaction.createNode().createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"LOCKS"));
            recordsInUseAtStart = this.propertyRecordsInUse();
            for (propRecCount = 1; propRecCount <= 3; ++propRecCount) {
                for (int i2 = 1; i2 <= PropertyType.getPayloadSizeLongs(); ++i2) {
                    rel.setProperty("int" + (propRecCount * 10 + i2), (Object)(propRecCount * 10 + i2));
                }
            }
            transaction.commit();
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            txRel = transaction.getRelationshipById(rel.getId());
            for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
                for (j = 1; j < propRecCount; ++j) {
                    Assertions.assertEquals((Object)(j * 10 + i), (Object)txRel.removeProperty("int" + (j * 10 + i)));
                    if (i == PropertyType.getPayloadSize() - 1 && j != propRecCount - 1) {
                        Assertions.assertEquals((long)(recordsInUseAtStart + (long)(propRecCount - j)), (long)this.propertyRecordsInUse());
                        continue;
                    }
                    if (i == PropertyType.getPayloadSize() - 1 && j == propRecCount - 1) {
                        Assertions.assertEquals((long)recordsInUseAtStart, (long)this.propertyRecordsInUse());
                        continue;
                    }
                    Assertions.assertEquals((long)(recordsInUseAtStart + 3L), (long)this.propertyRecordsInUse());
                }
            }
            for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
                for (j = 1; j < propRecCount; ++j) {
                    Assertions.assertFalse((boolean)txRel.hasProperty("int" + (j * 10 + i)));
                }
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txRel = transaction.getRelationshipById(rel.getId());
            for (i = 1; i <= PropertyType.getPayloadSizeLongs(); ++i) {
                for (j = 1; j < propRecCount; ++j) {
                    Assertions.assertFalse((boolean)txRel.hasProperty("int" + (j * 10 + i)));
                }
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)recordsInUseAtStart, (long)this.propertyRecordsInUse());
    }

    @Test
    void testSetWithSameValue() {
        Node txNode;
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("rev_pos", (Object)"40000633e7ad67ff");
            Assertions.assertEquals((Object)"40000633e7ad67ff", (Object)txNode.getProperty("rev_pos"));
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("rev_pos", (Object)"40000633e7ad67ef");
            Assertions.assertEquals((Object)"40000633e7ad67ef", (Object)txNode.getProperty("rev_pos"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void testStringBase(boolean withNewTx) {
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        long valueRecordsInUseAtStart = this.dynamicStringRecordsInUse();
        Object data = "0";
        int counter = 1;
        Transaction tx = this.getGraphDb().beginTx();
        while (this.dynamicStringRecordsInUse() == valueRecordsInUseAtStart) {
            data = (String)data + counter++;
            tx.getNodeById(node.getId()).setProperty("yoyo", data);
            if (!withNewTx) continue;
            tx.commit();
            tx = this.getGraphDb().beginTx();
            Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        }
        tx.commit();
        data = ((String)data).substring(0, ((String)data).length() - 2);
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(node.getId()).setProperty("yoyo", data);
            transaction.commit();
        }
        Assertions.assertEquals((long)valueRecordsInUseAtStart, (long)this.dynamicStringRecordsInUse());
        Assertions.assertEquals((long)(recordsInUseAtStart + 1L), (long)this.propertyRecordsInUse());
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("fillerBoolean", (Object)true);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
    }

    @Test
    void testStringWithTx() {
        this.testStringBase(true);
    }

    @Test
    void testRemoveFirstOfTwo() {
        Node txNode;
        Node node = this.createNode();
        long recordsInUseAtStart = this.propertyRecordsInUse();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("Double1", (Object)1.0);
            txNode.setProperty("Int1", (Object)1);
            txNode.setProperty("Int2", (Object)2);
            txNode.setProperty("Int2", (Object)1.2);
            txNode.setProperty("Int2", (Object)2);
            txNode.setProperty("Double3", (Object)3.0);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            txNode = transaction.getNodeById(node.getId());
            Assertions.assertEquals((long)(recordsInUseAtStart + 2L), (long)this.propertyRecordsInUse());
            Assertions.assertEquals((Object)1.0, (Object)txNode.getProperty("Double1"));
            Assertions.assertEquals((Object)1, (Object)txNode.getProperty("Int1"));
            Assertions.assertEquals((Object)2, (Object)txNode.getProperty("Int2"));
            Assertions.assertEquals((Object)3.0, (Object)txNode.getProperty("Double3"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void deleteNodeWithNewPropertyRecordShouldFreeTheNewRecord() {
        long propcount = this.propertyRecordsInUse();
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Node txNode = transaction.getNodeById(node.getId());
            txNode.setProperty("one", (Object)1);
            txNode.setProperty("two", (Object)2);
            txNode.setProperty("three", (Object)3);
            txNode.setProperty("four", (Object)4);
            transaction.commit();
        }
        Assertions.assertEquals((long)(propcount + 1L), (long)this.propertyRecordsInUse(), (String)"Invalid assumption: property record count");
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).setProperty("final", (Object)666);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)(propcount + 2L), (long)this.propertyRecordsInUse(), (String)"Invalid assumption: property record count");
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node.getId()).delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Assertions.assertEquals((long)propcount, (long)this.propertyRecordsInUse(), (String)"All property records should be freed");
    }
}

