/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Duration;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class VolumeBasedCheckpointIT {
    private static final int WAIT_TIMEOUT_MINUTES = 10;
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;

    VolumeBasedCheckpointIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @Test
    void checkpointOnVolumeThresholdSingleLogFile() {
        Config volumeCheckpointConfig = Config.newBuilder().set(GraphDatabaseSettings.check_point_policy, (Object)GraphDatabaseSettings.CheckpointPolicy.VOLUME).set(GraphDatabaseSettings.check_point_interval_volume, (Object)ByteUnit.kibiBytes((long)100L)).build();
        this.dbms = this.startDbms(volumeCheckpointConfig);
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.dbms.database("neo4j");
        CheckPointer checkPointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        TransactionId lastCheckpointedTransactionId = checkPointer.latestCheckPointInfo().checkpointedTransactionId();
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode();
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)100L))));
            transaction.commit();
        }
        Awaitility.await().atMost(Duration.ofSeconds(10L)).untilAsserted(() -> Assertions.assertThat((long)checkPointer.latestCheckPointInfo().checkpointedTransactionId().transactionId()).isGreaterThan(lastCheckpointedTransactionId.transactionId()));
    }

    @Test
    void checkpointOnVolumeThresholdMultipleLogFiles() {
        Config volumeCheckpointConfig = Config.newBuilder().set(GraphDatabaseSettings.check_point_policy, (Object)GraphDatabaseSettings.CheckpointPolicy.VOLUME).set(GraphDatabaseSettings.check_point_interval_volume, (Object)ByteUnit.mebiBytes((long)2L)).set(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)128L)).build();
        this.dbms = this.startDbms(volumeCheckpointConfig);
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.dbms.database("neo4j");
        CheckPointer checkPointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        TransactionId lastCheckpointedTransactionId = checkPointer.latestCheckPointInfo().checkpointedTransactionId();
        for (int i = 0; i < 1024; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = transaction.createNode();
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)128L))));
                transaction.commit();
                continue;
            }
        }
        Awaitility.await().atMost(Duration.ofMinutes(10L)).untilAsserted(() -> Assertions.assertThat((long)checkPointer.latestCheckPointInfo().checkpointedTransactionId().transactionId()).isGreaterThan(lastCheckpointedTransactionId.transactionId()));
    }

    @Test
    void checkpointOnVolumeSplitBetweenLogFiles() {
        Node node;
        Config volumeCheckpointConfig = Config.newBuilder().set(GraphDatabaseSettings.check_point_policy, (Object)GraphDatabaseSettings.CheckpointPolicy.VOLUME).set(GraphDatabaseSettings.check_point_interval_volume, (Object)ByteUnit.kibiBytes((long)180L)).set(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)128L)).build();
        this.dbms = this.startDbms(volumeCheckpointConfig);
        GraphDatabaseAPI database = (GraphDatabaseAPI)this.dbms.database("neo4j");
        CheckPointer checkPointer = (CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class);
        TransactionId lastCheckpointedTransactionId = checkPointer.latestCheckPointInfo().checkpointedTransactionId();
        try (Transaction transaction = database.beginTx();){
            node = transaction.createNode();
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)128L))));
            transaction.commit();
        }
        transaction = database.beginTx();
        try {
            node = transaction.createNode();
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)((int)ByteUnit.kibiBytes((long)64L))));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        Awaitility.await().atMost(Duration.ofSeconds(10L)).untilAsserted(() -> Assertions.assertThat((long)checkPointer.latestCheckPointInfo().checkpointedTransactionId().transactionId()).isGreaterThan(lastCheckpointedTransactionId.transactionId()));
    }

    private DatabaseManagementService startDbms(Config config) {
        return new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(config).build();
    }
}

