/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DetachedCheckpointLogEntryParserV50Test {
    private static final StoreId TEST_STORE_ID = new StoreId(1L, 1L, "engine-1", "format-1", 1, 1);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    DetachedCheckpointLogEntryParserV50Test() {
    }

    @Test
    void writeAndParseCheckpointKernelVersion() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryParserV50Test.writeCheckpoint((WritableChecksumChannel)writeChannel, KernelVersion.V5_0, StringUtils.repeat((String)"c", (int)1024));
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.LATEST_KERNEL_VERSION);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), -1L, -1, path, ChannelNativeAccessor.EMPTY_ACCESSOR, DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                LogEntryDetachedCheckpointV5_0 checkpointV50 = this.readCheckpoint(entryReader, (ReadableClosablePositionAwareChecksumChannel)readChannel);
                Assertions.assertEquals((byte)9, (byte)checkpointV50.getType());
                Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)checkpointV50.kernelVersion());
                Assertions.assertEquals((Object)new LogPosition(1L, 2L), (Object)checkpointV50.getLogPosition());
                Assertions.assertEquals((Object)TEST_STORE_ID, (Object)checkpointV50.getStoreId());
                Assertions.assertEquals((Object)new TransactionId(100L, 101, 102L, -1L), (Object)checkpointV50.getTransactionId());
            }
        }
    }

    @Test
    void failToParse50CheckpointWithOlderKernelVersion() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryParserV50Test.writeCheckpoint((WritableChecksumChannel)writeChannel, KernelVersion.V4_4, StringUtils.repeat((String)"c", (int)1024));
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.LATEST_KERNEL_VERSION);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), 1L, 2, path, ChannelNativeAccessor.EMPTY_ACCESSOR, DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                Assertions.assertThrows(IOException.class, () -> this.readCheckpoint(entryReader, (ReadableClosablePositionAwareChecksumChannel)readChannel));
            }
        }
    }

    private LogEntryDetachedCheckpointV5_0 readCheckpoint(VersionAwareLogEntryReader entryReader, ReadableClosablePositionAwareChecksumChannel readChannel) throws IOException {
        return (LogEntryDetachedCheckpointV5_0)entryReader.readLogEntry(readChannel);
    }

    private static void writeCheckpoint(WritableChecksumChannel channel, KernelVersion kernelVersion, String reason) throws IOException {
        LogPosition logPosition = new LogPosition(1L, 2L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L, 103L);
        DetachedCheckpointLogEntryParserV50Test.writeCheckPointEntry(channel, kernelVersion, transactionId, logPosition, Instant.ofEpochMilli(1L), TEST_STORE_ID, reason);
    }

    private static void writeCheckPointEntry(WritableChecksumChannel channel, KernelVersion kernelVersion, TransactionId transactionId, LogPosition logPosition, Instant checkpointTime, StoreId storeId, String reason) throws IOException {
        channel.put(kernelVersion.version()).put((byte)9);
        byte[] storeIdBuffer = new byte[64];
        StoreIdSerialization.serializeWithFixedSize((StoreId)storeId, (ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        byte[] reasonBytes = reason.getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 116));
        byte[] descriptionBytes = new byte[116];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset()).putLong(checkpointTime.toEpochMilli()).put(storeIdBuffer, storeIdBuffer.length).putLong(transactionId.transactionId()).putInt(transactionId.checksum()).putLong(transactionId.commitTimestamp()).putShort(length).put(descriptionBytes, descriptionBytes.length);
        channel.putChecksum();
    }
}

