/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v56.DetachedCheckpointLogEntryWriterV5_6;
import org.neo4j.kernel.impl.transaction.log.entry.v56.LogEntryDetachedCheckpointV5_6;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DetachedCheckpointLogEntryParserV56Test {
    private static final StoreId TEST_STORE_ID = new StoreId(1L, 1L, "engine-1", "format-1", 1, 1);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    DetachedCheckpointLogEntryParserV56Test() {
    }

    @Test
    void writeAndParseCheckpointKernelVersion() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryParserV56Test.writeCheckpoint((WritableChecksumChannel)writeChannel, KernelVersion.V5_6, StringUtils.repeat((String)"c", (int)1024));
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.LATEST_KERNEL_VERSION);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), -1L, -1, path, ChannelNativeAccessor.EMPTY_ACCESSOR, DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                LogEntryDetachedCheckpointV5_6 checkpointV56 = this.readCheckpoint(entryReader, (ReadableClosablePositionAwareChecksumChannel)readChannel);
                Assertions.assertEquals((byte)12, (byte)checkpointV56.getType());
                Assertions.assertEquals((Object)KernelVersion.V5_6, (Object)checkpointV56.kernelVersion());
                Assertions.assertEquals((Object)new LogPosition(1L, 2L), (Object)checkpointV56.getLogPosition());
                Assertions.assertEquals((Object)TEST_STORE_ID, (Object)checkpointV56.getStoreId());
                Assertions.assertEquals((Object)new TransactionId(100L, 101, 102L, 103L), (Object)checkpointV56.getTransactionId());
            }
        }
    }

    @Test
    void failToParse50CheckpointWithOlderKernelVersion() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableChecksumChannel writeChannel = new PhysicalFlushableChecksumChannel(storeChannel, (ScopedBuffer)buffer);){
                DetachedCheckpointLogEntryParserV56Test.writeCheckpoint((WritableChecksumChannel)writeChannel, KernelVersion.V4_4, StringUtils.repeat((String)"c", (int)1024));
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.LATEST_KERNEL_VERSION);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), 1L, 2, path, ChannelNativeAccessor.EMPTY_ACCESSOR, DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                Assertions.assertThrows(IOException.class, () -> this.readCheckpoint(entryReader, (ReadableClosablePositionAwareChecksumChannel)readChannel));
            }
        }
    }

    private LogEntryDetachedCheckpointV5_6 readCheckpoint(VersionAwareLogEntryReader entryReader, ReadableClosablePositionAwareChecksumChannel readChannel) throws IOException {
        return (LogEntryDetachedCheckpointV5_6)entryReader.readLogEntry(readChannel);
    }

    private static void writeCheckpoint(WritableChecksumChannel channel, KernelVersion kernelVersion, String reason) throws IOException {
        LogPosition logPosition = new LogPosition(1L, 2L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L, 103L);
        DetachedCheckpointLogEntryParserV56Test.writeCheckPointEntry(channel, kernelVersion, transactionId, logPosition, Instant.ofEpochMilli(1L), TEST_STORE_ID, reason);
    }

    private static void writeCheckPointEntry(WritableChecksumChannel channel, KernelVersion kernelVersion, TransactionId transactionId, LogPosition logPosition, Instant checkpointTime, StoreId storeId, String reason) throws IOException {
        new DetachedCheckpointLogEntryWriterV5_6(channel).writeCheckPointEntry(transactionId, kernelVersion, logPosition, checkpointTime, storeId, reason);
    }
}

