/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.state.storeview.TokenIndexScanIdIterator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class TokenIndexScanIdIteratorTest {
    @Inject
    GraphDatabaseAPI db;
    @Inject
    IndexingService indexingService;

    TokenIndexScanIdIteratorTest() {
    }

    @Test
    void shouldFindNodesWithAnyOfGivenLabels() throws Exception {
        IndexDescriptor index;
        int labelId1 = 3;
        int labelId2 = 5;
        int labelId3 = 13;
        try (Transaction tx = this.db.beginTx();){
            index = ((IndexDefinitionImpl)StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).filter(IndexDefinition::isNodeIndex).findFirst().get()).getIndexReference();
        }
        IndexProxy indexProxy = this.indexingService.getIndexProxy(index);
        try (IndexUpdater indexUpdater = indexProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL_CONTEXT, false);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)2L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId2}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)1L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)4L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId3}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)5L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1, labelId2, labelId3}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)3L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId1}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)7L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId2}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)8L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId3}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)6L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId2}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)9L, (SchemaDescriptorSupplier)index, (long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{labelId3}));
        }
        try (TokenIndexReader indexReader = indexProxy.newTokenReader();){
            Assertions.assertThat((long[])TokenIndexScanIdIteratorTest.findAllWithTokens(indexReader, new int[]{labelId1, labelId2})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L});
            Assertions.assertThat((long[])TokenIndexScanIdIteratorTest.findAllWithTokens(indexReader, new int[]{labelId1, labelId3})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L, 5L, 8L, 9L});
            Assertions.assertThat((long[])TokenIndexScanIdIteratorTest.findAllWithTokens(indexReader, new int[]{labelId1, labelId2, labelId3})).isEqualTo((Object)new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        }
    }

    private static long[] findAllWithTokens(TokenIndexReader indexReader, int[] tokens) {
        TokenIndexScanIdIterator iter = new TokenIndexScanIdIterator(indexReader, tokens, CursorContext.NULL_CONTEXT);
        MutableLongList found = LongLists.mutable.empty();
        while (iter.hasNext()) {
            found.add(iter.next());
        }
        return found.toArray(new long[0]);
    }
}

