/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.recovery.RecoveryHelpers;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class RecoveryOldAndUpgradedVersionsIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;
    private TestDatabaseManagementServiceBuilder builder;
    private DatabaseManagementService managementService;

    RecoveryOldAndUpgradedVersionsIT() {
    }

    @AfterEach
    void shutdown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionNoCheckpoints(String dbName) throws Throwable {
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        DatabaseLayout dbLayout = this.neo4jLayout.databaseLayout(dbName);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RecoveryHelpers.logsContainCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem));
        this.createBuilder();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersion(db, KernelVersion.V5_0);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionNoCheckpointsAndContainsUpgradeTransaction(String dbName) throws Throwable {
        Assumptions.assumeTrue((boolean)LatestVersions.LATEST_KERNEL_VERSION.isGreaterThan(KernelVersion.V5_0));
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        DatabaseLayout dbLayout = this.neo4jLayout.databaseLayout(dbName);
        this.createBuilder();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.assertKernelVersion(db, LatestVersions.LATEST_KERNEL_VERSION);
        this.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RecoveryHelpers.logsContainCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem));
        this.managementService = this.builder.build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersion(db, LatestVersions.LATEST_KERNEL_VERSION);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionOneCheckpoint(String dbName) throws Throwable {
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        DatabaseLayout dbLayout = this.neo4jLayout.databaseLayout(dbName);
        this.createBuilderNoAutomaticUpgrade();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.assertKernelVersion(db, KernelVersion.V5_0);
        this.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem).kernelVersion()).isEqualTo((Object)KernelVersion.V5_0);
        this.managementService = this.builder.build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersion(db, KernelVersion.V5_0);
    }

    @ParameterizedTest
    @ValueSource(strings={"neo4j", "system"})
    void recoverDatabaseOnOldVersionOneCheckpointAndContainsUpgradeTransaction(String dbName) throws Throwable {
        Assumptions.assumeTrue((boolean)LatestVersions.LATEST_KERNEL_VERSION.isGreaterThan(KernelVersion.V5_0));
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        DatabaseLayout dbLayout = this.neo4jLayout.databaseLayout(dbName);
        this.createBuilder();
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        this.assertKernelVersion(db, LatestVersions.LATEST_KERNEL_VERSION);
        this.shutdown();
        RecoveryHelpers.removeLastCheckpointRecordFromLastLogFile((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem);
        Assertions.assertThat((Comparable)RecoveryHelpers.getLatestCheckpoint((DatabaseLayout)dbLayout, (FileSystemAbstraction)this.fileSystem).kernelVersion()).isEqualTo((Object)KernelVersion.V5_0);
        this.managementService = this.builder.build();
        db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersion(db, LatestVersions.LATEST_KERNEL_VERSION);
    }

    @Test
    void recoverOldSystemDatabaseNoTransactionLogs() throws Throwable {
        String dbName = "system";
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        DatabaseLayout dbLayout = this.neo4jLayout.databaseLayout(dbName);
        this.removeTransactionLogs(dbLayout);
        this.createBuilderNoAutomaticUpgrade();
        this.builder = this.builder.setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false);
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersion(db, LatestVersions.LATEST_KERNEL_VERSION);
    }

    @Test
    void recoverOldDatabaseNoTransactionLogs() throws Throwable {
        String dbName = "neo4j";
        ZippedStoreCommunity.REC_AF11_V50_ALL.unzip(this.neo4jLayout.homeDirectory());
        DatabaseLayout dbLayout = this.neo4jLayout.databaseLayout(dbName);
        this.removeTransactionLogs(dbLayout);
        this.createBuilderNoAutomaticUpgrade();
        this.builder = this.builder.setConfig(GraphDatabaseSettings.fail_on_missing_files, (Object)false);
        this.managementService = this.builder.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.managementService.database(dbName);
        this.assertKernelVersion(db, KernelVersion.V5_0);
    }

    private void assertKernelVersion(GraphDatabaseAPI db, KernelVersion expectedVersion) {
        KernelVersionProvider kernelVersionProvider = (KernelVersionProvider)db.getDependencyResolver().resolveDependency(KernelVersionProvider.class);
        Assertions.assertThat((Comparable)kernelVersionProvider.kernelVersion()).isEqualTo((Object)expectedVersion);
    }

    private void removeTransactionLogs(DatabaseLayout dbLayout) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)dbLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fileSystem).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)dbLayout, null).commandReaderFactory()).build();
        for (Path logFile : this.fileSystem.listFiles(logFiles.logFilesDirectory())) {
            this.fileSystem.deleteFile(logFile);
        }
    }

    private void createBuilder() {
        if (this.builder == null) {
            this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all");
        }
    }

    private void createBuilderNoAutomaticUpgrade() {
        if (this.builder == null) {
            this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).setConfig(GraphDatabaseSettings.keep_logical_logs, (Object)"keep_all").setConfig(GraphDatabaseInternalSettings.allow_single_automatic_upgrade, (Object)false);
        }
    }
}

