/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.SchemaAcceptanceTestBase;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.EquivalentSchemaRuleAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.IndexWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.kernel.impl.locking.forseti.ForsetiClient;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorsExtension;
import org.neo4j.util.concurrent.BinaryLatch;

@ImpermanentDbmsExtension(configurationCallback="configure")
@ExtendWith(value={OtherThreadExtension.class})
class SchemaAcceptanceTest
extends SchemaAcceptanceTestBase {
    @Inject
    private DbmsController controller;
    @Inject
    protected GraphDatabaseService db;
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private OtherThread otherThread;
    private final Label otherLabel = Label.label((String)"MY_OTHER_LABEL");
    private final RelationshipType relType = RelationshipType.withName((String)"MY_REL_TYPE");
    private final RelationshipType otherRelType = RelationshipType.withName((String)"MY_OTHER_REL_TYPE");
    private final RelationshipType thirdRelType = RelationshipType.withName((String)"MY_THIRD_REL_TYPE");
    private final String propertyKey = "my_property_key";
    private final String secondPropertyKey = "my_second_property_key";
    private final String nameA = "index a";
    private final String nameB = "index b";
    private final AtomicBoolean trapPopulation = new AtomicBoolean();
    private final Barrier.Control populationScanFinished = new Barrier.Control();

    SchemaAcceptanceTest() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        Monitors monitors = new Monitors();
        IndexMonitor.MonitorAdapter trappingMonitor = new IndexMonitor.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                if (SchemaAcceptanceTest.this.trapPopulation.get()) {
                    SchemaAcceptanceTest.this.populationScanFinished.reached();
                }
            }
        };
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        builder.setMonitors(monitors);
        builder.setConfig(GraphDatabaseInternalSettings.rel_unique_constraints, (Object)true);
    }

    @BeforeEach
    void beforeEach() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @Test
    void addingAnIndexingRuleShouldSucceed() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.label)).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @Test
    void addingACompositeIndexingRuleShouldSucceed() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key", "my_second_property_key");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.label)).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @ParameterizedTest
    @EnumSource(value=AnyTokens.class)
    void addingTokenIndexRuleShouldSucceed(AnyTokens tokens) {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, tokens, null);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @Test
    void addingNamedIndexRuleShouldSucceed() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, "MyIndex", this.label, "my_property_key");
        Assertions.assertThat((String)index.getName()).isEqualTo("MyIndex");
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(transaction, this.label)).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @ParameterizedTest
    @EnumSource(value=AnyTokens.class)
    void addingNamedTokenIndexRuleShouldSucceed(AnyTokens tokens) {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, tokens, "MyIndex");
        Assertions.assertThat((String)index.getName()).isEqualTo("MyIndex");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfEquivalentIndexExist(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(this.label).on("my_property_key").withName("name").create(), schema1 -> schema1.indexFor(this.label).on("my_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<EquivalentSchemaRuleAlreadyExistsException> expectedCause = EquivalentSchemaRuleAlreadyExistsException.class;
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, "An equivalent index already exists", "Index(", "id=", "name='name'", "type='RANGE'", "schema=(:MY_LABEL {my_property_key})", "indexProvider='range-1.0'");
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfEquivalentTokenIndexExist(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(AnyTokens.ANY_LABELS).withName("name").create(), schema1 -> schema1.indexFor(AnyTokens.ANY_LABELS).withName("name").create(), ConstraintViolationException.class);
        Class<EquivalentSchemaRuleAlreadyExistsException> expectedCause = EquivalentSchemaRuleAlreadyExistsException.class;
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, "An equivalent index already exists", "Index(", "id=", "name='name'", "type='LOOKUP'", "schema=(:<any-labels>)", "indexProvider='token-lookup-1.0'");
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfEquivalentUniquenessConstraintExist(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("name").create(), schema1 -> schema1.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<EquivalentSchemaRuleAlreadyExistsException> expectedCause = EquivalentSchemaRuleAlreadyExistsException.class;
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, "An equivalent constraint already exists, 'Constraint( ", "name='name', type='UNIQUENESS', schema=(:MY_LABEL {my_property_key}), ownedIndex=");
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfSchemaAlreadyIndexedWhenCreatingIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(this.label).on("my_property_key").withName("name").create(), schema1 -> schema1.indexFor(this.label).on("my_property_key").withName("otherName").create(), ConstraintViolationException.class);
        Class<AlreadyIndexedException> expectedCause = AlreadyIndexedException.class;
        String expectedMessage = "There already exists an index (:MY_LABEL {my_property_key}).";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfSchemaAlreadyIndexedWhenCreatingUniquenessConstraint(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(this.label).on("my_property_key").withName("name").create(), schema1 -> schema1.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("otherName").create(), ConstraintViolationException.class);
        Class<AlreadyIndexedException> expectedCause = AlreadyIndexedException.class;
        String expectedMessage = "There already exists an index (:MY_LABEL {my_property_key}). A constraint cannot be created until the index has been dropped.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfSchemaAlreadyUniquenessConstrainedWhenCreatingIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("name").create(), schema1 -> schema1.indexFor(this.label).on("my_property_key").withName("otherName").create(), ConstraintViolationException.class);
        Class<AlreadyConstrainedException> expectedCause = AlreadyConstrainedException.class;
        String expectedMessage = "There is a uniqueness constraint on (:MY_LABEL {my_property_key}), so an index is already created that matches this.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfSchemaAlreadyUniquenessConstrainedWhenCreatingUniquenessConstraint(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("name").create(), schema1 -> schema1.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("otherName").create(), ConstraintViolationException.class);
        Class<AlreadyConstrainedException> expectedCause = AlreadyConstrainedException.class;
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, "Constraint already exists: Constraint( ", "name='name', type='UNIQUENESS', schema=(:MY_LABEL {my_property_key}), ownedIndex=");
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfIndexWithNameExistsWhenCreatingIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(this.label).on("my_property_key").withName("name").create(), schema1 -> schema1.indexFor(this.label).on("my_second_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<IndexWithNameAlreadyExistsException> expectedCause = IndexWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists an index called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfTokenIndexWithNameExistsWhenCreatingTokenIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(AnyTokens.ANY_LABELS).withName("name").create(), schema1 -> schema1.indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).withName("name").create(), ConstraintViolationException.class);
        Class<IndexWithNameAlreadyExistsException> expectedCause = IndexWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists an index called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfPropertyIndexWithNameExistsWhenCreatingTokenIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(this.label).on("my_property_key").withName("name").create(), schema1 -> schema1.indexFor(AnyTokens.ANY_LABELS).withName("name").create(), ConstraintViolationException.class);
        Class<IndexWithNameAlreadyExistsException> expectedCause = IndexWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists an index called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfTokenIndexWithNameExistsWhenCreatingPropertyIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(AnyTokens.ANY_LABELS).withName("name").create(), schema1 -> schema1.indexFor(this.label).on("my_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<IndexWithNameAlreadyExistsException> expectedCause = IndexWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists an index called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfIndexWithNameExistsWhenCreatingUniquenessConstraint(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.indexFor(this.label).on("my_property_key").withName("name").create(), schema1 -> schema1.constraintFor(this.label).assertPropertyIsUnique("my_second_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<IndexWithNameAlreadyExistsException> expectedCause = IndexWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists an index called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfConstraintWithNameExistsWhenCreatingIndex(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("name").create(), schema1 -> schema1.indexFor(this.label).on("my_second_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<ConstraintWithNameAlreadyExistsException> expectedCause = ConstraintWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists a constraint called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @ParameterizedTest
    @EnumSource(value=SchemaAcceptanceTestBase.SchemaTxStrategy.class)
    void shouldThrowIfConstraintWithNameExistsWhenCreatingUniquenessConstraint(SchemaAcceptanceTestBase.SchemaTxStrategy txStrategy) {
        ConstraintViolationException exception = txStrategy.execute(this.db, schema -> schema.constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("name").create(), schema1 -> schema1.constraintFor(this.label).assertPropertyIsUnique("my_second_property_key").withName("name").create(), ConstraintViolationException.class);
        Class<ConstraintWithNameAlreadyExistsException> expectedCause = ConstraintWithNameAlreadyExistsException.class;
        String expectedMessage = "There already exists a constraint called 'name'.";
        SchemaAcceptanceTest.assertExpectedException(exception, expectedCause, expectedMessage);
    }

    @Test
    void droppingExistingIndexRuleShouldSucceed() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        this.dropIndex(index);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.label)).isEmpty();
        }
    }

    @ParameterizedTest
    @EnumSource(value=AnyTokens.class)
    void droppingExistingIndexRuleShouldSucceed(AnyTokens token) {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, token, null);
        this.dropIndex(index);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).isEmpty();
        }
    }

    @Test
    void droppingNonExistingIndexShouldGiveHelpfulExceptionInSameTransaction() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            index = SchemaAcceptanceTest.getIndex(tx, index.getName());
            index.drop();
            ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((IndexDefinition)index).drop());
            Assertions.assertThat((Throwable)e).hasMessageContaining("Unable to drop index: Index does not exist: Index( id=").hasMessageContaining("name='index_1efc11af', type='RANGE', schema=(:MY_LABEL {my_property_key}), indexProvider='range-1.0' )");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.label)).doesNotContain((Object[])new IndexDefinition[]{index});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=AnyTokens.class)
    void droppingNonExistingIndexShouldGiveHelpfulExceptionInSameTransaction(AnyTokens token) {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, token, null);
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().getIndexByName(index.getName());
            index.drop();
            ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((IndexDefinition)index).drop());
            Assertions.assertThat((Throwable)e).hasMessageContaining("Unable to drop index: Index does not exist: ");
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes()).doesNotContain((Object[])new IndexDefinition[]{index});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void droppingNonExistingIndexShouldGiveHelpfulExceptionInSeparateTransactions() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        this.dropIndex(index);
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> this.dropIndex(index));
        Assertions.assertThat((Throwable)e).hasMessageContaining("No index found with the name 'index_1efc11af'.");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.label)).doesNotContain((Object[])new IndexDefinition[]{index});
        }
    }

    @Test
    void awaitingIndexComingOnlineWorks() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index, 2L, TimeUnit.MINUTES);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Schema.IndexState.ONLINE, (Object)SchemaAcceptanceTest.getIndexState(tx, index));
        }
    }

    @ParameterizedTest
    @EnumSource(value=AnyTokens.class)
    void awaitingTokenIndexComingOnlineWorks(AnyTokens token) {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, token, null);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline(index, 2L, TimeUnit.MINUTES);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index)).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
    }

    @Test
    void awaitingIndexComingOnlineByNameWorks() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, "my_index", this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline("my_index", 2L, TimeUnit.MINUTES);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Schema.IndexState.ONLINE, (Object)SchemaAcceptanceTest.getIndexState(tx, index));
        }
    }

    @ParameterizedTest
    @EnumSource(value=AnyTokens.class)
    void awaitingTokenIndexComingOnlineByNameWorks(AnyTokens token) {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, token, "my_index");
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexOnline("my_index", 2L, TimeUnit.MINUTES);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index)).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
    }

    @Test
    void awaitingAllIndexesComingOnlineWorks() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        SchemaAcceptanceTest.createIndex(this.db, this.label, "other_property");
        SchemaAcceptanceTest.waitForIndex(this.db, index);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Schema.IndexState.ONLINE, (Object)SchemaAcceptanceTest.getIndexState(tx, index));
        }
    }

    @Test
    void awaitingAllIndexesComingOnlineWorksWhenThereIsTokenIndex() {
        IndexDefinition index1 = SchemaAcceptanceTest.createIndex(this.db, AnyTokens.ANY_LABELS, null);
        IndexDefinition index2 = SchemaAcceptanceTest.createIndex(this.db, AnyTokens.ANY_RELATIONSHIP_TYPES, null);
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index1)).isEqualTo((Object)Schema.IndexState.ONLINE);
            Assertions.assertThat((Comparable)tx.schema().getIndexState(index2)).isEqualTo((Object)Schema.IndexState.ONLINE);
        }
    }

    @Test
    void shouldPopulateIndex() {
        Node node = SchemaAcceptanceTest.createNode(this.db, "my_property_key", "Neo", this.label);
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        SchemaAcceptanceTest.waitForIndex(this.db, index);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.findNodesByLabelAndProperty(this.label, "my_property_key", "Neo", transaction)).containsOnly((Object[])new Node[]{node});
        }
    }

    @Test
    void shouldPopulateTokenIndex() {
        Node node = SchemaAcceptanceTest.createNode(this.db, "my_property_key", "Neo", this.label);
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, AnyTokens.ANY_LABELS, null);
        SchemaAcceptanceTest.waitForIndex(this.db, index);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((Collection)Iterators.asSet((Iterator)tx.findNodes(this.label))).containsOnly((Object[])new Node[]{node});
        }
    }

    @Test
    void recreatingDroppedIndexMustProduceNewDefinition() {
        Node node = SchemaAcceptanceTest.createNode(this.db, "my_property_key", "Neo", this.label);
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        SchemaAcceptanceTest.waitForIndex(this.db, index);
        this.dropIndex(index);
        IndexDefinition newIndex = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        NotFoundException e = (NotFoundException)org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> SchemaAcceptanceTest.waitForIndex(this.db, index));
        Assertions.assertThat((Throwable)e).hasMessageContaining("No index was found");
        SchemaAcceptanceTest.waitForIndex(this.db, newIndex);
        try (Transaction transaction = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(transaction, this.label)).contains((Object[])new IndexDefinition[]{index});
            Assertions.assertThat(SchemaAcceptanceTest.findNodesByLabelAndProperty(this.label, "my_property_key", "Neo", transaction)).contains((Object[])new Node[]{node});
            transaction.commit();
        }
    }

    private static List<Node> findNodesByLabelAndProperty(Label label, String propertyKey, String value, Transaction transaction) {
        return Iterators.asList((Iterator)transaction.findNodes(label, propertyKey, (Object)value));
    }

    @Test
    void shouldCreateUniquenessConstraint() {
        ConstraintDefinition constraint = this.createUniquenessConstraint(this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.label.name(), (Object)constraint.getLabel().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"constraint_d3208c60", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateRelUniquenessConstraint() {
        ConstraintDefinition constraint = this.createRelUniquenessConstraint(this.relType, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.RELATIONSHIP_UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.relType.name(), (Object)constraint.getRelationshipType().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"constraint_c5954bea", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateNamedUniquenessConstraint() {
        ConstraintDefinition constraint = this.createUniquenessConstraint("MyConstraint", this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.label.name(), (Object)constraint.getLabel().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"MyConstraint", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateNamedRelUniquenessConstraint() {
        ConstraintDefinition constraint = this.createRelUniquenessConstraint("MyConstraint", this.relType, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.RELATIONSHIP_UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.relType.name(), (Object)constraint.getRelationshipType().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"MyConstraint", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateUniquenessConstraintWithMultipleProperties() {
        ConstraintDefinition constraint = this.createUniquenessConstraint(this.label, "my_property_key", "my_second_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.label.name(), (Object)constraint.getLabel().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key", "my_second_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"constraint_860007cd", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateRelUniquenessConstraintWithMultipleProperties() {
        ConstraintDefinition constraint = this.createRelUniquenessConstraint(this.relType, "my_property_key", "my_second_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.RELATIONSHIP_UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.relType.name(), (Object)constraint.getRelationshipType().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key", "my_second_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"constraint_ba789ec", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateNamedUniquenessConstraintWithMultipleProperties() {
        ConstraintDefinition constraint = this.createUniquenessConstraint("MyConstraint", this.label, "my_property_key", "my_second_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.label.name(), (Object)constraint.getLabel().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key", "my_second_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"MyConstraint", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldCreateNamedRelUniquenessConstraintWithMultipleProperties() {
        ConstraintDefinition constraint = this.createRelUniquenessConstraint("MyConstraint", this.relType, "my_property_key", "my_second_property_key");
        try (Transaction tx = this.db.beginTx();){
            constraint = tx.schema().getConstraintByName(constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)ConstraintType.RELATIONSHIP_UNIQUENESS, (Object)constraint.getConstraintType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.relType.name(), (Object)constraint.getRelationshipType().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"my_property_key", "my_second_property_key"}), (Object)Iterables.asSet((Iterable)constraint.getPropertyKeys()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"MyConstraint", (Object)constraint.getName());
            tx.commit();
        }
    }

    @Test
    void shouldGetConstraintByName() {
        ConstraintDefinition expectedConstraint = this.createUniquenessConstraint("MyConstraint", this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition actualConstraint = tx.schema().getConstraintByName("MyConstraint");
            Assertions.assertThat((Object)actualConstraint).isEqualTo((Object)expectedConstraint);
            tx.commit();
        }
    }

    @Test
    void shouldListAddedConstraintsByLabel() {
        ConstraintDefinition constraint1 = this.createUniquenessConstraint(this.label, "my_property_key");
        this.createUniquenessConstraint(this.otherLabel, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getConstraints(tx, this.label)).containsOnly((Object[])new ConstraintDefinition[]{constraint1});
        }
    }

    private static Iterable<ConstraintDefinition> getConstraints(Transaction tx, Label label) {
        return tx.schema().getConstraints(label);
    }

    @Test
    void shouldListAddedConstraints() {
        ConstraintDefinition constraint1 = this.createUniquenessConstraint(this.label, "my_property_key");
        ConstraintDefinition constraint2 = this.createUniquenessConstraint(this.otherLabel, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((Iterable)tx.schema().getConstraints()).containsOnly((Object[])new ConstraintDefinition[]{constraint1, constraint2});
        }
    }

    @Test
    void shouldDropUniquenessConstraint() {
        ConstraintDefinition constraint = this.createUniquenessConstraint(this.label, "my_property_key");
        SchemaAcceptanceTest.dropConstraint(this.db, constraint);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getConstraints(tx, this.label)).isEmpty();
        }
    }

    @Test
    void addingConstraintWhenIndexAlreadyExistsGivesNiceError() {
        SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.createUniquenessConstraint(this.label, "my_property_key"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"There already exists an index (:MY_LABEL {my_property_key}). A constraint cannot be created until the index has been dropped.", (Object)e.getMessage());
    }

    @Test
    void addingUniquenessConstraintWhenDuplicateDataExistsGivesNiceError() {
        try (Transaction transaction = this.db.beginTx();){
            transaction.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)"value1");
            transaction.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)"value1");
            transaction.commit();
        }
        ConstraintViolationException e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.createUniquenessConstraint(this.label, "my_property_key"));
        Assertions.assertThat((Throwable)e).hasMessageContaining("Unable to create Constraint( name='constraint_d3208c60', type='UNIQUENESS', schema=(:MY_LABEL {my_property_key}) )");
    }

    @Test
    void addedUncommittedIndexesShouldBeVisibleWithinTheTransaction() {
        IndexDefinition indexA = SchemaAcceptanceTest.createIndex(this.db, this.label, "a");
        this.createUniquenessConstraint(this.label, "b");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes(this.label))).isEqualTo(2L);
            IndexDefinition indexC = tx.schema().indexFor(this.label).on("c").create();
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes(this.label))).isEqualTo(3L);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexA)).isEqualTo((Object)Schema.IndexState.ONLINE);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexC)).isEqualTo((Object)Schema.IndexState.POPULATING);
            Assertions.assertThat((float)tx.schema().getIndexPopulationProgress(indexA).getCompletedPercentage()).isGreaterThan(0.0f);
            Assertions.assertThat((float)tx.schema().getIndexPopulationProgress(indexC).getCompletedPercentage()).isGreaterThanOrEqualTo(0.0f);
        }
    }

    @Test
    void indexNamesMustBeUnique() {
        SchemaAcceptanceTest.createIndex(this.db, "MyIndex", this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> SchemaAcceptanceTest.createIndex(this.db, "MyIndex", this.label, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining("MyIndex");
    }

    @Test
    void indexNamesMustBeUniqueEvenWhenGenerated() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> SchemaAcceptanceTest.createIndex(this.db, index.getName(), this.otherLabel, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining(index.getName());
    }

    @Test
    void indexNamesMustBeUniqueEvenWhenGenerated2() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, "index_1efc11af", this.otherLabel, "my_second_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining(index.getName());
    }

    @Test
    void constraintNamesMustBeUnique() {
        this.createUniquenessConstraint("MyConstraint", this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.createUniquenessConstraint("MyConstraint", this.label, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining("MyConstraint");
    }

    @Test
    void cannotCreateConstraintWithSameNameAsExistingIndex() {
        SchemaAcceptanceTest.createIndex(this.db, "MySchema", this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.createUniquenessConstraint("MySchema", this.label, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining("MySchema");
    }

    @Test
    void cannotCreateIndexWithSameNameAsExistingIndexWithGeneratedName() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> SchemaAcceptanceTest.createIndex(this.db, index.getName(), this.otherLabel, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining(index.getName());
    }

    @Test
    void cannotCreateConstraintWithSameNameAsExistingIndexWithGeneratedName() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> this.createUniquenessConstraint(index.getName(), this.otherLabel, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining(index.getName());
    }

    @Test
    void cannotCreateIndexWithSameNameAsExistingConstraint() {
        this.createUniquenessConstraint("MySchema", this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> SchemaAcceptanceTest.createIndex(this.db, "MySchema", this.label, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining("MySchema");
    }

    @Test
    void cannotCreateIndexWithSameNameAsExistingConstraintWithGeneratedName() {
        ConstraintDefinition constraint = this.createUniquenessConstraint(this.label, "my_property_key");
        ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> SchemaAcceptanceTest.createIndex(this.db, constraint.getName(), this.label, "my_second_property_key"));
        Assertions.assertThat((Throwable)exception).hasMessageContaining(constraint.getName());
    }

    @Test
    void uniquenessConstraintIndexesMustBeNamedAfterTheirConstraints() {
        this.createUniquenessConstraint("MySchema", this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = SchemaAcceptanceTest.getIndex(tx, "MySchema");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isConstraintIndex());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isNodeIndex());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"MySchema", (Object)index.getName());
            tx.commit();
        }
    }

    @Test
    void indexNamesInTransactionStateMustBeUnique() {
        try (Transaction tx = this.db.beginTx();){
            String indexName = "MyIndex";
            tx.schema().indexFor(this.label).on("my_property_key").withName("MyIndex").create();
            IndexCreator creator = tx.schema().indexFor(this.otherLabel).on("my_second_property_key").withName("MyIndex");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((IndexCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining(SchemaAcceptanceTest.alreadyExistsIndexMessage("MyIndex"));
            tx.commit();
        }
    }

    @Test
    void indexNamesInTransactionStateMustBeUniqueEvenWhenGenerated() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = tx.schema().indexFor(this.label).on("my_property_key").create();
            IndexCreator creator = tx.schema().indexFor(this.otherLabel).on("my_second_property_key").withName(index.getName());
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((IndexCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining(SchemaAcceptanceTest.alreadyExistsIndexMessage(index.getName()));
            tx.commit();
        }
    }

    @Test
    void indexNamesInTransactionStateMustBeUniqueEvenWhenGenerated2() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = tx.schema().indexFor(this.otherLabel).on("my_second_property_key").withName("index_1efc11af").create();
            IndexCreator creator = tx.schema().indexFor(this.label).on("my_property_key");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((IndexCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining(SchemaAcceptanceTest.alreadyExistsIndexMessage(index.getName()));
            tx.commit();
        }
    }

    @Test
    void constraintNamesInTransactionStateMustBeUnique() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("MyConstraint").create();
            ConstraintCreator creator = tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_second_property_key").withName("MyConstraint");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining(SchemaAcceptanceTest.thereAlreadyExistsConstraintMessage("MyConstraint"));
            tx.commit();
        }
    }

    @Test
    void constraintNamesInTransactionStateMustBeUniqueEvenWhenGenerated() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").create();
            ConstraintCreator creator = tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_second_property_key").withName(constraint.getName());
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining(SchemaAcceptanceTest.thereAlreadyExistsConstraintMessage(constraint.getName()));
            tx.commit();
        }
    }

    @Test
    void constraintNamesInTransactionStateMustBeUniqueEvenWhenGenerated2() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_second_property_key").withName("constraint_d3208c60").create();
            ConstraintCreator creator = tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining(SchemaAcceptanceTest.thereAlreadyExistsConstraintMessage(constraint.getName()));
            tx.commit();
        }
    }

    @Test
    void constraintAndIndexNamesInTransactionStateMustBeUnique() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("MySchema").create();
            IndexCreator creator = tx.schema().indexFor(this.otherLabel).on("my_second_property_key").withName("MySchema");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((IndexCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining("MySchema");
            tx.commit();
        }
    }

    @Test
    void indexAndConstraintNamesInTransactionStateMustBeUnique() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(this.label).on("my_property_key").withName("MySchema").create();
            ConstraintCreator creator = tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_second_property_key").withName("MySchema");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)creator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining("MySchema");
            tx.commit();
        }
    }

    @Test
    void nodeKeyConstraintsMustNotBeAvailableInCommunityEdition() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator constraintCreator = tx.schema().constraintFor(this.label).assertPropertyIsNodeKey("my_property_key");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)constraintCreator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining("Enterprise Edition");
            tx.commit();
        }
    }

    @Test
    void relationshipKeyConstraintsMustNotBeAvailableInCommunityEdition() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator constraintCreator = tx.schema().constraintFor(this.relType).assertPropertyIsRelationshipKey("my_property_key");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)constraintCreator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining("Enterprise Edition");
            tx.commit();
        }
    }

    @Test
    void propertyExistenceConstraintsMustNotBeAvailableInCommunityEdition() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator constraintCreator = tx.schema().constraintFor(this.label).assertPropertyExists("my_property_key");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)constraintCreator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining("Enterprise Edition");
            tx.commit();
        }
    }

    @Test
    void propertyExistenceConstraintsOnRelationshipMustNotBeAvailableInCommunityEdition() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator constraintCreator = tx.schema().constraintFor(this.relType).assertPropertyExists("my_property_key");
            ConstraintViolationException exception = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> ((ConstraintCreator)constraintCreator).create());
            Assertions.assertThat((Throwable)exception).hasMessageContaining("Enterprise Edition");
            tx.commit();
        }
    }

    @Test
    void indexNamesCanContainBackTicks() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(this.label).withName("`a`b``").on("my_property_key");
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Iterable indexes = tx.schema().getIndexes();
            Assertions.assertThat((long)Iterables.count((Iterable)indexes)).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"`a`b``", (Object)((IndexDefinition)indexes.iterator().next()).getName());
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void indexTokensCanContainBackTicks() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(this.labelWithBackticks).withName("abc").on("``backticked_property_key");
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Iterable indexes = tx.schema().getIndexes();
            Assertions.assertThat((long)Iterables.count((Iterable)indexes)).isEqualTo(1L);
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)index.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.labelWithBackticks.name(), (Object)((Label)index.getLabels().iterator().next()).name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"``backticked_property_key", index.getPropertyKeys().iterator().next());
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void constraintNamesCanContainBackTicks() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.label).withName("`a`b``").assertPropertyIsUnique("my_property_key");
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Iterable indexes = tx.schema().getIndexes();
            Assertions.assertThat((long)Iterables.count((Iterable)indexes)).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"`a`b``", (Object)((IndexDefinition)indexes.iterator().next()).getName());
            Iterable constraints = tx.schema().getConstraints();
            Assertions.assertThat((long)Iterables.count((Iterable)constraints)).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"`a`b``", (Object)((ConstraintDefinition)constraints.iterator().next()).getName());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void constraintTokensCanContainBackTicks() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.labelWithBackticks).withName("abc").assertPropertyIsUnique("``backticked_property_key");
            creator.create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Iterable indexes = tx.schema().getIndexes();
            Assertions.assertThat((long)Iterables.count((Iterable)indexes)).isEqualTo(1L);
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)index.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.labelWithBackticks.name(), (Object)((Label)index.getLabels().iterator().next()).name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"``backticked_property_key", index.getPropertyKeys().iterator().next());
            Iterable constraints = tx.schema().getConstraints();
            Assertions.assertThat((long)Iterables.count((Iterable)constraints)).isEqualTo(1L);
            ConstraintDefinition constraint = (ConstraintDefinition)constraints.iterator().next();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)constraint.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.labelWithBackticks.name(), (Object)constraint.getLabel().name());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"``backticked_property_key", constraint.getPropertyKeys().iterator().next());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustCreateFullTextIndexBySettingIndexType() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(this.label).on("my_property_key").withIndexType(IndexType.FULLTEXT);
            IndexDefinition definition = creator.create();
            org.junit.jupiter.api.Assertions.assertEquals((Object)IndexType.FULLTEXT, (Object)definition.getIndexType());
            IndexProviderDescriptor provider = ((IndexDefinitionImpl)definition).getIndexReference().getIndexProvider();
            org.junit.jupiter.api.Assertions.assertEquals((Object)provider, (Object)FulltextIndexProviderFactory.DESCRIPTOR);
            tx.commit();
        }
    }

    @Test
    void mustBeAbleToGetIndexConfig() {
        Map config;
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(this.label).on("my_property_key").withIndexType(IndexType.POINT).withName("my_index").create();
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)config.containsKey(IndexSettingImpl.SPATIAL_CARTESIAN_MIN));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "my_index");
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)config.containsKey(IndexSettingImpl.SPATIAL_CARTESIAN_MIN));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustBeAbleToGetFullTextIndexConfig() {
        Map config;
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(this.label).withName("my_index").on("my_property_key").withIndexType(IndexType.FULLTEXT).create();
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)config.containsKey(IndexSettingImpl.FULLTEXT_ANALYZER));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "my_index");
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)config.containsKey(IndexSettingImpl.FULLTEXT_ANALYZER));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustBeAbleToSetFullTextIndexConfig() {
        Map config;
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(this.label).withName("my_index").on("my_property_key").withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSettingImpl.FULLTEXT_ANALYZER, "swedish", IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT, true)).create();
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"swedish", config.get(IndexSettingImpl.FULLTEXT_ANALYZER));
            org.junit.jupiter.api.Assertions.assertEquals((Object)true, config.get(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "my_index");
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"swedish", config.get(IndexSettingImpl.FULLTEXT_ANALYZER));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustBeAbleToSetPointIndexConfig() {
        Map config;
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(this.label).withName("my_index").on("my_property_key").withIndexType(IndexType.POINT).withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, new double[]{200.0, 200.0}, IndexSettingImpl.SPATIAL_WGS84_MIN, new double[]{-90.0, -90.0})).create();
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{200.0, 200.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_CARTESIAN_MAX)));
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{-90.0, -90.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_WGS84_MIN)));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "my_index");
            config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{200.0, 200.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_CARTESIAN_MAX)));
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{-90.0, -90.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_WGS84_MIN)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void indexConfigurationExample() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)"Email")).on("from").on("to").on("cc").on("bcc").withName("email-addresses").withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSetting.fulltext_Analyzer(), "email")).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IndexDefinition index = SchemaAcceptanceTest.getIndex(tx, "email-addresses");
            Assertions.assertThat((Iterable)index.getPropertyKeys()).contains((Object[])new String[]{"from", "to", "cc", "bcc"});
            Assertions.assertThat(index.getIndexConfiguration().get(IndexSetting.fulltext_Analyzer())).isEqualTo((Object)"email");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void indexSettingValuesMustHaveCorrectType() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(this.label).withName("my_index").on("my_property_key");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSettingImpl.FULLTEXT_ANALYZER, 1)).create());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSettingImpl.FULLTEXT_ANALYZER, true)).create());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT, "true")).create());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT, 1)).create());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, "1")).create());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, 1)).create());
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, 1.0)).create());
            tx.commit();
        }
    }

    @Test
    void indexCreatorThrowsOnUnsupportedIndexType() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(this.label).withName("my_index").on("my_property_key");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> indexCreator.withIndexType(IndexType.LOOKUP).create()).isInstanceOf(ConstraintViolationException.class)).hasMessageContaining("Index type LOOKUP is not supported for property indexes.");
        }
    }

    @Test
    void tokenIndexCreatorThrowsOnProperty() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(AnyTokens.ANY_LABELS);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> indexCreator.on("property")).isInstanceOf(ConstraintViolationException.class)).hasMessageContaining("LOOKUP indexes doesn't support inclusion of property keys.");
        }
    }

    @Test
    void tokenIndexCreatorThrowsOnUnsupportedIndexTypes() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(AnyTokens.ANY_LABELS);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> indexCreator.withIndexType(IndexType.RANGE)).isInstanceOf(ConstraintViolationException.class)).hasMessageContaining("Only LOOKUP index type supported for token indexes.");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> indexCreator.withIndexType(IndexType.FULLTEXT)).isInstanceOf(ConstraintViolationException.class)).hasMessageContaining("Only LOOKUP index type supported for token indexes.");
        }
    }

    @Test
    void indexSettingsWithNonsensicalValuesMustBeRejected() {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(this.label).withName("my_index").on("my_property_key");
            Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexType(IndexType.FULLTEXT).withIndexConfiguration(Map.of(IndexSettingImpl.FULLTEXT_ANALYZER, "analyzer that does not exist")).create());
            Assertions.assertThat((Throwable)e).hasMessageContaining("'analyzer that does not exist'");
            e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> creator.withIndexType(IndexType.POINT).withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, new double[]{100.0, 10.0, 1.0})).create());
            Assertions.assertThat((Throwable)e).hasMessageContaining("Invalid spatial index settings");
            tx.commit();
        }
    }

    @Test
    void creatingFullTextIndexOnMultipleLabelsMustBePossible() {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(new Label[]{this.label, this.otherLabel}).on("my_property_key").withIndexType(IndexType.FULLTEXT).withName("index").create();
            Assertions.assertThat((Iterable)index.getLabels()).contains((Object[])new Label[]{this.label, this.otherLabel});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isMultiTokenIndex());
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "index");
            ArrayList labelNames = new ArrayList();
            index.getLabels().forEach(label -> labelNames.add(label.name()));
            Assertions.assertThat(labelNames).contains((Object[])new String[]{this.label.name(), this.otherLabel.name()});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isMultiTokenIndex());
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustThrowWhenCreatingRangeIndexWithZeroLabels() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().indexFor(new Label[0]).on("my_property_key").create());
            tx.commit();
        }
    }

    @Test
    void mustThrowWhenCreatingRangeIndexWithMoreThanOneLabel() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().indexFor(new Label[]{this.label, this.otherLabel}).on("my_property_key").create());
            tx.commit();
        }
    }

    @Test
    void mustThrowWhenCreatingFullTextIndexWithZeroLabels() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().indexFor(new Label[0]).on("my_property_key").withIndexType(IndexType.FULLTEXT).create());
            tx.commit();
        }
    }

    @Test
    void creatingFullTextIndexOnRelationshipTypeMustBePossible() {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(this.relType).on("my_property_key").withIndexType(IndexType.FULLTEXT).withName("index").create();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex());
            Assertions.assertThat((Iterable)index.getRelationshipTypes()).contains((Object[])new RelationshipType[]{this.relType});
            Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.FULLTEXT);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex());
            Assertions.assertThat((Iterable)index.getRelationshipTypes()).contains((Object[])new RelationshipType[]{this.relType});
            Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.FULLTEXT);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingMultiTokenFullTextIndexOnRelationshipTypesMustBePossible() {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = tx.schema().indexFor(new RelationshipType[]{this.relType, this.otherRelType}).on("my_property_key").withIndexType(IndexType.FULLTEXT).withName("index").create();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex());
            Assertions.assertThat((Iterable)index.getRelationshipTypes()).contains((Object[])new RelationshipType[]{this.relType, this.otherRelType});
            Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.FULLTEXT);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            index = SchemaAcceptanceTest.getIndex(tx, "index");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)index.isRelationshipIndex());
            Assertions.assertThat((Iterable)index.getRelationshipTypes()).contains((Object[])new RelationshipType[]{this.relType, this.otherRelType});
            Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.FULLTEXT);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void mustThrowWhenCreatingFullTextIndexOnZeroRelationshipTypes() {
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().indexFor(new RelationshipType[0]).on("my_property_key").withIndexType(IndexType.FULLTEXT).create());
            tx.commit();
        }
    }

    @Test
    void mustThrowWhenCreatingRangeIndexOnZeroRelationshipTypes() {
        try (Transaction tx = this.db.beginTx();){
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().indexFor(new RelationshipType[0]).on("my_property_key").create());
            Assertions.assertThat((Throwable)e).hasMessageContaining("RANGE indexes can only be created with exactly one relationship type, but got no relationship types.");
            tx.commit();
        }
    }

    @Test
    void mustThrowWhenCreatingRangeIndexOnMultipleRelationshipTypes() {
        try (Transaction tx = this.db.beginTx();){
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> tx.schema().indexFor(new RelationshipType[]{this.relType, this.otherRelType}).on("my_property_key").create());
            Assertions.assertThat((Throwable)e).hasMessageContaining("RANGE indexes can only be created with exactly one relationship type, but got 2 relationship types.");
            tx.commit();
        }
    }

    @Test
    void uniquenessConstraintIndexesAreRangeIndexTypeByDefault() {
        String name;
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").create();
            name = constraint.getName();
            IndexDefinition index = SchemaAcceptanceTest.getIndex(tx, name);
            Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.RANGE);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IndexDefinition index = SchemaAcceptanceTest.getIndex(tx, name);
            Assertions.assertThat((Comparable)index.getIndexType()).isEqualTo((Object)IndexType.RANGE);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingUniquenessConstraintWithFullTextIndexTypeMustThrow() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withIndexType(IndexType.FULLTEXT);
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConstraintCreator)creator).create());
        }
    }

    @Test
    void creatingNodePropertyExistenceConstraintMustThrowWhenGivenIndexType() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.label).assertPropertyExists("my_property_key").withIndexType(IndexType.RANGE);
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConstraintCreator)creator).create());
            tx.commit();
        }
    }

    @Test
    void creatingRelationshipPropertyExistenceConstraintsMustThrowWhenGivenIndexType() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.relType).assertPropertyExists("my_property_key").withIndexType(IndexType.RANGE);
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConstraintCreator)creator).create());
            tx.commit();
        }
    }

    @Test
    void mustBeAbleToSpecifyIndexConfigurationForUniquenessConstraint() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = tx.schema().constraintFor(this.label).withName("my constraint").assertPropertyIsUnique("my_property_key").withIndexConfiguration(Map.of(IndexSettingImpl.SPATIAL_CARTESIAN_MAX, new double[]{200.0, 200.0}, IndexSettingImpl.SPATIAL_WGS84_MIN, new double[]{-90.0, -90.0})).create();
            IndexDefinition index = SchemaAcceptanceTest.getIndex(tx, constraint.getName());
            Map config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{200.0, 200.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_CARTESIAN_MAX)));
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{-90.0, -90.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_WGS84_MIN)));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            IndexDefinition index = SchemaAcceptanceTest.getIndex(tx, "my constraint");
            Map config = index.getIndexConfiguration();
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{200.0, 200.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_CARTESIAN_MAX)));
            org.junit.jupiter.api.Assertions.assertArrayEquals((double[])new double[]{-90.0, -90.0}, (double[])((double[])config.get(IndexSettingImpl.SPATIAL_WGS84_MIN)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void creatingNodePropertyExistenceConstraintMustThrowWhenGivenIndexConfiguration() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.label).withIndexConfiguration(Map.of()).assertPropertyExists("my_property_key");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConstraintCreator)creator).create());
            tx.commit();
        }
    }

    @Test
    void creatingRelationshipPropertyExistenceConstraintMustThrowWhenGivenIndexConfiguration() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(this.relType).withIndexConfiguration(Map.of()).assertPropertyExists("my_property_key");
            org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConstraintCreator)creator).create());
            tx.commit();
        }
    }

    @Test
    void creatingRangeRelationshipIndex() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.relType, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.relType)).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @Test
    void creatingCompositeRangeRelationshipIndex() {
        IndexDefinition index = SchemaAcceptanceTest.createIndex(this.db, this.relType, "my_property_key", "my_second_property_key");
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat(SchemaAcceptanceTest.getIndexes(tx, this.relType)).containsOnly((Object[])new IndexDefinition[]{index});
        }
    }

    @Test
    void mustBePossibleToGetFulltextIndexesBasedOnRelationshipType() {
        IndexDefinition index2;
        IndexDefinition index1;
        try (Transaction tx = this.db.beginTx();){
            index1 = tx.schema().indexFor(this.relType).on("my_property_key").withIndexType(IndexType.FULLTEXT).create();
            index2 = tx.schema().indexFor(new RelationshipType[]{this.relType, this.otherRelType}).on("my_property_key").withIndexType(IndexType.FULLTEXT).create();
            tx.commit();
        }
        SchemaAcceptanceTest.waitForIndex(this.db, index1);
        SchemaAcceptanceTest.waitForIndex(this.db, index2);
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Iterable)tx.schema().getIndexes(this.relType)).containsExactly((Object[])new IndexDefinition[]{index1, index2});
            Assertions.assertThat((Iterable)tx.schema().getIndexes(this.otherRelType)).containsOnly((Object[])new IndexDefinition[]{index2});
            Assertions.assertThat((Iterable)tx.schema().getIndexes(this.thirdRelType)).isEmpty();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void commitTwoIndexes() {
        IndexDefinition indexB;
        IndexDefinition indexA;
        try (Transaction tx = this.db.beginTx();){
            indexA = tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
            indexB = tx.schema().indexFor(this.otherLabel).on("my_property_key").withName("index b").create();
            tx.commit();
        }
        SchemaAcceptanceTest.waitForIndexes(this.db);
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexA)).isEqualTo((Object)Schema.IndexState.ONLINE);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexB)).isEqualTo((Object)Schema.IndexState.ONLINE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void rollbackTwoIndexes() {
        IndexDefinition indexB;
        IndexDefinition indexA;
        try (Transaction tx = this.db.beginTx();){
            indexA = tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
            indexB = tx.schema().indexFor(this.otherLabel).on("my_property_key").withName("index b").create();
            tx.rollback();
        }
        SchemaAcceptanceTest.waitForIndexes(this.db);
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> SchemaAcceptanceTest.getIndexState(tx, indexA));
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> SchemaAcceptanceTest.getIndexState(tx, indexB));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackTxOnConflictOnFirstIndexCreation() {
        IndexDefinition oldIndexA = SchemaAcceptanceTest.createIndex(this.db, "index a", this.label, "my_property_key");
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
                tx.schema().indexFor(this.otherLabel).on("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        SchemaAcceptanceTest.waitForIndexes(this.db);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(1L);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, oldIndexA)).isEqualTo((Object)Schema.IndexState.ONLINE);
            tx.commit();
        }
    }

    @Test
    void implicitRollbackTxOnConflictOnSecondIndexCreation() {
        IndexDefinition oldIndexB = SchemaAcceptanceTest.createIndex(this.db, "index b", this.otherLabel, "my_property_key");
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
                tx.schema().indexFor(this.otherLabel).on("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        SchemaAcceptanceTest.waitForIndexes(this.db);
        try (Transaction tx = this.db.beginTx();){
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(1L);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, oldIndexB)).isEqualTo((Object)Schema.IndexState.ONLINE);
            tx.commit();
        }
    }

    @Test
    void createAndDropNewIndexInSameTxIsNoOp() {
        IndexDefinition indexA;
        try (Transaction tx = this.db.beginTx();){
            indexA = tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
            SchemaAcceptanceTest.getIndex(tx, "index a").drop();
            tx.commit();
        }
        SchemaAcceptanceTest.waitForIndexes(this.db);
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> SchemaAcceptanceTest.getIndexState(tx, indexA));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void dropOldIndexAndCreateNewIdenticalCreatesNewIndex() {
        IndexDefinition indexA;
        IndexDefinition oldIndexA = SchemaAcceptanceTest.createIndex(this.db, "index a", this.label, "my_property_key");
        try (Transaction tx = this.db.beginTx();){
            SchemaAcceptanceTest.getIndex(tx, "index a").drop();
            indexA = tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
            tx.commit();
        }
        SchemaAcceptanceTest.waitForIndexes(this.db);
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> SchemaAcceptanceTest.getIndexState(tx, oldIndexA));
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexA)).isEqualTo((Object)Schema.IndexState.ONLINE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void indexPopulationFailureWillOnlyFailAffectedIndex() {
        IndexDefinition indexB;
        IndexDefinition indexA;
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)SchemaAcceptanceTest.tooLargeString());
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            indexA = tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
            indexB = tx.schema().indexFor(this.otherLabel).on("my_property_key").withName("index b").create();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> SchemaAcceptanceTest.waitForIndexes(this.db));
        SchemaAcceptanceTest.waitForIndex(this.db, indexB);
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(2L);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexA)).isEqualTo((Object)Schema.IndexState.FAILED);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexB)).isEqualTo((Object)Schema.IndexState.ONLINE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotUseFailedIndexToFindEntities() {
        IndexDefinition indexA;
        long expectedNode;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode(new Label[]{this.label});
            expectedNode = node.getId();
            node.setProperty("my_property_key", (Object)"somevalue");
            tx.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)SchemaAcceptanceTest.tooLargeString());
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            indexA = tx.schema().indexFor(this.label).on("my_property_key").withName("index a").create();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> SchemaAcceptanceTest.waitForIndexes(this.db));
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(1L);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, indexA)).isEqualTo((Object)Schema.IndexState.FAILED);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try (ResourceIterator nodes = tx.findNodes(this.label, "my_property_key", (Object)"somevalue");){
            Assertions.assertThat((boolean)nodes.hasNext()).isTrue();
            Assertions.assertThat((long)((Node)nodes.next()).getId()).isEqualTo(expectedNode);
            Assertions.assertThat((boolean)nodes.hasNext()).isFalse();
            nodes.close();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void commitTwoConstraintsSameTx() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
            tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(2L);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, "index a")).isEqualTo((Object)Schema.IndexState.ONLINE);
            Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, "index b")).isEqualTo((Object)Schema.IndexState.ONLINE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void rollbackTwoConstraintsSameTx() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
            tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
            tx.rollback();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackIfIndexPopulationFailureOnFirstConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)SchemaAcceptanceTest.tooLargeString());
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackIfIndexPopulationFailureOnSecondConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.otherLabel}).setProperty("my_property_key", (Object)SchemaAcceptanceTest.tooLargeString());
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackIfConstraintViolationOnFirstConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)"Non-unique string");
            tx.createNode(new Label[]{this.label}).setProperty("my_property_key", (Object)"Non-unique string");
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackIfConstraintViolationOnSecondConstraint() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{this.otherLabel}).setProperty("my_property_key", (Object)"Non-unique string");
            tx.createNode(new Label[]{this.otherLabel}).setProperty("my_property_key", (Object)"Non-unique string");
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackIfFirstConstraintAlreadyExists() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(1L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(1L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void implicitRollbackIfSecondConstraintAlreadyExists() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
            tx.commit();
        }
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.schema().constraintFor(this.otherLabel).assertPropertyIsUnique("my_property_key").withName("index b").create();
                tx.commit();
            }
        });
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(1L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(1L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createAndDropConstraintInSameTx() {
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
            constraint.drop();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getConstraints())).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)tx.schema().getIndexes())).isEqualTo(0L);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void dropUniquenessConstraintAndCreateSimilarUniquenessInSameTxMustThrow() {
        SchemaAcceptanceTestBase.ConstraintCreateOperation initial = (schema, prop, name) -> schema.constraintFor(this.label).assertPropertyIsUnique(prop).withName(name).create();
        SchemaAcceptanceTestBase.ConstraintCreateOperation similar = (schema, prop, name) -> schema.constraintFor(this.label).assertPropertyIsUnique(prop).withName(name).create();
        this.dropIndexBackedConstraintAndCreateSimilarInSameTxMustThrow(this.db, initial, similar);
    }

    @Test
    void dropUniquenessConstraintAndCreateDifferentUniquenessInSameTxMustSucceed() {
        SchemaAcceptanceTestBase.ConstraintCreateOperation initial = (schema, prop, name) -> schema.constraintFor(this.label).assertPropertyIsUnique(prop).withName(name).create();
        SchemaAcceptanceTestBase.ConstraintCreateOperation similar = (schema, prop, name) -> schema.constraintFor(this.label).assertPropertyIsUnique(prop).withName(name).create();
        this.dropIndexBackedConstraintAndCreateSlightlyDifferentInSameTxMustSucceed(this.db, initial, similar);
    }

    @Test
    void dropRelUniquenessConstraintAndCreateSimilarUniquenessInSameTxMustThrow() {
        SchemaAcceptanceTestBase.ConstraintCreateOperation initial = (schema, prop, name) -> schema.constraintFor(this.relType).assertPropertyIsUnique(prop).withName(name).create();
        SchemaAcceptanceTestBase.ConstraintCreateOperation similar = (schema, prop, name) -> schema.constraintFor(this.relType).assertPropertyIsUnique(prop).withName(name).create();
        this.dropIndexBackedConstraintAndCreateSimilarInSameTxMustThrow(this.db, initial, similar);
    }

    @Test
    void dropRelUniquenessConstraintAndCreateDifferentUniquenessInSameTxMustSucceed() {
        SchemaAcceptanceTestBase.ConstraintCreateOperation initial = (schema, prop, name) -> schema.constraintFor(this.relType).assertPropertyIsUnique(prop).withName(name).create();
        SchemaAcceptanceTestBase.ConstraintCreateOperation similar = (schema, prop, name) -> schema.constraintFor(this.relType).assertPropertyIsUnique(prop).withName(name).create();
        this.dropIndexBackedConstraintAndCreateSlightlyDifferentInSameTxMustSucceed(this.db, initial, similar);
    }

    @Test
    void crashDuringIndexPopulationOfConstraint() throws InterruptedException {
        Iterable indexes;
        Iterable constraints;
        this.trapPopulation.set(true);
        this.otherThread.execute(() -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.commit();
            }
            return null;
        });
        this.populationScanFinished.await();
        EphemeralFileSystemAbstraction crash = this.fs.snapshot();
        this.populationScanFinished.release();
        this.controller.restartDbms(builder -> {
            builder.setFileSystem((FileSystemAbstraction)crash);
            return builder;
        });
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            constraints = tx.schema().getConstraints();
            indexes = tx.schema().getIndexes();
            Assertions.assertThat((long)Iterables.count((Iterable)constraints)).isEqualTo(0L);
            Assertions.assertThat((long)Iterables.count((Iterable)indexes)).isEqualTo(1L);
            indexes.forEach(index -> Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, index)).isEqualTo((Object)Schema.IndexState.ONLINE));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Object e = (QueryExecutionException)org.junit.jupiter.api.Assertions.assertThrows(QueryExecutionException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.execute("DROP CONSTRAINT `index a`");
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).hasRootCauseInstanceOf(NoSuchConstraintException.class);
        e = (ConstraintViolationException)org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
                tx.commit();
            }
        });
        Assertions.assertThat((Throwable)e).hasRootCauseInstanceOf(IndexWithNameAlreadyExistsException.class);
        tx = this.db.beginTx();
        try {
            tx.schema().getIndexByName("index a").drop();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().constraintFor(this.label).assertPropertyIsUnique("my_property_key").withName("index a").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            constraints = tx.schema().getConstraints();
            indexes = tx.schema().getIndexes();
            Assertions.assertThat((long)Iterables.count((Iterable)constraints)).isEqualTo(1L);
            Assertions.assertThat((long)Iterables.count((Iterable)indexes)).isEqualTo(1L);
            indexes.forEach(index -> Assertions.assertThat((Comparable)SchemaAcceptanceTest.getIndexState(tx, index)).isEqualTo((Object)Schema.IndexState.ONLINE));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static IndexDefinition getIndex(Transaction tx, String name) {
        return tx.schema().getIndexByName(name);
    }

    private static Schema.IndexState getIndexState(Transaction tx, IndexDefinition name) {
        return tx.schema().getIndexState(name);
    }

    private static Schema.IndexState getIndexState(Transaction tx, String name) {
        return SchemaAcceptanceTest.getIndexState(tx, SchemaAcceptanceTest.getIndex(tx, name));
    }

    private static String tooLargeString() {
        int violatingSize = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192) + 1;
        return IndexEntryTestUtil.generateStringResultingInIndexEntrySize((int)violatingSize);
    }

    private static String alreadyExistsIndexMessage(String indexName) {
        return "There already exists an index called '" + indexName + "'";
    }

    private static String thereAlreadyExistsConstraintMessage(String constraintName) {
        return "There already exists a constraint called '" + constraintName + "'.";
    }

    private static void dropConstraint(GraphDatabaseService db, ConstraintDefinition constraint) {
        try (Transaction tx = db.beginTx();){
            tx.schema().getConstraintByName(constraint.getName()).drop();
            tx.commit();
        }
    }

    private ConstraintDefinition createUniquenessConstraint(Label label, String ... properties) {
        return this.createUniquenessConstraint(null, label, properties);
    }

    private ConstraintDefinition createUniquenessConstraint(String name, Label label, String ... properties) {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(label);
            for (String property : properties) {
                creator = creator.assertPropertyIsUnique(property);
            }
            creator = creator.withName(name);
            ConstraintDefinition constraint = creator.create();
            tx.commit();
            ConstraintDefinition constraintDefinition = constraint;
            return constraintDefinition;
        }
    }

    private ConstraintDefinition createRelUniquenessConstraint(RelationshipType type, String ... properties) {
        return this.createRelUniquenessConstraint(null, type, properties);
    }

    private ConstraintDefinition createRelUniquenessConstraint(String name, RelationshipType type, String ... properties) {
        try (Transaction tx = this.db.beginTx();){
            ConstraintCreator creator = tx.schema().constraintFor(type);
            for (String property : properties) {
                creator = creator.assertPropertyIsUnique(property);
            }
            creator = creator.withName(name);
            ConstraintDefinition constraint = creator.create();
            tx.commit();
            ConstraintDefinition constraintDefinition = constraint;
            return constraintDefinition;
        }
    }

    protected void dropIndex(IndexDefinition index) {
        try (Transaction tx = this.db.beginTx();){
            SchemaAcceptanceTest.getIndex(tx, index.getName()).drop();
            tx.commit();
        }
    }

    static Node createNode(GraphDatabaseService db, String key, Object value, Label label) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(key, value);
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, RelationshipType relType, String ... properties) {
        return SchemaAcceptanceTest.createIndex(db, IndexType.RANGE, null, relType, properties);
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, IndexType indexType, RelationshipType relType, String ... properties) {
        return SchemaAcceptanceTest.createIndex(db, indexType, null, relType, properties);
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, IndexType indexType, String name, RelationshipType relType, String ... properties) {
        IndexDefinition indexDef = SchemaAcceptanceTest.createIndexNoWait(db, indexType, name, relType, properties);
        SchemaAcceptanceTest.waitForIndex(db, indexDef);
        return indexDef;
    }

    static IndexDefinition createIndexNoWait(GraphDatabaseService db, IndexType indexType, String name, RelationshipType relType, String ... properties) {
        IndexDefinition indexDef;
        try (Transaction tx = db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(relType).withIndexType(indexType);
            for (String property : properties) {
                indexCreator = indexCreator.on(property);
            }
            if (name != null) {
                indexCreator = indexCreator.withName(name);
            }
            indexDef = indexCreator.create();
            tx.commit();
        }
        return indexDef;
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, IndexType indexType, Label label, String ... properties) {
        return SchemaAcceptanceTest.createIndex(db, indexType, null, label, properties);
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, Label label, String ... properties) {
        return SchemaAcceptanceTest.createIndex(db, IndexType.RANGE, null, label, properties);
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, String name, Label label, String ... properties) {
        return SchemaAcceptanceTest.createIndex(db, IndexType.RANGE, name, label, properties);
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, IndexType indexType, String name, Label label, String ... properties) {
        IndexDefinition indexDef = SchemaAcceptanceTest.createIndexNoWait(db, indexType, name, label, properties);
        SchemaAcceptanceTest.waitForIndex(db, indexDef);
        return indexDef;
    }

    public static IndexDefinition createIndex(GraphDatabaseService db, AnyTokens tokens, String name) {
        IndexDefinition index;
        try (Transaction tx = db.beginTx();){
            IndexCreator creator = tx.schema().indexFor(tokens);
            if (name != null) {
                creator = creator.withName(name);
            }
            index = creator.create();
            tx.commit();
        }
        SchemaAcceptanceTest.waitForIndex(db, index);
        return index;
    }

    static IndexDefinition createIndexNoWait(GraphDatabaseService db, IndexType indexType, String name, Label label, String ... properties) {
        IndexDefinition indexDef;
        try (Transaction tx = db.beginTx();){
            IndexCreator indexCreator = tx.schema().indexFor(label).withIndexType(indexType);
            for (String property : properties) {
                indexCreator = indexCreator.on(property);
            }
            if (name != null) {
                indexCreator = indexCreator.withName(name);
            }
            indexDef = indexCreator.create();
            tx.commit();
        }
        return indexDef;
    }

    static void waitForIndex(GraphDatabaseService beansAPI, IndexDefinition indexDef) {
        try (Transaction tx = beansAPI.beginTx();){
            tx.schema().awaitIndexOnline(indexDef, 10L, TimeUnit.MINUTES);
        }
    }

    private static Iterable<IndexDefinition> getIndexes(Transaction tx, RelationshipType relType) {
        return tx.schema().getIndexes(relType);
    }

    public static void waitForIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
    }

    private static Iterable<IndexDefinition> getIndexes(Transaction tx, Label label) {
        return tx.schema().getIndexes(label);
    }

    @Nested
    @ActorsExtension
    @ImpermanentDbmsExtension(configurationCallback="configure")
    class SchemaConcurrency {
        @Inject
        Actor first;
        @Inject
        Actor second;
        BinaryLatch startLatch;

        SchemaConcurrency() {
        }

        @ExtensionCallback
        void configure(TestDatabaseManagementServiceBuilder builder) {
            SchemaAcceptanceTest.this.configure(builder);
        }

        @BeforeEach
        void setUp() {
            this.startLatch = new BinaryLatch();
        }

        @RepeatedTest(value=20)
        void cannotCreateTokenIndexesWithTheSameSchemaInConcurrentTransactions() throws Exception {
            Future firstFuture = this.first.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("index-1"))));
            Future secondFuture = this.second.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("index-2"))));
            this.raceTransactions(firstFuture, secondFuture);
            this.assertOneSuccessAndOneFailure(firstFuture, secondFuture);
        }

        @RepeatedTest(value=20)
        void cannotCreateIndexesWithTheSameNameInConcurrentTransactions() throws Exception {
            String indexName = "MyIndex";
            Future firstFuture = this.first.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().indexFor(SchemaAcceptanceTest.this.label).on("my_property_key").withName(indexName))));
            Future secondFuture = this.second.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().indexFor(SchemaAcceptanceTest.this.otherLabel).on("my_second_property_key").withName(indexName))));
            this.raceTransactions(firstFuture, secondFuture);
            this.assertOneSuccessAndOneFailure(firstFuture, secondFuture);
        }

        @RepeatedTest(value=20)
        void cannotCreateConstraintsWithTheSameNameInConcurrentTransactions() throws Exception {
            String constraintName = "MyConstraint";
            Future firstFuture = this.first.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().constraintFor(SchemaAcceptanceTest.this.label).assertPropertyIsUnique("my_property_key").withName(constraintName))));
            Future secondFuture = this.second.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().constraintFor(SchemaAcceptanceTest.this.otherLabel).assertPropertyIsUnique("my_second_property_key").withName(constraintName))));
            this.raceTransactions(firstFuture, secondFuture);
            this.assertOneSuccessAndOneFailure(firstFuture, secondFuture);
        }

        @RepeatedTest(value=20)
        void cannotCreateIndexesAndConstraintsWithTheSameNameInConcurrentTransactions() throws Exception {
            String schemaName = "MySchema";
            Future firstFuture = this.first.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().constraintFor(SchemaAcceptanceTest.this.label).assertPropertyIsUnique("my_property_key").withName(schemaName))));
            Future secondFuture = this.second.submit(this.schemaTransaction((ThrowingFunction<Transaction, Object, Exception>)((ThrowingFunction)tx -> tx.schema().indexFor(SchemaAcceptanceTest.this.otherLabel).on("my_second_property_key").withName(schemaName))));
            this.raceTransactions(firstFuture, secondFuture);
            this.assertOneSuccessAndOneFailure(firstFuture, secondFuture);
        }

        @Test
        void droppingConstraintMustLockNameForIndexCreate() throws Exception {
            String schemaName = "MySchema";
            SchemaAcceptanceTest.this.createUniquenessConstraint(schemaName, SchemaAcceptanceTest.this.label, "my_property_key");
            try (Transaction tx = SchemaAcceptanceTest.this.db.beginTx();){
                tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
                tx.commit();
            }
            BinaryLatch afterFirstDropsConstraint = new BinaryLatch();
            BinaryLatch pauseFirst = new BinaryLatch();
            BinaryLatch beforeSecondCreatesIndex = new BinaryLatch();
            Future firstFuture = this.first.submit(() -> {
                try (Transaction tx = SchemaAcceptanceTest.this.db.beginTx();){
                    tx.schema().getConstraintByName(schemaName).drop();
                    afterFirstDropsConstraint.release();
                    pauseFirst.await();
                    tx.commit();
                }
            });
            Future secondFuture = this.second.submit(() -> {
                afterFirstDropsConstraint.await();
                try (Transaction tx = SchemaAcceptanceTest.this.db.beginTx();){
                    beforeSecondCreatesIndex.release();
                    IndexCreator indexCreator = tx.schema().indexFor(SchemaAcceptanceTest.this.otherLabel).on("my_second_property_key").withName(schemaName);
                    indexCreator.create();
                    tx.commit();
                }
            });
            this.first.untilWaitingIn((Executable)BinaryLatch.class.getMethod("await", new Class[0]));
            beforeSecondCreatesIndex.await();
            this.second.untilWaitingIn((Executable)ForsetiClient.class.getMethod("incrementalBackoffWait", Long.TYPE));
            this.second.untilWaiting();
            pauseFirst.release();
            firstFuture.get();
            secondFuture.get();
            try (Transaction tx = SchemaAcceptanceTest.this.db.beginTx();){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.schema().getConstraints().iterator().hasNext());
                Iterator indexes = tx.schema().getIndexes().iterator();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)indexes.hasNext());
                org.junit.jupiter.api.Assertions.assertEquals((Object)((IndexDefinition)indexes.next()).getName(), (Object)schemaName);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)indexes.hasNext());
                tx.commit();
            }
        }

        @RepeatedTest(value=10)
        void awaitIndexesMustNotThrowOnConcurrentlyDroppedIndexes() throws Exception {
            AtomicBoolean stop = new AtomicBoolean();
            ConcurrentLinkedQueue<IndexDefinition> indexes = new ConcurrentLinkedQueue<IndexDefinition>();
            try (Transaction tx = SchemaAcceptanceTest.this.db.beginTx();){
                for (int i = 0; i < 50; ++i) {
                    indexes.add(tx.schema().indexFor(Label.label((String)("Label_" + i))).on("propl_" + i).create());
                }
                tx.commit();
            }
            Future firstFuture = this.first.submit(() -> {
                this.startLatch.await();
                while (!stop.get()) {
                    Transaction tx = SchemaAcceptanceTest.this.db.beginTx();
                    try {
                        try {
                            tx.schema().awaitIndexesOnline(20L, TimeUnit.MINUTES);
                        }
                        catch (DeadlockDetectedException deadlockDetectedException) {
                        }
                        catch (Exception e) {
                            stop.set(true);
                            indexes.clear();
                            throw e;
                        }
                        tx.commit();
                    }
                    finally {
                        if (tx == null) continue;
                        tx.close();
                    }
                }
            });
            Future secondFuture = this.second.submit(() -> {
                block13: {
                    this.startLatch.await();
                    block10: while (true) {
                        IndexDefinition index;
                        while ((index = (IndexDefinition)indexes.poll()) != null) {
                            try {
                                Transaction tx = SchemaAcceptanceTest.this.db.beginTx();
                                try {
                                    Thread.sleep(1L);
                                    SchemaAcceptanceTest.getIndex(tx, index.getName()).drop();
                                    tx.commit();
                                    continue block10;
                                }
                                finally {
                                    if (tx != null) {
                                        tx.close();
                                    }
                                    continue block10;
                                }
                            }
                            catch (DeadlockDetectedException deadlockDetectedException) {
                            }
                        }
                        break block13;
                        {
                            continue block10;
                            break;
                        }
                        break;
                    }
                    finally {
                        stop.set(true);
                    }
                }
                return null;
            });
            this.raceTransactions(firstFuture, secondFuture);
            firstFuture.get();
            secondFuture.get();
        }

        private Callable<Void> schemaTransaction(ThrowingFunction<Transaction, Object, Exception> action) {
            return () -> {
                try (Transaction tx = SchemaAcceptanceTest.this.db.beginTx();){
                    Object creator = action.apply((Object)tx);
                    this.startLatch.await();
                    if (creator instanceof IndexCreator) {
                        ((IndexCreator)creator).create();
                    } else if (creator instanceof ConstraintCreator) {
                        ((ConstraintCreator)creator).create();
                    } else {
                        org.junit.jupiter.api.Assertions.fail((String)("Don't know how to create from " + creator));
                    }
                    tx.commit();
                }
                return null;
            };
        }

        private void raceTransactions(Future<Void> firstFuture, Future<Void> secondFuture) throws InterruptedException, NoSuchMethodException {
            this.first.untilWaitingIn((Executable)BinaryLatch.class.getMethod("await", new Class[0]));
            this.second.untilWaitingIn((Executable)BinaryLatch.class.getMethod("await", new Class[0]));
            this.startLatch.release();
            while (!firstFuture.isDone() || !secondFuture.isDone()) {
                Thread.onSpinWait();
            }
        }

        private void assertOneSuccessAndOneFailure(Future<Void> firstFuture, Future<Void> secondFuture) throws InterruptedException {
            Throwable firstThrowable = this.getException(firstFuture);
            Throwable secondThrowable = this.getException(secondFuture);
            if (firstThrowable == null && secondThrowable == null) {
                org.junit.jupiter.api.Assertions.fail((String)"Both transactions completed successfully, when one of them should have thrown.");
            }
            Throwable error = firstThrowable != null ? firstThrowable : secondThrowable;
            Assertions.assertThat((Throwable)error).isInstanceOfAny(new Class[]{ConstraintViolationException.class, TransactionFailureException.class});
        }

        private Throwable getException(Future<Void> future) throws InterruptedException {
            try {
                future.get();
                return null;
            }
            catch (ExecutionException e) {
                return e.getCause();
            }
        }
    }
}

