/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class ForsetiSameThreadClientIT {
    @Inject
    GraphDatabaseAPI database;
    @Inject
    DatabaseManagementService managementService;

    ForsetiSameThreadClientIT() {
    }

    @Test
    void shouldDetectDeadlockForCommitListeners() {
        long nodeId;
        try (Transaction tx = this.database.beginTx();){
            nodeId = tx.createNode().getId();
            tx.commit();
        }
        this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Void>(){

            public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
                try (Transaction tx = ForsetiSameThreadClientIT.this.database.beginTx();){
                    tx.acquireReadLock((Entity)tx.getNodeById(nodeId));
                }
            }
        });
        tx = this.database.beginTx();
        try {
            tx.createNode();
            tx.acquireWriteLock((Entity)tx.getNodeById(nodeId));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)tx).commit()).isInstanceOf(DeadlockDetectedException.class)).hasMessageContaining("committing on the same thread");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

