/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.newapi.DefaultNodeBasedRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class KernelAPIWriteTestBase<WriteSupport extends KernelAPIWriteTestSupport> {
    protected KernelAPIWriteTestSupport testSupport;
    protected GraphDatabaseService graphDb;
    private static final TokenHolders tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
    private static final QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private static final TransactionalContextFactory contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
    private static final DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);
    private static final ElementIdMapper elementIdMapper = (ElementIdMapper)Mockito.mock(ElementIdMapper.class, (Answer)Answers.RETURNS_MOCKS);
    @Inject
    private TestDirectory testDirectory;

    public abstract WriteSupport newTestSupport();

    @BeforeAll
    public void setupGraph() {
        this.testSupport = this.newTestSupport();
        this.testSupport.setup(this.testDirectory.homePath(), this::createSystemGraph);
        this.graphDb = this.testSupport.graphBackdoor();
    }

    @BeforeEach
    public void clearGraph() {
        this.testSupport.clearGraph();
    }

    @AfterAll
    public void tearDown() {
        this.testSupport.tearDown();
    }

    public void createSystemGraph(GraphDatabaseService graphDb) {
    }

    protected KernelTransaction beginTransaction() throws TransactionFailureException {
        return this.beginTransaction(LoginContext.AUTH_DISABLED);
    }

    protected KernelTransaction beginTransaction(LoginContext loginContext) throws TransactionFailureException {
        Kernel kernel = this.testSupport.kernelToTest();
        KernelTransaction kernelTransaction = kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, loginContext);
        new TransactionImpl(tokenHolders, contextFactory, availabilityGuard, engine, kernelTransaction, elementIdMapper);
        return kernelTransaction;
    }

    protected void transaction(ThrowingConsumer<KernelTransaction, Exception> action) throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            action.accept((Object)tx);
            tx.commit();
        }
    }

    protected static CursorFactory cursorFactory(KernelTransaction ktx) {
        return ((Read)ktx.dataRead()).cursors();
    }

    protected void assertProperties(EntityCursor entityCursor, PropertyCursor propertyCursor, IntObjectMap<Value> expectedProperties) {
        entityCursor.properties(propertyCursor, PropertySelection.ALL_PROPERTIES);
        MutableIntObjectMap readProperties = IntObjectMaps.mutable.empty();
        while (propertyCursor.next()) {
            readProperties.put(propertyCursor.propertyKey(), (Object)propertyCursor.propertyValue());
        }
        Assertions.assertThat((Iterable)readProperties).isEqualTo(expectedProperties);
    }

    protected boolean isNodeBased() {
        boolean bl;
        block8: {
            KernelTransaction tx = this.beginTransaction();
            try {
                bl = this.isNodeBased(tx);
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KernelException ex) {
                    org.junit.jupiter.api.Assertions.fail((String)"Unable to determine whether the transaction would create a cursor over the relationship type index that is node-based");
                    return false;
                }
            }
            tx.close();
        }
        return bl;
    }

    protected boolean isNodeBased(Transaction tx) {
        return this.isNodeBased(((InternalTransaction)tx).kernelTransaction());
    }

    protected boolean isNodeBased(KernelTransaction tx) {
        RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);
        return cursor instanceof DefaultNodeBasedRelationshipTypeIndexCursor;
    }
}

