/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;

public class ManagedTestCursors
implements CursorFactory {
    private final List<Cursor> allCursors = new ArrayList<Cursor>();
    private final CursorFactory cursors;

    ManagedTestCursors(CursorFactory c) {
        this.cursors = c;
    }

    void assertAllClosedAndReset() {
        for (Cursor n : this.allCursors) {
            if (n.isClosed()) continue;
            Assertions.fail((String)("The Cursor " + n + " was not closed properly."));
        }
        this.allCursors.clear();
    }

    public NodeCursor allocateNodeCursor(CursorContext cursorContext) {
        NodeCursor n = this.cursors.allocateNodeCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeCursor allocateFullAccessNodeCursor(CursorContext cursorContext) {
        NodeCursor n = this.cursors.allocateFullAccessNodeCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext) {
        RelationshipScanCursor n = this.cursors.allocateRelationshipScanCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor(CursorContext cursorContext) {
        RelationshipScanCursor n = this.cursors.allocateFullAccessRelationshipScanCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext) {
        RelationshipTraversalCursor n = this.cursors.allocateRelationshipTraversalCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(CursorContext cursorContext) {
        RelationshipTraversalCursor n = this.cursors.allocateFullAccessRelationshipTraversalCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocatePropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        PropertyCursor n = this.cursors.allocatePropertyCursor(cursorContext, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocateFullAccessPropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        PropertyCursor n = this.cursors.allocateFullAccessPropertyCursor(cursorContext, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        NodeValueIndexCursor n = this.cursors.allocateNodeValueIndexCursor(cursorContext, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        NodeValueIndexCursor n = this.cursors.allocateFullAccessNodeValueIndexCursor(cursorContext, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(CursorContext cursorContext) {
        NodeLabelIndexCursor n = this.cursors.allocateNodeLabelIndexCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(CursorContext cursorContext) {
        NodeLabelIndexCursor n = this.cursors.allocateFullAccessNodeLabelIndexCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipValueIndexCursor allocateRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        RelationshipValueIndexCursor n = this.cursors.allocateRelationshipValueIndexCursor(cursorContext, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipValueIndexCursor allocateFullAccessRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        RelationshipValueIndexCursor n = this.cursors.allocateFullAccessRelationshipValueIndexCursor(cursorContext, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor(CursorContext cursorContext) {
        RelationshipTypeIndexCursor n = this.cursors.allocateRelationshipTypeIndexCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTypeIndexCursor allocateFullAccessRelationshipTypeIndexCursor(CursorContext cursorContext) {
        RelationshipTypeIndexCursor n = this.cursors.allocateFullAccessRelationshipTypeIndexCursor(cursorContext);
        this.allCursors.add((Cursor)n);
        return n;
    }
}

