/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelPartitionedRelationshipCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static LongList RELATIONSHIPS;
    private static final int NUMBER_OF_RELATIONSHIPS = 128;
    private static final ToLongFunction<RelationshipScanCursor> REL_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            LongArrayList list = new LongArrayList(128);
            for (int i = 0; i < 128; ++i) {
                list.add(tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R")).getId());
            }
            RELATIONSHIPS = list;
            tx.commit();
        }
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldScanASubsetOfRelationships(TestUtils.PartitionedScanAPI api) {
        CursorContext cursorContext = this.tx.cursorContext();
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();
             RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            PartitionedScan scan = this.read.allRelationshipsScan(64, CursorContext.NULL_CONTEXT);
            api.reservePartition(scan, relationships, this.tx, executionContext);
            LongArrayList ids = new LongArrayList();
            while (relationships.next()) {
                ids.add(relationships.relationshipReference());
            }
            Assertions.assertTrue((ids.size() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((ids.size() < RELATIONSHIPS.size() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)RELATIONSHIPS.containsAll((LongIterable)ids));
            executionContext.complete();
        }
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldHandleSinglePartition(TestUtils.PartitionedScanAPI api) {
        CursorContext cursorContext = this.tx.cursorContext();
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();
             RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            PartitionedScan scan = this.read.allRelationshipsScan(1, CursorContext.NULL_CONTEXT);
            Assertions.assertTrue((boolean)api.reservePartition(scan, relationships, this.tx, executionContext));
            LongArrayList ids = new LongArrayList();
            while (relationships.next()) {
                ids.add(relationships.relationshipReference());
            }
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
            executionContext.complete();
        }
    }

    @Test
    void shouldFailOnZeroPartitions() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.read.allRelationshipsScan(0, CursorContext.NULL_CONTEXT));
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldScanAllRelationshipsInBatchesWithGetNumberOfPartitions(TestUtils.PartitionedScanAPI api) {
        LongArrayList ids = new LongArrayList();
        PartitionedScan scan = this.read.allRelationshipsScan(10, CursorContext.NULL_CONTEXT);
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (Statement statement = this.tx.acquireStatement();
                 ExecutionContext executionContext = this.tx.createExecutionContext();
                 RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                api.reservePartition(scan, relationships, this.tx, executionContext);
                while (relationships.next()) {
                    ids.add(relationships.relationshipReference());
                }
                executionContext.complete();
                continue;
            }
        }
        Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldScanAllRelationshipsInBatchesWithoutGetNumberOfPartitions(TestUtils.PartitionedScanAPI api) {
        PartitionedScan scan = this.read.allRelationshipsScan(10, CursorContext.NULL_CONTEXT);
        LongArrayList ids = new LongArrayList();
        try (Statement statement = this.tx.acquireStatement();
             ExecutionContext executionContext = this.tx.createExecutionContext();
             RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
            while (api.reservePartition(scan, relationships, this.tx, executionContext)) {
                while (relationships.next()) {
                    ids.add(relationships.relationshipReference());
                }
            }
            executionContext.complete();
        }
        Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
    }

    @ParameterizedTest
    @EnumSource(value=TestUtils.PartitionedScanAPI.class)
    void shouldHandleMorePartitionsThanRelationships(TestUtils.PartitionedScanAPI api) {
        LongArrayList ids = new LongArrayList();
        PartitionedScan scan = this.read.allRelationshipsScan(256, CursorContext.NULL_CONTEXT);
        for (int i = 0; i < scan.getNumberOfPartitions(); ++i) {
            try (Statement statement = this.tx.acquireStatement();
                 ExecutionContext executionContext = this.tx.createExecutionContext();
                 RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);){
                api.reservePartition(scan, relationships, this.tx, executionContext);
                while (relationships.next()) {
                    ids.add(relationships.relationshipReference());
                }
                executionContext.complete();
                continue;
            }
        }
        Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreads() throws InterruptedException, ExecutionException {
        PartitionedScan scan = this.read.allRelationshipsScan(4, CursorContext.NULL_CONTEXT);
        ExecutorService service = Executors.newFixedThreadPool(scan.getNumberOfPartitions());
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), scan.getNumberOfPartitions());
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(scan, workerContexts, RelationshipDataAccessor::relationshipReference));
            List ids = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(ids);
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)TestUtils.concat(ids).toSortedList());
        }
        finally {
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleRandomNumberOfPartitions() throws InterruptedException, ExecutionException {
        int desiredNumberOfPartitions = ThreadLocalRandom.current().nextInt(128) + 1;
        PartitionedScan scan = this.read.allRelationshipsScan(desiredNumberOfPartitions, CursorContext.NULL_CONTEXT);
        ExecutorService service = Executors.newFixedThreadPool(scan.getNumberOfPartitions());
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        String errorMessage = "Failed with: desiredNumberOfPartitions=" + desiredNumberOfPartitions;
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), scan.getNumberOfPartitions());
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(scan, workerContexts, REL_GET));
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES), (String)errorMessage);
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists, errorMessage);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat, (String)errorMessage);
        }
        finally {
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES), (String)errorMessage);
        }
    }

    static {
        REL_GET = RelationshipDataAccessor::relationshipReference;
    }
}

