/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.util.concurrent.Futures;

class ParallelRelationshipCursorTransactionStateTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    private static final ToLongFunction<RelationshipScanCursor> REL_GET = RelationshipDataAccessor::relationshipReference;

    ParallelRelationshipCursorTransactionStateTest() {
    }

    @Test
    void shouldHandleEmptyDatabase() throws TransactionFailureException {
        try (KernelTransaction tx = this.beginTransaction();){
            CursorContext cursorContext = tx.cursorContext();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                while (scan.reserveBatch((Cursor)cursor, 23, cursorContext, tx.securityContext().mode())) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    @Test
    void scanShouldNotSeeDeletedRelationships() throws Exception {
        int size = 100;
        MutableLongSet created = LongSets.mutable.empty();
        MutableLongSet deleted = LongSets.mutable.empty();
        try (final KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                created.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
                deleted.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            deleted.each((LongProcedure)new CheckedLongProcedure(){

                public void safeValue(long item) throws Exception {
                    tx.dataWrite().relationshipDelete(item);
                }
            });
            CursorContext cursorContext = tx.cursorContext();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                MutableLongSet seen = LongSets.mutable.empty();
                while (scan.reserveBatch((Cursor)cursor, 17, cursorContext, tx.securityContext().mode())) {
                    while (cursor.next()) {
                        long relationshipId = cursor.relationshipReference();
                        Assertions.assertTrue((boolean)seen.add(relationshipId));
                        Assertions.assertTrue((boolean)created.remove(relationshipId));
                    }
                }
                Assertions.assertTrue((boolean)created.isEmpty());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void scanShouldSeeAddedRelationships() throws Exception {
        int size = 100;
        MutableLongSet existing = this.createRelationships(size);
        MutableLongSet added = LongSets.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                added.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            CursorContext cursorContext = tx.cursorContext();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                MutableLongSet seen = LongSets.mutable.empty();
                while (scan.reserveBatch((Cursor)cursor, 17, cursorContext, tx.securityContext().mode())) {
                    while (cursor.next()) {
                        long relationshipId = cursor.relationshipReference();
                        Assertions.assertTrue((boolean)seen.add(relationshipId));
                        Assertions.assertTrue((existing.remove(relationshipId) || added.remove(relationshipId) ? 1 : 0) != 0);
                    }
                }
                Assertions.assertTrue((boolean)existing.isEmpty());
                Assertions.assertTrue((boolean)added.isEmpty());
            }
        }
    }

    @Test
    void shouldReserveBatchFromTxState() throws KernelException {
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < 11; ++i) {
                write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate());
            }
            CursorContext cursorContext = tx.cursorContext();
            AccessMode accessMode = tx.securityContext().mode();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 5, cursorContext, accessMode));
                Assertions.assertEquals((int)5, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 4, cursorContext, accessMode));
                Assertions.assertEquals((int)4, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 6, cursorContext, accessMode));
                Assertions.assertEquals((int)2, (int)TestUtils.count((Cursor)cursor));
                while (scan.reserveBatch((Cursor)cursor, 3, cursorContext, accessMode)) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreads() throws InterruptedException, ExecutionException, KernelException, IOException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        int size = 128;
        LongArrayList ids = new LongArrayList();
        ArrayList<RelationshipScanCursor> resources = new ArrayList<RelationshipScanCursor>();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                ids.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            Read read = tx.dataRead();
            Scan scan = read.allRelationshipsScan();
            AccessMode accessMode = tx.securityContext().mode();
            ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(numberOfWorkers);
            for (int i = 0; i < numberOfWorkers; ++i) {
                RelationshipScanCursor cursor = cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                resources.add(cursor);
                workers.add(TestUtils.singleBatchWorker(scan, cursor, CursorContext.NULL_CONTEXT, accessMode, REL_GET, size / numberOfWorkers));
            }
            List futures = service.invokeAll(workers);
            List lists = Futures.getAllResults(futures);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            IOUtils.closeAllUnchecked(resources);
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException, KernelException, IOException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        int size = 128;
        LongArrayList ids = new LongArrayList();
        ArrayList<RelationshipScanCursor> resources = new ArrayList<RelationshipScanCursor>();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                ids.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            Read read = tx.dataRead();
            Scan scan = read.allRelationshipsScan();
            AccessMode accessMode = tx.securityContext().mode();
            ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(numberOfWorkers);
            for (int i = 0; i < numberOfWorkers; ++i) {
                RelationshipScanCursor cursor = cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                resources.add(cursor);
                workers.add(TestUtils.singleBatchWorker(scan, cursor, CursorContext.NULL_CONTEXT, accessMode, REL_GET, size / numberOfWorkers));
            }
            List futures = service.invokeAll(workers);
            List lists = Futures.getAllResults(futures);
            IOUtils.closeAll(resources);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
        }
        finally {
            IOUtils.closeAllUnchecked(resources);
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipFromRandomlySizedWorkers() throws InterruptedException, KernelException, ExecutionException, IOException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        int size = 128;
        LongArrayList ids = new LongArrayList();
        ArrayList<RelationshipScanCursor> resources = new ArrayList<RelationshipScanCursor>();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                ids.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            Read read = tx.dataRead();
            Scan scan = read.allRelationshipsScan();
            CursorFactory cursors = this.testSupport.kernelToTest().cursors();
            int numberOfWorkers = 10;
            AccessMode accessMode = tx.securityContext().mode();
            ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(numberOfWorkers);
            for (int i = 0; i < numberOfWorkers; ++i) {
                RelationshipScanCursor cursor = cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                resources.add(cursor);
                workers.add(TestUtils.randomBatchWorker(scan, cursor, CursorContext.NULL_CONTEXT, accessMode, REL_GET));
            }
            List futures = service.invokeAll(workers);
            List lists = Futures.getAllResults(futures);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            IOUtils.closeAllUnchecked(resources);
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void parallelTxStateScanStressTest() throws InterruptedException, KernelException, ExecutionException, IOException {
        MutableLongSet existingRelationships = this.createRelationships(77);
        int numberOfWorkers = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = this.testSupport.kernelToTest().cursors();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                MutableLongSet allRels = LongSets.mutable.withAll((LongIterable)existingRelationships);
                ArrayList<RelationshipScanCursor> resources = new ArrayList<RelationshipScanCursor>();
                try (KernelTransaction tx = this.beginTransaction();){
                    int relationshipsInTx = random.nextInt(100);
                    Write write = tx.dataWrite();
                    int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
                    for (int j = 0; j < relationshipsInTx; ++j) {
                        allRels.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
                    }
                    Scan scan = tx.dataRead().allRelationshipsScan();
                    AccessMode accessMode = tx.securityContext().mode();
                    ArrayList<Callable<LongList>> workers = new ArrayList<Callable<LongList>>(numberOfWorkers);
                    for (int w = 0; w < numberOfWorkers; ++w) {
                        RelationshipScanCursor cursor = cursors.allocateRelationshipScanCursor(CursorContext.NULL_CONTEXT);
                        resources.add(cursor);
                        workers.add(TestUtils.randomBatchWorker(scan, cursor, CursorContext.NULL_CONTEXT, accessMode, REL_GET));
                    }
                    List futures = threadPool.invokeAll(workers);
                    List lists = Futures.getAllResults(futures);
                    TestUtils.assertDistinct(lists);
                    LongList concat = TestUtils.concat(lists);
                    Assertions.assertEquals((Object)allRels, (Object)LongSets.immutable.withAll((LongIterable)concat), (String)String.format("relationships=%d, seen=%d, all=%d", relationshipsInTx, concat.size(), allRels.size()));
                    Assertions.assertEquals((int)allRels.size(), (int)concat.size(), (String)String.format("relationships=%d", relationshipsInTx));
                    tx.rollback();
                    continue;
                }
                finally {
                    IOUtils.closeAllUnchecked(resources);
                }
            }
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private MutableLongSet createRelationships(int size) throws KernelException {
        MutableLongSet rels = LongSets.mutable.empty();
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                rels.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            tx.commit();
        }
        return rels;
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }
}

